<?php

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
    exit( 'Direct script access denied.' );
}

function la_yorn_get_demo_array($dir_url, $dir_path){

    $demo_items = array(
        'yorn-main-01' => array(
            'link' => 'https://yorn.la-studioweb.com/yorn-main-01/',
            'title' => 'Music Band',
            'title2' => 'Yorn Main 01',
            'data_elementor' => array(
                'header' => array(
                    'location' => 'header',
                    'value' => array(
                        'yorn-header-02' => 'include/general',
                    ),
                ),
                'footer' => array(
                    'location' => 'footer',
                    'value' => array(
                        'yorn-footer-03' => 'include/general',
                    ),
                ),
            ),
            'category' => array(
                0 => 'Demo',
            ),
            'data_slider' => '',
        ),
        'yorn-main-02' => array(
            'link' => 'https://yorn.la-studioweb.com/yorn-main-02/',
            'title' => 'Music Store',
            'title2' => 'Yorn Main 02',
            'data_elementor' => array(
                'header' => array(
                    'location' => 'header',
                    'value' => array(
                        'yorn-header-02' => 'include/general',
                    ),
                ),
                'footer' => array(
                    'location' => 'footer',
                    'value' => array(
                        'yorn-footer-01' => 'include/general',
                    ),
                ),
            ),
            'category' => array(
                0 => 'Demo',
            ),
            'data_slider' => '',
        ),
        'yorn-main-03' => array(
            'link' => 'https://yorn.la-studioweb.com/yorn-main-03/',
            'title' => 'Full Screen Show',
            'title2' => 'Yorn Main 03',
            'data_elementor' => array(
                'header' => array(
                    'location' => 'header',
                    'value' => array(
                        'yorn-header-03' => 'include/general',
                    ),
                ),
                'footer' => array(
                    'location' => 'footer',
                    'value' => array(
                        'yorn-footer-01' => 'include/general',
                    ),
                ),
            ),
            'category' => array(
                0 => 'Demo',
            ),
            'data_slider' => '',
        ),
        'yorn-main-04' => array(
            'link' => 'https://yorn.la-studioweb.com/yorn-main-04/',
            'title' => 'Product Showcase',
            'title2' => 'Yorn Main 04',
            'data_elementor' => array(
                'header' => array(
                    'location' => 'header',
                    'value' => array(
                        'yorn-header-03' => 'include/general',
                    ),
                ),
                'footer' => array(
                    'location' => 'footer',
                    'value' => array(
                        'yorn-footer-01' => 'include/general',
                    ),
                ),
            ),
            'category' => array(
                0 => 'Demo',
            ),
            'data_slider' => '',
        ),
        'yorn-main-05' => array(
            'link' => 'https://yorn.la-studioweb.com/yorn-main-05/',
            'title' => 'Music Studio',
            'title2' => 'Yorn Main 05',
            'data_elementor' => array(
                'header' => array(
                    'location' => 'header',
                    'value' => array(
                        'yorn-header-02' => 'include/general',
                    ),
                ),
                'footer' => array(
                    'location' => 'footer',
                    'value' => array(
                        'yorn-footer-02' => 'include/general',
                    ),
                ),
            ),
            'category' => array(
                0 => 'Demo',
            ),
            'data_slider' => '',
        ),
        'yorn-main-06' => array(
            'link' => 'https://yorn.la-studioweb.com/yorn-main-06/',
            'title' => 'Music Blog',
            'title2' => 'Yorn Main 06',
            'data_elementor' => array(
                'header' => array(
                    'location' => 'header',
                    'value' => array(
                        'yorn-header-02' => 'include/general',
                    ),
                ),
                'footer' => array(
                    'location' => 'footer',
                    'value' => array(
                        'yorn-footer-03' => 'include/general',
                    ),
                ),
            ),
            'category' => array(
                0 => 'Demo',
            ),
            'data_slider' => '',
        ),
        'yorn-main-07' => array(
            'link' => 'https://yorn.la-studioweb.com/yorn-main-07/',
            'title' => 'Music Left Sidebar',
            'title2' => 'Yorn Main 07',
            'data_elementor' => array(
                'header' => array(
                    'location' => 'header',
                    'value' => array(
                        'yorn-header-05' => 'include/general',
                    ),
                ),
                'footer' => array(
                    'location' => 'footer',
                    'value' => array(
                        'yorn-footer-03' => 'include/general',
                    ),
                ),
            ),
            'category' => array(
                0 => 'Demo',
            ),
            'data_slider' => '',
        ),
        'yorn-main-08' => array(
            'link' => 'https://yorn.la-studioweb.com/yorn-main-08/',
            'title' => 'Podcast Demo',
            'title2' => 'Yorn Main 08',
            'data_elementor' => array(
                'header' => array(
                    'location' => 'header',
                    'value' => array(
                        'yorn-header-04' => 'include/general',
                    ),
                ),
                'footer' => array(
                    'location' => 'footer',
                    'value' => array(
                        'yorn-footer-05' => 'include/general',
                    ),
                ),
            ),
            'category' => array(
                0 => 'Demo',
            ),
            'data_slider' => '',
        ),
        'yorn-main-09' => array(
            'link' => 'https://yorn.la-studioweb.com/yorn-main-09/',
            'title' => 'Video Tuber Demo ',
            'title2' => 'Yorn Main 09',
            'data_elementor' => array(
                'header' => array(
                    'location' => 'header',
                    'value' => array(
                        'yorn-header-05' => 'include/general',
                    ),
                ),
                'footer' => array(
                    'location' => 'footer',
                    'value' => array(
                        'yorn-footer-04' => 'include/general',
                    ),
                ),
            ),
            'category' => array(
                0 => 'Demo',
            ),
            'data_slider' => '',
        ),
    );

    $default_image_setting = array(
        'woocommerce_single_image_width' => 1000,
        'woocommerce_thumbnail_image_width' => 600,
        'woocommerce_thumbnail_cropping' => 'custom',
        'woocommerce_thumbnail_cropping_custom_width' => 5,
        'woocommerce_thumbnail_cropping_custom_height' => 6,
        'thumbnail_size_w' => 0,
        'thumbnail_size_h' => 0,
        'medium_size_w' => 0,
        'medium_size_h' => 0,
        'medium_large_size_w' => 0,
        'medium_large_size_h' => 0,
        'large_size_w' => 0,
        'large_size_h' => 0,
    );

    $default_menu = array(
        'main-nav'              => 'Yorn Primary Menu'
    );

    $default_page = array(
        'page_for_posts' 	            => 'Blog',
        'woocommerce_shop_page_id'      => 'Shop',
        'woocommerce_cart_page_id'      => 'Cart',
        'woocommerce_checkout_page_id'  => 'Checkout',
        'woocommerce_myaccount_page_id' => 'My Account'
    );

    $slider = $dir_path . 'Slider/';
    $content = $dir_path . 'Content/';
    $product = $dir_path . 'Product/';
    $widget = $dir_path . 'Widget/';
    $setting = $dir_path . 'Setting/';
    $preview = $dir_url;

    $default_elementor = [
        'single-post'       => [
            'location' => 'single',
            'value' => [
                'yorn-single-post-standard' => 'include/singular/post',
            ],
        ],
        'single-page'       => [
            'location' => 'single',
            'value' => '',
            'default' => [
                'yorn-woopages' => [
                    'include/singular/page/wishlist',
                    'include/singular/page/compare',
                    'include/singular/page/cart',
                    'include/singular/page/checkout'
                ],
            ]
        ],
        'archive'           => [
            'location' => 'archive',
            'value' => [
                'yorn-blog-right-sidebar' => 'include/archive'
            ]
        ],
        'search-results'    => [
            'location' => 'archive',
            'value' => '',
            'default' => [
                'yorn-search' => 'include/archive/search'
            ],
        ],
        'error-404'         => [
            'location' => 'single',
            'value'    => '',
            'default' => [
	            'yorn-404' => 'include/singular/not_found404'
            ],
        ],
        'product'           => [
            'location' => 'single',
            'value' => [
                'elementor-single-product-302' => 'include/product'
            ]
        ],
        'product-archive'   => [
            'location' => 'archive',
            'value' => [
                'yorn-shop-sidebar' => 'include/product_archive'
            ]
        ],
    ];

    $elementor_kit_settings = json_decode( file_get_contents( $setting . 'settings.json' ), true );

    $data_return = array();

    foreach ($demo_items as $demo_key => $demo_detail){
	    $value = array();

	    $value['title']             = $demo_detail['title'];
	    $value['category']          = !empty($demo_detail['category']) ? $demo_detail['category'] : array('Demo');
	    $value['demo_preset']       = $demo_key;
	    $value['demo_url']          = $demo_detail['link'];
	    $value['preview']           = !empty($demo_detail['preview']) ? $demo_detail['preview'] : ($preview . $demo_key . '.jpg');
	    $value['option']            = $setting . 'theme-setting.json';
	    $value['content']           = !empty($demo_detail['data_sample']) ? $content . $demo_detail['data_sample'] : $content . 'demo-data.json';
	    $value['product']           = !empty($demo_detail['data_product']) ? $product . $demo_detail['data_product'] : $product . 'products.csv';
	    $value['widget']            = !empty($demo_detail['data_widget']) ? $widget . $demo_detail['data_widget'] : $widget . 'widgets.json';
	    $value['pages']             = array_merge( $default_page, array( 'page_on_front' => $demo_detail['title2'] ));
	    $value['menu-locations']    = array_merge( $default_menu, isset($demo_detail['menu-locations']) ? $demo_detail['menu-locations'] : array());
	    $value['other_setting']     = array_merge( $default_image_setting, isset($demo_detail['other_setting']) ? $demo_detail['other_setting'] : array());
	    if(!empty($demo_detail['data_slider'])){
		    $value['slider'] = $slider . $demo_detail['data_slider'];
	    }
        $value['elementor']         = array_merge( $default_elementor, isset($demo_detail['data_elementor']) ? $demo_detail['data_elementor'] : array());
        $value['elementor_kit_settings']         = array_merge( $elementor_kit_settings, isset($demo_detail['elementor_kit_settings']) ? $demo_detail['elementor_kit_settings'] : array());
	    $data_return[$demo_key] = $value;
    }

    return $data_return;
}