<?php
/** header desktop **/
if ( ! function_exists( 'ronmi_header_builder' ) ) {
    function ronmi_header_builder (){
        $header_builder = '';    

        if ( is_page() ) {
            if ( function_exists('rwmb_meta') ) {
                global $wp_query;
                $metabox_hb = rwmb_meta( 'select_header', 'field_type=select_advanced', $wp_query->get_queried_object_id() );
                if ( !empty( $metabox_hb ) ) {
                    $header_builder = $metabox_hb;
                }else{
                    $header_builder = ronmi_get_option('header_layout');
                }
            } 
        }else{
            $header_builder = ronmi_get_option('header_layout');
        }

        if( empty( $header_builder ) ) {
            get_template_part('inc/frontend/header/header-default');
        }else{
            echo '<div class="header-desktop">';
            if ( did_action( 'elementor/loaded' ) ) {               
                echo \Elementor\Plugin::$instance->frontend->get_builder_content_for_display( $header_builder ); 
            }
            echo '</div>';
        }
    }
}

/** header mobile **/
if ( ! function_exists( 'ronmi_mobile_builder' ) ) {
    function ronmi_mobile_builder (){
        
        if ( is_page() ) {
            if ( function_exists('rwmb_meta') ) {
                global $wp_query;
                $metabox_hmb = rwmb_meta( 'select_header_mobile', 'field_type=select_advanced', $wp_query->get_queried_object_id() ); 
                if ( !empty( $metabox_hmb ) ) {
                    $mobile_builder = $metabox_hmb;
                }else{
                    $mobile_builder = ronmi_get_option('header_mobile');
                }
            } 
        }else{
            $mobile_builder = ronmi_get_option('header_mobile');
        }

        if( empty( $mobile_builder ) ) {
            get_template_part('inc/frontend/header/header-mobile');
        }else{
            echo '<div class="header-mobile">';
            if ( did_action( 'elementor/loaded' ) ) {               
                echo \Elementor\Plugin::$instance->frontend->get_builder_content_for_display( $mobile_builder ); 
            }
            echo '</div>';
        }
    }
}

/** side panel **/
if ( ! function_exists( 'ronmi_sidepanel_builder' ) ) {
    function ronmi_sidepanel_builder (){

        $panel_builder = ronmi_get_option('sidepanel_layout');

        if( empty( $panel_builder ) ) {
            return;
        }else{
            if ( did_action( 'elementor/loaded' ) ) {               
                echo \Elementor\Plugin::$instance->frontend->get_builder_content_for_display( $panel_builder ); 
            }
        }
    }
}

/** 404 template **/
if ( ! function_exists( 'ronmi_404_builder' ) ) {
    function ronmi_404_builder (){

        $error_404_builder = ronmi_get_option('page_404');

        if( empty( $error_404_builder ) ) { ?>
            <div class="error-404 not-found text-center">
                <div class="container">
                    <h1><?php wp_kses( _e( '404', 'ronmi' ), wp_kses_allowed_html('post')  ); ?></h1>
                    <h2><?php esc_html_e( 'Sorry! Page Not Found!', 'ronmi' ); ?></h2>
                    <div class="page-content">
                        <p><?php esc_html_e( 'Oops! The page you are looking for does not exist. Please return to the site’s homepage.', 'ronmi' ); ?></p>
                        <?php get_search_form(); ?>
                        <a class="octf-btn octf-btn-primary" href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php esc_html_e( 'Back to Home', 'ronmi' ); ?></a>
                    </div>
                </div>
            </div>
        <?php }else{
            if ( did_action( 'elementor/loaded' ) ) {               
                echo \Elementor\Plugin::$instance->frontend->get_builder_content_for_display( $error_404_builder ); 
            }
        }
    }
}

/** footer **/
if ( ! function_exists( 'ronmi_footer_builder' ) ) {
    function ronmi_footer_builder (){
        $footer_builder = '';    

        if ( is_page() ) {
            if ( function_exists('rwmb_meta') ) {
                global $wp_query;
                $metabox_fb = rwmb_meta( 'select_footer', 'field_type=select_advanced', $wp_query->get_queried_object_id() ); 
                if ( !empty( $metabox_fb ) ) {
                    $footer_builder = $metabox_fb;
                }else{
                    $footer_builder = ronmi_get_option('footer_layout');
                }
            } 
        }else{
            $footer_builder = ronmi_get_option('footer_layout');
        }

        if( empty( $footer_builder ) ) {
            return;
        }else{
            echo '<footer id="site-footer" class="site-footer" itemscope="itemscope" itemtype="http://schema.org/WPFooter">';
            if ( did_action( 'elementor/loaded' ) ) {               
                echo \Elementor\Plugin::$instance->frontend->get_builder_content_for_display( $footer_builder ); 
            }
            echo '</footer>';
        }
    }
}