<?php
namespace Elementor; // Custom widgets must be defined in the Elementor namespace
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly (security measure)

/**
 * Widget Name: Hotspots
 */
class Ronmi_Hotspots extends Widget_Base{

 	// The get_name() method is a simple one, you just need to return a widget name that will be used in the code.
	public function get_name() {
		return 'ot-hotspots';
	}

	// The get_title() method, which again, is a very simple one, you need to return the widget title that will be displayed as the widget label.
	public function get_title() {
		return __( 'OT Hotspots', 'ronmi' );
	}

	// The get_icon() method, is an optional but recommended method, it lets you set the widget icon. you can use any of the eicon or font-awesome icons, simply return the class name as a string.
	public function get_icon() {
		return 'eicon-image-hotspot';
	}

	// The get_categories method, lets you set the category of the widget, return the category name as a string.
	public function get_categories() {
		return [ 'category_ronmi' ];
	}

	protected function register_controls() {

		//Content Service box
		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Hotspots', 'ronmi' ),
			]
		);

		$this->add_control(
	       'hotspots_image',
	        [
	            'label' => esc_html__( 'Image', 'ronmi' ),
	            'type'  => Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
			  	],
		    ]
	    );

		$repeater = new Repeater();

		$repeater->add_control(
			'tooltip_title',
			[
				'label' => __( 'Tooltip', 'ronmi' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'Designer Chair', 'ronmi' ),
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'link',
			[
				'label' => __( 'Link', 'ronmi' ),
				'type' => Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'ronmi' ),
				'default'	=> [],
				'separator' => 'before',
			]
		);

		$repeater->add_control(
			'hotspots_offset_orientation_h',
			[
				'label' => esc_html__( 'Horizontal Orientation', 'ronmi' ),
				'type' => Controls_Manager::CHOOSE,
				'toggle' => false,
				'default' => 'start',
				'options' => [
					'start' => [
						'icon' => 'eicon-h-align-left',
					],
					'end' => [
						'icon' => 'eicon-h-align-right',
					],
				],
				'render_type' => 'ui',
				'separator' => 'before',
			]
		);

		$repeater->add_responsive_control(
			'hotspots_offset_x',
			[
				'label' => esc_html__( 'Offset', 'ronmi' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => -1000,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => -200,
						'max' => 200,
					],
					'vw' => [
						'min' => -200,
						'max' => 200,
					],
					'vh' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'default' => [
					'size' => '0',
				],
				'size_units' => [ 'px', '%', 'vw', 'vh' ],
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}}.ot-hotspots__item' => 'left: {{SIZE}}{{UNIT}}',
				],
				'condition' => [
					'hotspots_offset_orientation_h!' => 'end',
				],
			]
		);

		$repeater->add_responsive_control(
			'_offset_x_end',
			[
				'label' => esc_html__( 'Offset', 'ronmi' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => -1000,
						'max' => 1000,
						'step' => 0.1,
					],
					'%' => [
						'min' => -200,
						'max' => 200,
					],
					'vw' => [
						'min' => -200,
						'max' => 200,
					],
					'vh' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'default' => [
					'size' => '0',
				],
				'size_units' => [ 'px', '%', 'vw', 'vh' ],
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}}.ot-hotspots__item' => 'right: {{SIZE}}{{UNIT}}',
				],
				'condition' => [
					'hotspots_offset_orientation_h' => 'end',
				],
			]
		);

		$repeater->add_control(
			'hotspots_offset_orientation_v',
			[
				'label' => esc_html__( 'Vertical Orientation', 'ronmi' ),
				'type' => Controls_Manager::CHOOSE,
				'toggle' => false,
				'default' => 'start',
				'options' => [
					'start' => [
						'title' => esc_html__( 'Top', 'ronmi' ),
						'icon' => 'eicon-v-align-top',
					],
					'end' => [
						'title' => esc_html__( 'Bottom', 'ronmi' ),
						'icon' => 'eicon-v-align-bottom',
					],
				],
				'render_type' => 'ui',
			]
		);

		$repeater->add_responsive_control(
			'hotspots_offset_y',
			[
				'label' => esc_html__( 'Offset', 'ronmi' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => -1000,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => -200,
						'max' => 200,
					],
					'vh' => [
						'min' => -200,
						'max' => 200,
					],
					'vw' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'size_units' => [ 'px', '%', 'vh', 'vw' ],
				'default' => [
					'size' => '0',
				],
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}}.ot-hotspots__item' => 'top: {{SIZE}}{{UNIT}}',
				],
				'condition' => [
					'hotspots_offset_orientation_v!' => 'end',
				],
			]
		);

		$repeater->add_responsive_control(
			'hotspots_offset_y_end',
			[
				'label' => esc_html__( 'Offset', 'ronmi' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => -1000,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => -200,
						'max' => 200,
					],
					'vh' => [
						'min' => -200,
						'max' => 200,
					],
					'vw' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'size_units' => [ 'px', '%', 'vh', 'vw' ],
				'default' => [
					'size' => '0',
				],
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}}.ot-hotspots__item' => 'bottom: {{SIZE}}{{UNIT}}',
				],
				'condition' => [
					'hotspots_offset_orientation_v' => 'end',
				],
			]
		);

		$this->add_control(
			'ot_hotspots',
			[
				'label' => __( 'Hotspots Items', 'ronmi' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'tooltip_title' => __( 'Tooltip 1', 'ronmi' ),
					],
					[
						'tooltip_title' => __( 'Tooltip 2', 'ronmi' ),
					],
				],
				'title_field' => '{{{ tooltip_title }}}',
			]
		);

		$this->end_controls_section();

		//Style
		$this->start_controls_section(
			'style_section',
			[
				'label' => __( 'Hotspots', 'ronmi' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		//Title
		$this->add_control(
			'style_tooltip',
			[
				'label' => __( 'Tooltip', 'ronmi' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_responsive_control(
			'tooltip_space',
			[
				'label' => __( 'Spacing', 'ronmi' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .tooltip-content' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'tooltip_width',
			[
				'label' => __( 'Width', 'ronmi' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 100,
						'max' => 1000,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .ot-hotspots__tooltip' => 'min-width: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'tooltip_padding',
			[
				'label' => __( 'Padding', 'ronmi' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors' => [
					'{{WRAPPER}} .tooltip-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		
		$this->add_control(
			'tooltip_bgcolor',
			[
				'label' => __( 'Background', 'ronmi' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .tooltip-content' => 'background-color: {{VALUE}};',
				]
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'selector' => '{{WRAPPER}} .tooltip-content',
				'separator' => 'before',
			]
		);

		//Spots
		$this->add_control(
			'style_content',
			[
				'label' => __( 'Button', 'ronmi' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'content_color',
			[
				'label' => __( 'Color', 'ronmi' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .ot-hotspots__btn' => 'color: {{VALUE}};',
				]
			]
		);
		
		$this->add_responsive_control(
			'content_padding',
			[
				'label' => __( 'Padding', 'ronmi' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors' => [
					'{{WRAPPER}} .ot-hotspots__btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

	}

	protected function render() {
		$settings = $this->get_settings_for_display();

		?>

		<div class="ot-hotspots">
			<div class="ot-hotspots__image">
				<?php echo Group_Control_Image_Size::get_attachment_image_html( $settings, 'hotspots_image' ); ?>
			</div>
			<div class="ot-hotspots-wrap-item">
				<?php foreach ($settings['ot_hotspots'] as $index => $item) { ?>
				<div class="ot-hotspots__item elementor-repeater-item-<?php echo esc_attr($item['_id']) ?>">
					<?php
					if ( ! empty( $item['link']['url'] ) ) {
						$link_key = 'link_' . $index;

						$this->add_link_attributes( $link_key, $item['link'] );
						?>
						<a <?php $this->print_render_attribute_string( $link_key ); ?>>

						<?php
					} ?>
					<div class="ot-hotspots__btn">
						<span class="hotspots-point"></span>
					</div>
					<div class="ot-hotspots__tooltip">
						<p class="tooltip-content"><?php echo $item['tooltip_title']; ?></p>
					</div>
					<?php if ( ! empty( $item['link']['url'] ) ) : ?>
						</a>
					<?php endif; ?>
				</div>
				<?php } ?>
			</div>
	    </div>

	    <?php
	}

}
// After the Ronmi_Hotspots class is defined, I must register the new widget class with Elementor:
Plugin::instance()->widgets_manager->register_widget_type( new Ronmi_Hotspots() );