<?php
// Load the theme's custom Widgets so that they appear in the Elementor element panel.
add_action( 'elementor/widgets/widgets_registered', 'ronmi_register_elementor_widgets' );
function ronmi_register_elementor_widgets() {

    require_once( get_template_directory() . '/inc/backend/elementor/widgets/widgets.php' );
    require_once( get_template_directory() . '/inc/backend/elementor/widgets/header/widgets.php' );

}

// Add a custom 'category_ronmi' category for to the Elementor element panel so that our theme's widgets have their own category.
add_action( 'elementor/init', function() {
    \Elementor\Plugin::$instance->elements_manager->add_category( 
        'category_ronmi',
        [
            'title' => __( 'Ronmi Widgets', 'ronmi' ),
            'icon' => 'fa fa-plug', //default icon
        ],
        1 // position
    );
    \Elementor\Plugin::$instance->elements_manager->add_category( 
        'category_ronmi_header',
        [
            'title' => __( 'Ronmi Header Widgets', 'ronmi' ),
            'icon' => 'fa fa-plug', //default icon
        ],
        2 // position
    );
});

// Post types with Elementor
function ronmi_add_cpt_support() {
    
    //if exists, assign to $cpt_support var
    $cpt_support = get_option( 'elementor_cpt_support' );
    
    //check if option DOESN'T exist in db
    if( ! $cpt_support ) {
        $cpt_support = [ 'page', 'ot_portfolio', 'ot_header_builders', 'ot_footer_builders' ]; //create array of our default supported post types
        update_option( 'elementor_cpt_support', $cpt_support ); //write it to the database
    }
    
    //if it DOES exist, but portfolio is NOT defined
    else {
        $ot_portfolio       = in_array( 'ot_portfolio', $cpt_support );
        $ot_header_builders = in_array( 'ot_header_builders', $cpt_support );
        $ot_footer_builders = in_array( 'ot_footer_builders', $cpt_support );
        if( !$ot_portfolio ){
            $cpt_support[] = 'ot_portfolio'; //append to array
        }
        if( !$ot_header_builders ){
            $cpt_support[] = 'ot_header_builders'; //append to array
        }
        if( !$ot_footer_builders ){
            $cpt_support[] = 'ot_footer_builders'; //append to array
        }
        update_option( 'elementor_cpt_support', $cpt_support ); //update database
    }
    
    //otherwise do nothing, portfolio already exists in elementor_cpt_support option
}
add_action( 'elementor/init', 'ronmi_add_cpt_support' );

// Upload SVG for Elementor
function ronmi_unfiltered_files_upload() {
    
    //if exists, assign to $cpt_support var
    $cpt_support = get_option( 'elementor_unfiltered_files_upload' );
    
    //check if option DOESN'T exist in db
    if( ! $cpt_support ) {
        $cpt_support = '1'; //create string value default to enable upload svg
        update_option( 'elementor_unfiltered_files_upload', $cpt_support ); //write it to the database
    }
}
add_action( 'elementor/init', 'ronmi_unfiltered_files_upload' );

/**
 * Elementor Add News Custom Fonts
 */

add_filter( 'elementor/fonts/groups', function( $font_groups ) {
    $font_groups['ronmi_fonts'] = __( 'Ronmi Fonts', 'ronmi' );
    return $font_groups;
} );

// Filters the fonts used by Elementor to add additional fonts. //
add_filter( 'elementor/fonts/additional_fonts', function ( $additional_fonts ) {
    $additional_fonts['Palatino Linotype'] = 'ronmi_fonts';
    return $additional_fonts;
} );

// Header post type
add_action( 'init', 'ronmi_create_header_builder' ); 
function ronmi_create_header_builder() {
    register_post_type( 'ot_header_builders',
        array(
            'labels' => array(
                'name'              => esc_html__( 'Header Builder', 'ronmi' ),
                'singular_name'     => esc_html__( 'Header Builder', 'ronmi' ),
                'add_new'           => esc_html__( 'Add New', 'ronmi' ),
                'add_new_item'      => esc_html__( 'Add New Header', 'ronmi' ),
                'edit'              => esc_html__( 'Edit', 'ronmi' ),
                'edit_item'         => esc_html__( 'Edit Header', 'ronmi' ),
                'all_items'         => esc_html__( 'All Headers', 'ronmi' ),
                'new_item'          => esc_html__( 'New Header', 'ronmi' ),
                'view'              => esc_html__( 'View', 'ronmi' ),
                'view_item'         => esc_html__( 'View Header', 'ronmi' ),
                'search_items'      => esc_html__( 'Search Header', 'ronmi' ),
                'not_found'         => esc_html__( 'No Header found', 'ronmi' ),
                'not_found_in_trash'=> esc_html__( 'No Header found in Trash', 'ronmi' ),
                'parent'            => esc_html__( 'Parent Header', 'ronmi' )
            ),
            'hierarchical'          => false,
            'public'                => false,
            'show_ui'               => true,
            'menu_position'         => 60,
            'supports'              => array( 'title', 'editor' ),
            'menu_icon'             => 'dashicons-editor-kitchensink',
            'publicly_queryable'    => true, /* Required 'true' to work in Edit With Elementor */
            'exclude_from_search'   => true,
            'has_archive'           => false,
            'query_var'             => true,
            'can_export'            => true,
            'capability_type'       => 'post'
        )
    );
}

// Footer post type
add_action( 'init', 'ronmi_create_footer_builder' ); 
function ronmi_create_footer_builder() {
    register_post_type( 'ot_footer_builders',
        array(
            'labels' => array(
                'name'              => esc_html__( 'Footer Builder', 'ronmi' ),
                'singular_name'     => esc_html__( 'Footer Builder', 'ronmi' ),
                'add_new'           => esc_html__( 'Add New', 'ronmi' ),
                'add_new_item'      => esc_html__( 'Add New Footer', 'ronmi' ),
                'edit'              => esc_html__( 'Edit', 'ronmi' ),
                'edit_item'         => esc_html__( 'Edit Footer', 'ronmi' ),
                'all_items'         => esc_html__( 'All Footers', 'ronmi' ),
                'new_item'          => esc_html__( 'New Footer', 'ronmi' ),
                'view'              => esc_html__( 'View', 'ronmi' ),
                'view_item'         => esc_html__( 'View Footer', 'ronmi' ),
                'search_items'      => esc_html__( 'Search Footer Builders', 'ronmi' ),
                'not_found'         => esc_html__( 'No Footer found', 'ronmi' ),
                'not_found_in_trash'=> esc_html__( 'No Footer found in Trash', 'ronmi' ),
                'parent'            => esc_html__( 'Parent Footer', 'ronmi' )
            ),
            'hierarchical'          => false,
            'public'                => false,
            'show_ui'               => true,
            'menu_position'         => 60,
            'supports'              => array( 'title', 'editor' ),
            'menu_icon'             => 'dashicons-editor-kitchensink',
            'publicly_queryable'    => true, /* Required 'true' to work in Edit With Elementor */
            'exclude_from_search'   => true,
            'has_archive'           => false,
            'query_var'             => true,
            'can_export'            => true,
            'capability_type'       => 'post'
        )
    );
}

/*Fix Elementor Pro*/
function ronmi_register_elementor_locations( $elementor_theme_manager ) {

    $elementor_theme_manager->register_all_core_location();

}
add_action( 'elementor/theme/register_locations', 'ronmi_register_elementor_locations' );

/*** add options to sections ***/
add_action('elementor/element/section/section_structure/after_section_end', function( $section, $args ) {

    /* header options */
    $section->start_controls_section(
        'section_custom_class',
        [
            'label' => __( 'For Header', 'ronmi' ),
            'tab'   => \Elementor\Controls_Manager::TAB_LAYOUT,
        ]
    );
    $section->add_control(
        'sticky_class',
        [
            'label'        => __( 'Sticky On/Off', 'ronmi' ),
            'type'         => Elementor\Controls_Manager::SWITCHER,
            'return_value' => 'is-fixed',
            'prefix_class' => '',
        ]
    );
    $section->add_control(
        'sticky_background',
        [
            'label'     => __( 'Background Scroll', 'ronmi' ),
            'type'      => Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}}.is-stuck' => 'background: {{VALUE}};',
            ],
            'condition' => [
                'sticky_class' => 'is-fixed',
            ],
        ]
    );
    $section->add_responsive_control(
        'offset_space',
        [
            'label' => __( 'Offset', 'ronmi' ),
            'type' => Elementor\Controls_Manager::SLIDER,
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 200,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}}.is-stuck' => 'top: {{SIZE}}{{UNIT}};',
                '.admin-bar {{WRAPPER}}.is-stuck' => 'top: calc({{SIZE}}{{UNIT}} + 32px);',
            ],
            'condition' => [
                'sticky_class' => 'is-fixed',
            ],
        ]
    );

    $section->add_control(
        'header_bottom',
        [
            'label'        => __( 'Header Bottom For Home Page', 'ronmi' ),
            'type'         => Elementor\Controls_Manager::SWITCHER,
            'description' => esc_html__( 'Only work on desktop devices', 'ronmi' ),
            'return_value' => 'header-bottom',
            'prefix_class' => '',
            'condition' => [
                'sticky_class!' => 'is-fixed',
            ],
        ]
    );

    $section->end_controls_section();

}, 10, 2 );