<?php
namespace Elementor; // Custom widgets must be defined in the Elementor namespace
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly (security measure)

/**
 * Widget Name: Hover Box
 */
class Ronmi_Hover_Box extends Widget_Base{

 	// The get_name() method is a simple one, you just need to return a widget name that will be used in the code.
	public function get_name() {
		return 'ot-hover-box';
	}

	// The get_title() method, which again, is a very simple one, you need to return the widget title that will be displayed as the widget label.
	public function get_title() {
		return __( 'OT Image Hover Box', 'ronmi' );
	}

	// The get_icon() method, is an optional but recommended method, it lets you set the widget icon. you can use any of the eicon or font-awesome icons, simply return the class name as a string.
	public function get_icon() {
		return 'eicon-image';
	}

	// The get_categories method, lets you set the category of the widget, return the category name as a string.
	public function get_categories() {
		return [ 'category_ronmi' ];
	}

	protected function register_controls() {

		/*Content Image*/
		$this->start_controls_section(
			'section_side_a_content',
			[
				'label' => __( 'Image', 'ronmi' ),
			]
		);

		$this->add_control(
			'image_box',
			[
				'label' => __( 'Choose Image', 'ronmi' ),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);

		$this->end_controls_section();

		/*Content Overlay Hover*/
		$this->start_controls_section(
			'section_side_b_content',
			[
				'label' => __( 'Content Hover', 'ronmi' ),
			]
		);

		$this->add_control(
			'hover_box_back_icon_type',
			[
				'label'       => __( 'Icon Type', 'ronmi' ),
				'type'        => Controls_Manager::SELECT,
				'default'     => 'icon',
				'options'     => [
					'icon'      => __( 'Font Icon', 'ronmi' ),
					'image'     => __( 'Custom Image', 'ronmi' ),
				],
				'label_block' => true,
			]
		);

		$this->add_control(
			'hover_box_back_icon',
			[
				'label'            => __( 'Icon', 'ronmi' ),
				'type'             => Controls_Manager::ICONS,
				'fa4compatibility' => 'icon',
				'default'          => [
					'value'   => 'fas fa-star',
					'library' => 'fa-solid',
				],
				'condition'        => [
					'hover_box_back_icon_type'   => 'icon',
				],
			]
		);

		$this->add_control(
			'hover_box_back_icon_image',
			[
				'label'       => __( 'Image', 'ronmi' ),
				'type'        => Controls_Manager::MEDIA,
				'default'     => [
					'url' => Utils::get_placeholder_image_src(),
				],
				'condition'   => [
					'hover_box_back_icon_type'   => 'image',
				],
			]
		);
		$this->add_control(
			'title_text',
			[
				'label' => __( 'Title & Description', 'ronmi' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'Somerset', 'ronmi' ),
				'placeholder' => __( 'Enter your title', 'ronmi' ),
			]
		);

		$this->add_control(
			'description_text',
			[
				'label' => __( 'Description', 'ronmi' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => __( 'Everything that slows us down and forces patience, everything that', 'ronmi' ),
				'placeholder' => __( 'Enter your description', 'ronmi' ),
			]
		);

		$this->add_control(
			'link',
			[
				'label' => __( 'Link', 'ronmi' ),
				'type' => Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'ronmi' ),
			]
		);

		$this->end_controls_section();

		//Style
		$this->start_controls_section(
			'style_section',
			[
				'label' => __( 'Overlay Content', 'ronmi' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		//Overlay
		$this->add_control(
			'background_overlay',
			[
				'label' => __( 'Background Overlay', 'ronmi' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ot-hover-box__content' => 'background-color: {{VALUE}};',
				]
			]
		);

		$this->add_control(
			'padding_box',
			[
				'label' => __( 'Padding', 'ronmi' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .ot-hover-box__content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		//Icon/Image
		$this->add_control(
			'heading_icon',
			[
				'label' => __( 'Icon/Image', 'ronmi' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'icon_spacing',
			[
				'label' => __( 'Spacing', 'ronmi' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'max' => 50,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .box-content-inner svg, {{WRAPPER}} .box-content-inner i, {{WRAPPER}} .box-content-inner img' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'icon_size',
			[
				'label' => __( 'Size', 'ronmi' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 6,
						'max' => 200,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .box-content-inner i' => 'font-size: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .box-content-inner svg' => 'width: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .box-content-inner img' => 'max-width: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
			'icon_color',
			[
				'label' => __( 'Color', 'ronmi' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .box-content-inner i' => 'color: {{VALUE}};',
					'{{WRAPPER}} .box-content-inner svg' => 'fill: {{VALUE}};'
				],
			]
		);

		//Title
		$this->add_control(
			'heading_title',
			[
				'label' => __( 'Title', 'ronmi' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		
		$this->add_responsive_control(
			'title_space',
			[
				'label' => __( 'Spacing', 'ronmi' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .box-content-inner h5' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
			'title_color',
			[
				'label' => __( 'Color', 'ronmi' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .box-content-inner h5' => 'color: {{VALUE}};',
				]
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'selector' => '{{WRAPPER}} .box-content-inner h5',
			]
		);

		//Description
		$this->add_control(
			'heading_content',
			[
				'label' => __( 'Description', 'ronmi' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		
		$this->add_control(
			'content_color',
			[
				'label' => __( 'Color', 'ronmi' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .box-content-inner p' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'content_typography',
				'selector' => '{{WRAPPER}} .box-content-inner p',
			]
		);

		$this->end_controls_section();

	}

	protected function render() {
		$settings = $this->get_settings_for_display();

		if ( ! empty( $settings['link']['url'] ) ) {
			$this->add_link_attributes( 'link_box', $settings['link'] );
		}
		$this->add_render_attribute( 'link_box', 'class', 'ot-hover-box__link' );

		?>

		<div class="ot-hover-box">
			<?php if ( ! empty( $settings['link']['url'] ) ) { ?>
			<a <?php echo $this->get_render_attribute_string( 'link_box' ) ?>></a>
			<?php } ?>
			<div class="ot-hover-box__image">
				<?php echo Group_Control_Image_Size::get_attachment_image_html( $settings, 'image_box' ); ?>
			</div>
			<div class="ot-hover-box__content">
				<div class="flex-middle">
					<div class="box-content-inner">
						<?php if( $settings['title_text'] ) { echo '<h5>' .$settings['title_text']. '</h5>'; } ?>
						<?php if( $settings['hover_box_back_icon_type'] == 'icon' ){ 
					    	Icons_Manager::render_icon( $settings['hover_box_back_icon'], [ 'aria-hidden' => 'true' ] );
				    	} elseif( $settings['hover_box_back_icon_type'] == 'image' ){ 
					    	echo Group_Control_Image_Size::get_attachment_image_html( $settings, 'hover_box_back_icon_image' );
				    	} ?>
						<?php if( $settings['description_text'] ) { echo '<p>' .$settings['description_text']. '</p>'; } ?>
					</div>
				</div>
			</div>
	    </div>

	    <?php
	}

}
// After the Ronmi_Hover_Box class is defined, I must register the new widget class with Elementor:
Plugin::instance()->widgets_manager->register_widget_type( new Ronmi_Hover_Box() );