<?php
namespace Elementor; // Custom widgets must be defined in the Elementor namespace
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly (security measure)

/**
 * Widget Name: Menu
 */
class Ronmi_Menu extends Widget_Base{

 	// The get_name() method is a simple one, you just need to return a widget name that will be used in the code.
	public function get_name() {
		return 'imenu';
	}

	// The get_title() method, which again, is a very simple one, you need to return the widget title that will be displayed as the widget label.
	public function get_title() {
		return __( 'OT Nav Menu', 'ronmi' );
	}

	// The get_icon() method, is an optional but recommended method, it lets you set the widget icon. you can use any of the eicon or font-awesome icons, simply return the class name as a string.
	public function get_icon() {
		return 'eicon-nav-menu';
	}

	// The get_categories method, lets you set the category of the widget, return the category name as a string.
	public function get_categories() {
		return [ 'category_ronmi_header' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Menu', 'ronmi' ),
			]
		);

		$menus = $this->get_available_menus();
		$this->add_control(
			'nav_menu',
			[
				'label' => esc_html__( 'Select Menu', 'ronmi' ),
				'type' => Controls_Manager::SELECT,
				'multiple' => false,
				'options' => $menus,
				'default' => array_keys( $menus )[0],
				'save_default' => true,

			]
		);
		$this->add_control(
			'layout_menu',
			[
				'label' => __( 'Layout', 'ronmi' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'horizontal',
				'options' => [
					'horizontal' => __( 'Horizontal', 'ronmi' ),
					'vertical' => __( 'Vertical', 'ronmi' ),
				],
			]
		);
		$this->add_responsive_control(
			'align',
			[
				'label' => __( 'Alignment', 'ronmi' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left'    => [
						'title' => __( 'Left', 'ronmi' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => __( 'Center', 'ronmi' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => __( 'Right', 'ronmi' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'selectors' => [
					'{{WRAPPER}},
					 {{WRAPPER}} .vertical-main-navigation ul li' => 'text-align: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();

		/*** Style ***/
		// Menu parents
		$this->start_controls_section(
			'style_menu_section',
			[
				'label' => __( 'Menu Parents', 'ronmi' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'text_color',
			[
				'label' => __( 'Text Color', 'ronmi' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .main-navigation > ul > li > a,
					 {{WRAPPER}} .main-navigation > ul > li.is-mega-menu > a:after,
					 {{WRAPPER}} .main-navigation > ul > li > a.mPS2id-highlight,
					 {{WRAPPER}} .vertical-main-navigation ul > li > a' => 'color: {{VALUE}} '
				]
			]
		);
		$this->add_control(
			'text_hover_color',
			[
				'label' => __( 'Text Hover/Active Color', 'ronmi' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .main-navigation > ul > li > a:hover, 
					 {{WRAPPER}} .main-navigation > ul > li.current-menu-item > a, 
					 {{WRAPPER}} .vertical-main-navigation ul > li > a:hover,
					 {{WRAPPER}} .vertical-main-navigation > ul > li.current-menu-item > a,
					 {{WRAPPER}} .main-navigation > ul > li > a.mPS2id-highlight' => 'color: {{VALUE}};'
				]
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'menu_typography',
				'selector' => '{{WRAPPER}} .main-navigation > ul > li > a, {{WRAPPER}} .vertical-main-navigation > ul > li > a',
			]
		);

		$this->end_controls_section();

		//menu child
		$this->start_controls_section(
			'style_smenu_section',
			[
				'label' => __( 'Dropdown Menus', 'ronmi' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_responsive_control(
			'smenu_width',
			[
				'label' => __( 'Width', 'ronmi' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 200,
						'max' => 500,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .main-navigation ul ul.sub-menu:not(.sub-mega-menu)' => 'min-width: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'layout_menu' => 'horizontal'
				]
			]
		);
		$this->add_control(
			'bg_s_color',
			[
				'label' => __( 'Background Color', 'ronmi' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .main-navigation ul ul.sub-menu:not(.sub-mega-menu), 
					{{WRAPPER}} .main-navigation ul ul.sub-menu:before' => 'background-color: {{VALUE}};',
				],
				'condition' => [
					'layout_menu' => 'horizontal'
				]
			]
		);
		$this->add_control(
			'text_s_color',
			[
				'label' => __( 'Text Color', 'ronmi' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .main-navigation > ul ul:not(.sub-mega-menu, .elementor-icon-list-items, .ot-icon-list-items) a,
					 {{WRAPPER}} .vertical-main-navigation > ul ul a' => 'color: {{VALUE}};',
				]
			]
		);
		$this->add_control(
			'text_s_hover_color',
			[
				'label' => __( 'Text Hover/Active Color', 'ronmi' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .main-navigation > ul ul:not(.sub-mega-menu, .elementor-icon-list-items, .ot-icon-list-items) li:hover > a,
					 {{WRAPPER}} .main-navigation > ul ul:not(.sub-mega-menu, .elementor-icon-list-items, .ot-icon-list-items) li.current-menu-item > a, 
					 {{WRAPPER}} .vertical-main-navigation > ul ul li > a:hover' => 'color: {{VALUE}};'
				]
			]
		);
		$this->add_control(
			'bg_s_hover_color',
			[
				'label' => __( 'Background Hover Color', 'ronmi' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .main-navigation > ul ul:not(.sub-mega-menu, .elementor-icon-list-items, .ot-icon-list-items) li:hover > a, 
					 {{WRAPPER}} .main-navigation > ul ul:not(.sub-mega-menu, .elementor-icon-list-items, .ot-icon-list-items) li.current-menu-item > a' => 'background: {{VALUE}};',
				],
				'condition' => [
					'layout_menu' => 'horizontal'
				]
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'smenu_typography',
				'selector' => '{{WRAPPER}} .main-navigation > ul ul:not(.sub-mega-menu) a, {{WRAPPER}} .vertical-main-navigation > ul ul:not(.sub-mega-menu) li > a',
			]
		);

		$this->end_controls_section();

	}

	protected function get_available_menus(){

		$menus = wp_get_nav_menus();

		$options = [];

		foreach ( $menus as $menu ) {
			$options[ $menu->slug ] = $menu->name;
		}

		return $options;
   }

	protected function render() {
		$settings = $this->get_settings_for_display();
		if ( ! function_exists( 'is_plugin_active_for_network' ) ) {
		require_once( ABSPATH . '/wp-admin/includes/plugin.php' );
		}

		// multisite
		if ( is_multisite() ) {
			// this plugin is network activated - Mega menu must be network activated
			if ( is_plugin_active_for_network( plugin_basename(__FILE__) ) ) {
				$active_mmenu = is_plugin_active_for_network('ot_mega-menu/ot_mega-menu.php') ? true : false;
			// this plugin is locally activated - Mega menu can be network or locally activated
			} else {
				$active_mmenu = is_plugin_active( 'ot_mega-menu/ot_mega-menu.php') ? true : false;
			}
		// this plugin runs on a single site
		} else {
			$active_mmenu = is_plugin_active( 'ot_mega-menu/ot_mega-menu.php') ? true : false;
		}

		$menu_class = $settings['layout_menu'] == 'horizontal' ? 'main-navigation' : 'vertical-main-navigation';
		?>
			
	    	<nav id="site-navigation" class="<?php echo esc_attr($menu_class); ?>">			
				<?php
					wp_nav_menu( array(
						'menu' 			 => $settings['nav_menu'],
						'menu_id'        => 'primary-menu',
						'container'      => 'ul',
						'theme_location' => '__no_such_location',
    					'fallback_cb'    => '__return_empty_string', 
						'walker'         => $active_mmenu && $settings['layout_menu'] == 'horizontal' ? new \Ot_Mega_Menu_Walker() : '',
						'link_before'    => '<span>',
  						'link_after'     => '</span>'
					) );
				?>
			</nav>
			
	    <?php
	}
}
// After the Ronmi_Menu class is defined, I must register the new widget class with Elementor:
Plugin::instance()->widgets_manager->register_widget_type( new Ronmi_Menu() );