<?php

use Elementor\Plugin;

if (!function_exists('pr')) {

    function pr($ar) {
        echo '<pre>';
        print_r($ar);
        echo '</pre>';
    }

}

if (!function_exists('eead_html_tags')) {

    function eead_html_tags() {
        $html_tags = [
            'div' => 'div',
            'span' => 'span',
            'p' => 'p',
            'h1' => 'H1',
            'h2' => 'H2',
            'h3' => 'H3',
            'h4' => 'H4',
            'h5' => 'H5',
            'h6' => 'H6',
        ];

        return $html_tags;
    }

}

if (!function_exists('eead_check_allowed_html_tags')) {

    function eead_check_allowed_html_tags($tag, $default_tag = "h4") {
        $allowed_tags = eead_html_tags();
        if (in_array($tag, $allowed_tags)) {
            return $tag;
        } else {
            return $default_tag;
        }
    }

}

if (!function_exists('parse_wisiwyg_content')) {

    function parse_wisiwyg_content($content) {
        $content = shortcode_unautop($content);
        $content = do_shortcode($content);
        $content = wptexturize($content);
        if ($GLOBALS['wp_embed'] instanceof \WP_Embed) {
            $content = $GLOBALS['wp_embed']->autoembed($content);
        }
        return $content;
    }

}

if (!function_exists('get_pages')) {

    function get_pages() {
        $pages = get_pages();

        $_pages = [];

        foreach ($pages as $key => $object) {
            $_pages[$object->ID] = ucfirst($object->post_title);
        }

        return $_pages;
    }

}

if (!function_exists('get_element_position')) {

    function get_element_position() {
        $position_options = [
            'top left' => esc_html__('Top Left', 'easy-elementor-addons'),
            'top center' => esc_html__('Top Center', 'easy-elementor-addons'),
            'top right' => esc_html__('Top Right', 'easy-elementor-addons'),
            'center center' => esc_html__('Center Center', 'easy-elementor-addons'),
            'center left' => esc_html__('Center Left', 'easy-elementor-addons'),
            'center right' => esc_html__('Center Right', 'easy-elementor-addons'),
            'bottom left' => esc_html__('Bottom Left', 'easy-elementor-addons'),
            'bottom center' => esc_html__('Bottom Center', 'easy-elementor-addons'),
            'bottom right' => esc_html__('Bottom Right', 'easy-elementor-addons'),
        ];

        return $position_options;
    }

}

if (!function_exists('eead_anime_animation_easing')) {

    function eead_anime_animation_easing() {
        return array(
            'linear' => esc_html__('Linear', 'easy-elementor-addons'),
            'easeOutQuad' => esc_html__('Ease-Out Quad', 'easy-elementor-addons'),
            'easeInQuad' => esc_html__('Ease-In Quad', 'easy-elementor-addons'),
            'easeInOutQuad' => esc_html__('Ease-InOut Quad', 'easy-elementor-addons'),

            'easeOutCubic' => esc_html__('Ease-Out Cubic', 'easy-elementor-addons'),
            'easeInCubic' => esc_html__('Ease-In Cubic', 'easy-elementor-addons'),
            'easeInOutCubic' => esc_html__('Ease-InOut Cubic', 'easy-elementor-addons'),

            'easeOutQuart' => esc_html__('Ease-Out Quart', 'easy-elementor-addons'),
            'easeInQuart' => esc_html__('Ease-In Quart', 'easy-elementor-addons'),
            'easeInOutQuart' => esc_html__('Ease-InOut Quart', 'easy-elementor-addons'),

            'easeOutQuint' => esc_html__('ease-Out Quint', 'easy-elementor-addons'),
            'easeInQuint' => esc_html__('ease-In Quint', 'easy-elementor-addons'),
            'easeInOutQuint' => esc_html__('ease-InOut Quint', 'easy-elementor-addons'),

            'easeOutSine' => esc_html__('Ease-Out Sine', 'easy-elementor-addons'),
            'easeInSine' => esc_html__('Ease-In Sine', 'easy-elementor-addons'),
            'easeInOutSine' => esc_html__('Ease-InOut Sine', 'easy-elementor-addons'),

            'easeOutExpo' => esc_html__('Ease-Out Expo', 'easy-elementor-addons'),
            'easeInExpo' => esc_html__('Ease-In Expo', 'easy-elementor-addons'),
            'easeInOutExpo' => esc_html__('Ease-InOut Expo', 'easy-elementor-addons'),

            'easeOutElastic' => esc_html__('Ease-Out Elastic', 'easy-elementor-addons'),
            'easeInElastic' => esc_html__('Ease-In Elastic', 'easy-elementor-addons'),
            'easeInOutElastic' => esc_html__('Ease-InOut Elastic', 'easy-elementor-addons'),

            'easeOutCirc' => esc_html__('Ease-Out Circ', 'easy-elementor-addons'),
            'easeInCirc' => esc_html__('Ease-In Circ', 'easy-elementor-addons'),
            'easeInOutCirc' => esc_html__('Ease-InOut Circ', 'easy-elementor-addons'),

            'easeOutBack' => esc_html__('Ease-Out Back', 'easy-elementor-addons'),
            'easeInBack' => esc_html__('Ease-In Back', 'easy-elementor-addons'),
            'easeInOutBack' => esc_html__('Ease-InOut Back', 'easy-elementor-addons'),

            'easeOutBounce' => esc_html__('Ease-Out Bounce', 'easy-elementor-addons'),
            'easeInBounce' => esc_html__('Ease-In Bounce', 'easy-elementor-addons'),
            'easeInOutBounce' => esc_html__('Ease-InOut Bounce', 'easy-elementor-addons'),
        );
    }
}

if (!function_exists('eead_show_animations')) {
    function eead_show_animations() {
        $animations = [
            'none' => 'No Animation',
            'fadeIn' => 'fadeIn',
            'fadeInLeft' => 'fadeInLeft',
            'fadeInRight' => 'fadeInRight',
            'fadeInUp' => 'fadeInUp',
            'fadeInDown' => 'fadeInDown',
            'zoomIn' => 'zoomIn',
            'zoomInDown' => 'zoomInDown',
            'zoomInLeft' => 'zoomInLeft',
            'zoomInRight' => 'zoomInRight',
            'zoomInUp' => 'zoomInUp',
            'bounceIn' => 'bounceIn',
            'bounceInDown' => 'bounceInDown',
            'bounceInLeft' => 'bounceInLeft',
            'bounceInRight' => 'bounceInRight',
            'bounceInUp' => 'bounceInUp',
            'slideInUp' => 'slideInUp',
            'slideInDown' => 'slideInDown',
            'slideInLeft' => 'slideInLeft',
            'slideInRight' => 'slideInRight',
            'flipInX' => 'flipInX',
            'flipInY' => 'flipInY',
            'rotateIn' => 'rotateIn',
            'rotateInDownLeft' => 'rotateInDownLeft',
            'rotateInDownRight' => 'rotateInDownRight',
            'rotateInUpLeft' => 'rotateInUpLeft',
            'rotateInUpRight' => 'rotateInUpRight',
            'rollIn' => 'rollIn'
        ];
        return $animations;
    }
}

if (!function_exists('eead_show_animations_alt')) {
    function eead_show_animations_alt() {
        $animations = [
            'none' => 'No Animation',
            'fadeIn' => 'fadeIn',
            'fadeInLeftSmall' => 'fadeInLeft',
            'fadeInRightSmall' => 'fadeInRight',
            'fadeInUpSmall' => 'fadeInUp',
            'fadeInDownSmall' => 'fadeInDown',
            'zoomIn' => 'zoomIn',
            'zoomInDown' => 'zoomInDown',
            'zoomInLeft' => 'zoomInLeft',
            'zoomInRight' => 'zoomInRight',
            'zoomInUp' => 'zoomInUp',
            'bounceIn' => 'bounceIn',
            'bounceInDownSmall' => 'bounceInDown',
            'bounceInLeftSmall' => 'bounceInLeft',
            'bounceInRightSmall' => 'bounceInRight',
            'bounceInUpSmall' => 'bounceInUp',
            'flipInX' => 'flipInX',
            'flipInY' => 'flipInY',
            'rotateIn' => 'rotateIn',
            'rotateInDownLeft' => 'rotateInDownLeft',
            'rotateInDownRight' => 'rotateInDownRight',
            'rotateInUpLeft' => 'rotateInUpLeft',
            'rotateInUpRight' => 'rotateInUpRight',
        ];
        return $animations;
    }
}

if (!function_exists('eead_slider_animations')) {
    function eead_slider_animations() {
        $animations = [
            'none' => 'No Animation',
            'fade-in' => 'FadeIn',
            'scale-in-center' => 'ScaleInCenter',
            'slide-in-top' => 'SlideInTop',
            'slide-in-bottom' => 'SlideInBottom',
            'slide-in-left' => 'SlideInLeft',
            'slide-in-right' => 'SlideInRight',
            'rotate-in-2-fwd-cw' => 'RotateInForwardClockWise',
            'rotate-in-2-fwd-ccw' => 'RotateInForwardCounterClockWise',
            'rotate-in-hor' => 'RotateInHorizontal',
            'flip-in-hor' => 'FlipInHorizontal',
            'flip-in-ver-left' => 'FlipInVerticalLeft',
            'flip-in-ver-right' => 'FlipInVerticalRight',
            'bounce-in-top' => 'BounceInTop',
            'bounce-in-bottom' => 'BounceInBottom',
            'bounce-in-left' => 'BounceInLeft',
            'bounce-in-right' => 'BounceInRight',
            'bounce-in-fwd' => 'BounceInForward',
            'bounce-in-bck' => 'BounceInBackward',
            'swing-in-top-fwd' => 'SwingInTopForward',
            'swing-in-bottom-fwd' => 'SwingInBottomForward',
            'swing-in-left-fwd' => 'SwingInLeftForward',
            'swing-in-right-fwd' => 'SwingInRightForward',
            'puff-in-center' => 'PuffInCenter',
        ];
        return $animations;
    }
}

if (!function_exists('eead_svg_icon')) {

    function eead_svg_icon($icon) {

        $icon_path = EEAD_ASSETS_URL . "img/svg/{$icon}.svg";
        if (!file_exists($icon_path)) {
            return false;
        }

        ob_start();
        include $icon_path;
        $svg = ob_get_clean();

        return $svg;
    }

}

if (!function_exists('eead_allow_tags')) {

    function eead_allow_tags($tag = NULL) {
        $tag_allowed = wp_kses_allowed_html('post');

        $tag_allowed['input'] = [
            'class' => [],
            'id' => [],
            'name' => [],
            'value' => [],
            'checked' => [],
            'type' => [],
        ];
        $tag_allowed['select'] = [
            'class' => [],
            'id' => [],
            'name' => [],
            'value' => [],
            'multiple' => [],
            'type' => [],
        ];
        $tag_allowed['option'] = [
            'value' => [],
            'selected' => [],
        ];

        $tag_allowed['title'] = [
            'a' => [
                'href' => [],
                'title' => [],
                'class' => [],
            ],
            'br' => [],
            'em' => [],
            'strong' => [],
            'hr' => [],
        ];

        $tag_allowed['text'] = [
            'a' => [
                'href' => [],
                'title' => [],
                'class' => [],
            ],
            'br' => [],
            'em' => [],
            'strong' => [],
            'hr' => [],
            'i' => [
                'class' => [],
            ],
            'span' => [
                'class' => [],
            ],
        ];

        $tag_allowed['svg'] = [
            'svg' => [
                'version' => [],
                'xmlns' => [],
                'viewbox' => [],
                'xml:space' => [],
                'xmlns:xlink' => [],
                'x' => [],
                'y' => [],
                'style' => [],
            ],
            'g' => [],
            'path' => [
                'class' => [],
                'd' => [],
            ],
            'ellipse' => [
                'class' => [],
                'cx' => [],
                'cy' => [],
                'rx' => [],
                'ry' => [],
            ],
            'circle' => [
                'class' => [],
                'cx' => [],
                'cy' => [],
                'r' => [],
            ],
            'rect' => [
                'x' => [],
                'y' => [],
                'transform' => [],
                'height' => [],
                'width' => [],
                'class' => [],
            ],
            'line' => [
                'class' => [],
                'x1' => [],
                'x2' => [],
                'y1' => [],
                'y2' => [],
            ],
            'style' => [],
        ];

        if ($tag == NULL) {
            return $tag_allowed;

        } elseif (is_array($tag)) {
            $new_tag_allow = [];

            foreach ($tag as $_tag) {
                $new_tag_allow[$_tag] = $tag_allowed[$_tag];
            }
            return $new_tag_allow;

        } else {
            return isset($tag_allowed[$tag]) ? $tag_allowed[$tag] : [];
        }
    }

}

if (!function_exists('get_elementor_templates')) {

    function get_elementor_templates() {

        $templates = Plugin::$instance->templates_manager->get_source('local')->get_items();
        $types = [];

        if (empty($templates)) {
            $template_options = ['0' => esc_html__('Template Not Found!', 'easy-elementor-addons')];

        } else {
            $template_options = ['0' => esc_html__('Select Template', 'easy-elementor-addons')];
            foreach ($templates as $template) {
                $template_options[$template['template_id']] = $template['title'] . ' (' . $template['type'] . ')';
                $types[$template['template_id']] = $template['type'];
            }
        }

        return $template_options;
    }

}

if (!function_exists('eead_plugin_instance')) {

    function eead_plugin_instance() {
        return Plugin::$instance;
    }

}

if (!function_exists('eead_button_sizes')) {

    function eead_button_sizes() {
        $btn_sizes = [
            'xs' => esc_html__('Extra Small', 'easy-elementor-addons'),
            'sm' => esc_html__('Small', 'easy-elementor-addons'),
            'md' => esc_html__('Medium', 'easy-elementor-addons'),
            'lg' => esc_html__('Large', 'easy-elementor-addons'),
            'xl' => esc_html__('Extra Large', 'easy-elementor-addons'),
        ];

        return $btn_sizes;
    }

}

if (!function_exists('eead_drop_position')) {

    function eead_drop_position() {
        $drop_positions = [
            'left-top' => esc_html__('Left Top', 'easy-elementor-addons'),
            'left-center' => esc_html__('Left Center', 'easy-elementor-addons'),
            'left-bottom' => esc_html__('Left Bottom', 'easy-elementor-addons'),
            'right-top' => esc_html__('Right Top', 'easy-elementor-addons'),
            'right-center' => esc_html__('Right Center', 'easy-elementor-addons'),
            'right-bottom' => esc_html__('Right Bottom', 'easy-elementor-addons'),
            'top-left' => esc_html__('Top Left', 'easy-elementor-addons'),
            'top-center' => esc_html__('Top Center', 'easy-elementor-addons'),
            'top-right' => esc_html__('Top Right', 'easy-elementor-addons'),
            'top-justify' => esc_html__('Top Justify', 'easy-elementor-addons'),
            'bottom-left' => esc_html__('Bottom Left', 'easy-elementor-addons'),
            'bottom-center' => esc_html__('Bottom Center', 'easy-elementor-addons'),
            'bottom-right' => esc_html__('Bottom Right', 'easy-elementor-addons'),
            'bottom-justify' => esc_html__('Bottom Justify', 'easy-elementor-addons'),
        ];

        return $drop_positions;
    }

}

if (!function_exists('eead_transition_options')) {

    function eead_transition_options() {

        $transition_options = [
            '' => esc_html__('None', 'easy-elementor-addons'),
            'fade' => esc_html__('Fade', 'easy-elementor-addons'),
            'scale-up' => esc_html__('Scale Up', 'easy-elementor-addons'),
            'scale-down' => esc_html__('Scale Down', 'easy-elementor-addons'),
            'slide-top' => esc_html__('Slide Top', 'easy-elementor-addons'),
            'slide-bottom' => esc_html__('Slide Bottom', 'easy-elementor-addons'),
            'slide-left' => esc_html__('Slide Left', 'easy-elementor-addons'),
            'slide-right' => esc_html__('Slide Right', 'easy-elementor-addons'),
            'slide-top-small' => esc_html__('Slide Top Small', 'easy-elementor-addons'),
            'slide-bottom-small' => esc_html__('Slide Bottom Small', 'easy-elementor-addons'),
            'slide-left-small' => esc_html__('Slide Left Small', 'easy-elementor-addons'),
            'slide-right-small' => esc_html__('Slide Right Small', 'easy-elementor-addons'),
            'slide-top-medium' => esc_html__('Slide Top Medium', 'easy-elementor-addons'),
            'slide-bottom-medium' => esc_html__('Slide Bottom Medium', 'easy-elementor-addons'),
            'slide-left-medium' => esc_html__('Slide Left Medium', 'easy-elementor-addons'),
            'slide-right-medium' => esc_html__('Slide Right Medium', 'easy-elementor-addons'),
        ];

        return $transition_options;
    }

}

if (!function_exists('eead_get_elementor_page_list')) {
    function eead_get_elementor_page_list() {

        $pagelist = get_posts(
            array(
                'post_type' => 'elementor_library',
                'showposts' => 999,
            )
        );

        if (!empty($pagelist) && !is_wp_error($pagelist)) {

            foreach ($pagelist as $post) {
                $options[$post->post_title] = $post->post_title;
            }

            update_option('temp_count', $options);
            return $options;
        }
    }
}

if (!function_exists('eead_get_item_position')) {
    function eead_get_item_position() {
        $position_options = [
            '' => esc_html__('Default', 'easy-elementor-addons'),
            'top-left' => esc_html__('Top Left', 'easy-elementor-addons'),
            'top-center' => esc_html__('Top Center', 'easy-elementor-addons'),
            'top-right' => esc_html__('Top Right', 'easy-elementor-addons'),
            'center' => esc_html__('Center', 'easy-elementor-addons'),
            'center-left' => esc_html__('Center Left', 'easy-elementor-addons'),
            'center-right' => esc_html__('Center Right', 'easy-elementor-addons'),
            'bottom-left' => esc_html__('Bottom Left', 'easy-elementor-addons'),
            'bottom-center' => esc_html__('Bottom Center', 'easy-elementor-addons'),
            'bottom-right' => esc_html__('Bottom Right', 'easy-elementor-addons'),
        ];
        return $position_options;
    }
}

if (!function_exists('eead_get_menu')) {
    function eead_get_menu() {
        $menus = wp_get_nav_menus();
        $items = [0 => esc_html__('Select Menu', 'easy-elementor-addons')];
        foreach ($menus as $menu) {
            $items[$menu->slug] = $menu->name;
        }
        return $items;
    }
}

function eead_get_post_types($args = []) {

    $post_type_args = [
        'show_in_nav_menus' => true,
    ];

    if (!empty($args['post_type'])) {
        $post_type_args['name'] = $args['post_type'];
    }

    $_post_types = get_post_types($post_type_args, 'objects');
    $post_types = ['0' => esc_html__('Select Type', 'easy-elementor-addons')];

    foreach ($_post_types as $post_type => $object) {
        $post_types[$post_type] = $object->label;
    }

    return $post_types;
}


function eead_transition_options() {

    $transition_options = [
        '' => esc_html__('None', 'easy-elementor-addons'),
        'fade' => esc_html__('Fade', 'easy-elementor-addons'),
        'scale-up' => esc_html__('Scale Up', 'easy-elementor-addons'),
        'scale-down' => esc_html__('Scale Down', 'easy-elementor-addons'),
        'slide-top' => esc_html__('Slide Top', 'easy-elementor-addons'),
        'slide-bottom' => esc_html__('Slide Bottom', 'easy-elementor-addons'),
        'slide-left' => esc_html__('Slide Left', 'easy-elementor-addons'),
        'slide-right' => esc_html__('Slide Right', 'easy-elementor-addons'),
        'slide-top-small' => esc_html__('Slide Top Small', 'easy-elementor-addons'),
        'slide-bottom-small' => esc_html__('Slide Bottom Small', 'easy-elementor-addons'),
        'slide-left-small' => esc_html__('Slide Left Small', 'easy-elementor-addons'),
        'slide-right-small' => esc_html__('Slide Right Small', 'easy-elementor-addons'),
        'slide-top-medium' => esc_html__('Slide Top Medium', 'easy-elementor-addons'),
        'slide-bottom-medium' => esc_html__('Slide Bottom Medium', 'easy-elementor-addons'),
        'slide-left-medium' => esc_html__('Slide Left Medium', 'easy-elementor-addons'),
        'slide-right-medium' => esc_html__('Slide Right Medium', 'easy-elementor-addons'),
    ];

    return $transition_options;
}

function eead_get_image_sizes() {
    $output_sizes = array();
    $img_sizes = get_intermediate_image_sizes();
    $output_sizes['full'] = esc_html__('Full', 'easy-elementor-addons');

    foreach ($img_sizes as $size_name) {
        $output_sizes[$size_name] = $size_name;
    }

    return $output_sizes;
}

function eead_get_all_widgets_list() {
    $all_wid = apply_filters('eead_all_widgets_list', array(
        'accordion' => array(
            'name' => 'Accordion',
            'icon' => 'eead-icons-accordion',
            'demo_url' => 'https://demo.hashthemes.com/easy-elementor-addons/accordion/',
            'category' => 'essential'
        ),
        'advanced-button' => array(
            'name' => 'Advanced Button',
            'icon' => 'eead-icons-button',
            'demo_url' => 'https://demo.hashthemes.com/easy-elementor-addons/advanced-button/',
            'category' => 'creative'
        ),
        'advanced-heading' => array(
            'name' => 'Advanced Heading',
            'icon' => 'eead-icons-advanced-heading',
            'demo_url' => 'https://demo.hashthemes.com/easy-elementor-addons/advanced-heading/',
            'category' => 'creative'
        ),
        'advanced-icon-box' => array(
            'name' => 'Advanced Icon Box',
            'icon' => 'eead-icons-icon-text',
            'demo_url' => 'https://demo.hashthemes.com/easy-elementor-addons/advanced-icon-box/',
            'category' => 'essential'
        ),
        'advanced-map' => array(
            'name' => 'Advanced Map',
            'icon' => 'eead-icons-map',
            'demo_url' => 'https://demo.hashthemes.com/easy-elementor-addons/advanced-map/',
            'category' => 'essential'
        ),
        'animated-heading' => array(
            'name' => 'Animated Heading',
            'icon' => 'eead-icons-animated-heading',
            'demo_url' => 'https://demo.hashthemes.com/easy-elementor-addons/animated-heading/',
            'category' => 'creative'
        ),
        'business-hour' => array(
            'name' => 'Business Hour',
            'icon' => 'eead-icons-business-hours',
            'demo_url' => 'https://demo.hashthemes.com/easy-elementor-addons/business-hour/',
            'category' => 'listing'
        ),
        'circular-progressbar' => array(
            'name' => 'Circular Progressbar',
            'icon' => 'eead-icons-circular-bar',
            'demo_url' => 'https://demo.hashthemes.com/easy-elementor-addons/circular-progress-bar/',
            'category' => 'essential'
        ),
        'countdown' => array(
            'name' => 'Countdown',
            'icon' => 'eead-icons-count-down',
            'demo_url' => 'https://demo.hashthemes.com/easy-elementor-addons/countdown/',
            'category' => 'essential'
        ),
        'counter' => array(
            'name' => 'Counter',
            'icon' => 'eead-icons-counter',
            'demo_url' => 'https://demo.hashthemes.com/easy-elementor-addons/counter/',
            'category' => 'essential'
        ),
        'drop-bar' => array(
            'name' => 'Drop Bar',
            'icon' => 'eead-icons-drop-box',
            'demo_url' => 'https://demo.hashthemes.com/easy-elementor-addons/drop-bar/',
            'category' => 'essential'
        ),
        'dual-button' => array(
            'name' => 'Dual Button',
            'icon' => 'eead-icons-dual-buttons',
            'demo_url' => 'https://demo.hashthemes.com/easy-elementor-addons/dual-button/',
            'category' => 'creative'
        ),
        'dual-heading' => array(
            'name' => 'Dual Heading',
            'icon' => 'eead-icons-dual-heading',
            'demo_url' => 'https://demo.hashthemes.com/easy-elementor-addons/dual-heading/',
            'category' => 'creative'
        ),
        'feature-list' => array(
            'name' => 'Feature List',
            'icon' => 'eead-icons-feature-list',
            'demo_url' => 'https://demo.hashthemes.com/easy-elementor-addons/feature-list/',
            'category' => 'listing'
        ),
        'flip-box' => array(
            'name' => 'Flip Box',
            'icon' => 'eead-icons-flip-box',
            'demo_url' => 'https://demo.hashthemes.com/easy-elementor-addons/flip-box/',
            'category' => 'creative'
        ),
        'horizontal-tab' => array(
            'name' => 'Horizontal Tab',
            'icon' => 'eead-icons-horizontal-tab',
            'demo_url' => 'https://demo.hashthemes.com/easy-elementor-addons/horizontal-tab/',
            'category' => 'advanced'
        ),
        'horizontal-timeline' => array(
            'name' => 'Horizontal Timeline',
            'icon' => 'eead-icons-horizontal-timeline',
            'demo_url' => 'https://demo.hashthemes.com/easy-elementor-addons/horizontal-timeline/',
            'category' => 'advanced'
        ),
        'hotspot' => array(
            'name' => 'Hotspot',
            'icon' => 'eead-icons-hot-spot',
            'demo_url' => 'https://demo.hashthemes.com/easy-elementor-addons/hotspot/',
            'category' => 'creative'
        ),
        'icon-list' => array(
            'name' => 'Icon List',
            'icon' => 'eead-icons-icon-list',
            'demo_url' => 'https://demo.hashthemes.com/easy-elementor-addons/icon-list/',
            'category' => 'listing'
        ),
        'image-accordion' => array(
            'name' => 'Image Accordion',
            'icon' => 'eead-icons-image-accordion',
            'demo_url' => 'https://demo.hashthemes.com/easy-elementor-addons/image-accordion/',
            'category' => 'listing'
        ),
        'image-comparison' => array(
            'name' => 'Image Comparison',
            'icon' => 'eead-icons-compare',
            'demo_url' => 'https://demo.hashthemes.com/easy-elementor-addons/image-comparison/',
            'category' => 'advanced'
        ),
        'image-gallery' => array(
            'name' => 'Filterable Gallery',
            'icon' => 'eead-icons-image-gallery',
            'demo_url' => 'https://demo.hashthemes.com/easy-elementor-addons/image-gallery/',
            'category' => 'advanced'
        ),
        'link-effect' => array(
            'name' => 'Link Effect',
            'icon' => 'eead-icons-link',
            'demo_url' => 'https://demo.hashthemes.com/easy-elementor-addons/link-effect/',
            'category' => 'essential'
        ),
        'logo-carousel' => array(
            'name' => 'Logo Carousel',
            'icon' => 'eead-icons-logo-carousel',
            'demo_url' => 'https://demo.hashthemes.com/easy-elementor-addons/logo-carousel/',
            'category' => 'essential'
        ),
        'logo-grid' => array(
            'name' => 'Logo Grid',
            'icon' => 'eead-icons-logo-grid',
            'demo_url' => 'https://demo.hashthemes.com/easy-elementor-addons/logo-grid/',
            'category' => 'essential'
        ),
        'lottie' => array(
            'name' => 'Lottie',
            'icon' => 'eead-icons-lottie',
            'demo_url' => 'https://demo.hashthemes.com/easy-elementor-addons/lottie/',
            'category' => 'essential'
        ),
        'one-page-navigation' => array(
            'name' => 'One Page Navigation',
            'icon' => 'eead-icons-one-page-nav',
            'demo_url' => 'https://demo.hashthemes.com/easy-elementor-addons/one-page-navigation/',
            'category' => 'essential'
        ),
        'pie-chart' => array(
            'name' => 'Pie Chart',
            'icon' => 'eead-icons-pie-chart',
            'demo_url' => 'https://demo.hashthemes.com/easy-elementor-addons/pie-chart/',
            'category' => 'creative'
        ),
        'popup-modal' => array(
            'name' => 'Popup Modal',
            'icon' => 'eead-icons-popup',
            'demo_url' => 'https://demo.hashthemes.com/easy-elementor-addons/popup/',
            'category' => 'essential'
        ),
        'popup-video' => array(
            'name' => 'Popup Video',
            'icon' => 'eead-icons-video-popup',
            'demo_url' => 'https://demo.hashthemes.com/easy-elementor-addons/video-popup/',
            'category' => 'essential'
        ),
        'pricing-list' => array(
            'name' => 'Pricing List',
            'icon' => 'eead-icons-pricing-list',
            'demo_url' => 'https://demo.hashthemes.com/easy-elementor-addons/pricing-list/',
            'category' => 'listing'
        ),
        'pricing-table' => array(
            'name' => 'Pricing Table',
            'icon' => 'eead-icons-pricing-table',
            'demo_url' => 'https://demo.hashthemes.com/easy-elementor-addons/pricing-table/',
            'category' => 'listing'
        ),
        'progressbar' => array(
            'name' => 'Progressbar',
            'icon' => 'eead-icons-progress-bar',
            'demo_url' => 'https://demo.hashthemes.com/easy-elementor-addons/progress-bar/',
            'category' => 'essential'
        ),
        'scroll-image' => array(
            'name' => 'Scroll Image',
            'icon' => 'eead-icons-scroll-image',
            'demo_url' => 'https://demo.hashthemes.com/easy-elementor-addons/scroll-image/',
            'category' => 'essential'
        ),
        'slider' => array(
            'name' => 'Slider',
            'icon' => 'eead-icons-slider',
            'demo_url' => 'https://demo.hashthemes.com/easy-elementor-addons/slider/',
            'category' => 'essential'
        ),
        'social-share' => array(
            'name' => 'Social Share',
            'icon' => 'eead-icons-social-share',
            'demo_url' => 'https://demo.hashthemes.com/easy-elementor-addons/social-share/',
            'category' => 'social'
        ),
        'step-flow' => array(
            'name' => 'Step Flow',
            'icon' => 'eead-icons-step-flow',
            'demo_url' => 'https://demo.hashthemes.com/easy-elementor-addons/step-flow/',
            'category' => 'essential'
        ),
        'sticky-video' => array(
            'name' => 'Sticky Video',
            'icon' => 'eead-icons-sticky-video',
            'demo_url' => 'https://demo.hashthemes.com/easy-elementor-addons/sticky-video/',
            'category' => 'essential'
        ),
        'switcher' => array(
            'name' => 'Switcher',
            'icon' => 'eead-icons-switcher',
            'demo_url' => 'https://demo.hashthemes.com/easy-elementor-addons/switcher/',
            'category' => 'essential'
        ),
        'team-member' => array(
            'name' => 'Team',
            'icon' => 'eead-icons-team',
            'demo_url' => 'https://demo.hashthemes.com/easy-elementor-addons/team-member/',
            'category' => 'essential'
        ),
        'team-carousel' => array(
            'name' => 'Team Carousel',
            'icon' => 'eead-icons-team-carousel',
            'demo_url' => 'https://demo.hashthemes.com/easy-elementor-addons/team-carousel/',
            'category' => 'essential'
        ),
        'testimonial' => array(
            'name' => 'Testimonial',
            'icon' => 'eead-icons-testimonial',
            'demo_url' => 'https://demo.hashthemes.com/easy-elementor-addons/testimonial/',
            'category' => 'essential'
        ),
        'testimonial-carousel' => array(
            'name' => 'Testimonial Carousel',
            'icon' => 'eead-icons-testimonial-carousel',
            'demo_url' => 'https://demo.hashthemes.com/easy-elementor-addons/testimonial-carousel/',
            'category' => 'essential'
        ),
        'toggle' => array(
            'name' => 'Toggle',
            'icon' => 'eead-icons-toggle',
            'demo_url' => 'https://demo.hashthemes.com/easy-elementor-addons/toggle/',
            'category' => 'essential'
        ),
        'twitter-feed' => array(
            'name' => 'Twitter Feed',
            'icon' => 'eead-icons-twitter-x',
            'demo_url' => 'https://demo.hashthemes.com/easy-elementor-addons/twitter-feed/',
            'category' => 'essential'
        ),
        'vertical-tab' => array(
            'name' => 'Vertical Tab',
            'icon' => 'eead-icons-vertical-tab',
            'demo_url' => 'https://demo.hashthemes.com/easy-elementor-addons/vertical-tab/',
            'category' => 'advanced'
        ),
        'vertical-timeline' => array(
            'name' => 'Vertical Timeline',
            'icon' => 'eead-icons-vertical-timeline',
            'demo_url' => 'https://demo.hashthemes.com/easy-elementor-addons/vertical-timeline/',
            'category' => 'advanced'
        ),
        'video-player' => array(
            'name' => 'Video Player',
            'icon' => 'eead-icons-video-player',
            'demo_url' => 'https://demo.hashthemes.com/easy-elementor-addons/video-player/',
            'category' => 'essential'
        ),
        'weather' => array(
            'name' => 'Weather Block',
            'icon' => 'eead-icons-weather',
            'demo_url' => 'https://demo.hashthemes.com/easy-elementor-addons/weather/',
            'category' => 'essential'
        ),
    ));
    ksort($all_wid);
    return $all_wid;
}

function eead_get_all_widgets_desc() {
    return array(
        'accordion' => esc_html__('Displays the FAQ of your clients within a beautiful UI.', 'easy-elementor-addons'),
        'advanced-button' => esc_html__('Allows you to place responsive buttons with different animations, hover effects and many more.', 'easy-elementor-addons'),
        'advanced-heading' => esc_html__('Displays heading in different styles.', 'easy-elementor-addons'),
        'advanced-icon-box' => esc_html__('Lets you create an icon box where you can place an icon with the title, and description.', 'easy-elementor-addons'),
        'advanced-map' => esc_html__('Add fully customizable maps with advanced styling and multiple location markers.', 'easy-elementor-addons'),
        'animated-heading' => esc_html__('Place the animated heading to display your deals, offers, discounts or features of your services in an eye catchy way.', 'easy-elementor-addons'),
        'business-hour' => esc_html__('Displays the timetable of the business hour of your company.', 'easy-elementor-addons'),
        'circular-progressbar' => esc_html__('Displays the work progress of your company in a circular layout.', 'easy-elementor-addons'),
        'countdown' => esc_html__('Create engaging countdown timers to highlight offers, events, or launches.', 'easy-elementor-addons'),
        'counter' => esc_html__('Let you place a beautiful stats counter of your business by highlighting the achievements.', 'easy-elementor-addons'),
        'drop-bar' => esc_html__('Display a short information on the drop bar and display it in different positions, animation effects.', 'easy-elementor-addons'),
        'dual-button' => esc_html__('Design stylish dual-action buttons with unique layouts and effects.', 'easy-elementor-addons'),
        'dual-heading' => esc_html__('Allows you to display the heading in dual effects.', 'easy-elementor-addons'),
        'feature-list' => esc_html__('Showcase features or services with icons, text, and custom layouts.', 'easy-elementor-addons'),
        'flip-box' => esc_html__('Display your information, custom text or even product detail in a customizable flip box.', 'easy-elementor-addons'),
        'horizontal-tab' => esc_html__('Allows you to showcase different information in a responsive horizontal tab.', 'easy-elementor-addons'),
        'horizontal-timeline' => esc_html__('Adds a horizontal timeline to display the evolution, history and success story of your company in a responsive timeline.', 'easy-elementor-addons'),
        'hotspot' => esc_html__('Add hotspot tooltips of different parts of the images.', 'easy-elementor-addons'),
        'icon-list' => esc_html__('List down your contents with beautiful icons or png images.', 'easy-elementor-addons'),
        'image-accordion' => esc_html__('Images are displayed in a stacked layout that expands or collapses when clicked, showing or hiding additional images or content', 'easy-elementor-addons'),
        'image-comparison' => esc_html__('To showcase the images before and after editing the images.', 'easy-elementor-addons'),
        'image-gallery' => esc_html__('Build dynamic, filterable image or video galleries with ease.', 'easy-elementor-addons'),
        'link-effect' => esc_html__('Customize your hyperlink by adding different animation effects.', 'easy-elementor-addons'),
        'logo-carousel' => esc_html__('Highlight the logo of your clients, partners, or sponsor in a beautiful carousel.', 'easy-elementor-addons'),
        'logo-grid' => esc_html__('Highlight the logo of your clients, partners, or sponsor in a beautiful logo grid.', 'easy-elementor-addons'),
        'lottie' => esc_html__('Embed lightweight, animated Lottie files to enhance interactivity.', 'easy-elementor-addons'),
        'one-page-navigation' => esc_html__('Place an extra navigator to navigate different contents present in a single page.', 'easy-elementor-addons'),
        'pie-chart' => esc_html__('Display your company progress in a beautiful pie chart.', 'easy-elementor-addons'),
        'popup-modal' => esc_html__('Place an animated popup with different animations.', 'easy-elementor-addons'),
        'popup-video' => esc_html__('Add eye-catching video popups to boost user engagement.', 'easy-elementor-addons'),
        'pricing-list' => esc_html__('Showcase the pricing of your products in a unique fashion.', 'easy-elementor-addons'),
        'pricing-table' => esc_html__('Display the pricing plan of your services in a beautifully designed pricing table.', 'easy-elementor-addons'),
        'progressbar' => esc_html__('Allows you to showcase your work progress in an attractive progress bar.', 'easy-elementor-addons'),
        'scroll-image' => esc_html__('Let’s you showcase a long and full width image in a short space. Automatically scroll the images when hovered over.', 'easy-elementor-addons'),
        'slider' => esc_html__('Highlight your announcements, deals or even products in a responsive slider.', 'easy-elementor-addons'),
        'social-share' => esc_html__('Add social share buttons to share your pages or posts to different social media networks in a single click.', 'easy-elementor-addons'),
        'step-flow' => esc_html__('Present step-by-step processes with a clean and professional layout.', 'easy-elementor-addons'),
        'sticky-video' => esc_html__('Keep videos visible while users scroll through the page.', 'easy-elementor-addons'),
        'switcher' => esc_html__('To display multiple web contents in a switcher for comparison.', 'easy-elementor-addons'),
        'team-member' => esc_html__('Display your team members of your company/organization.', 'easy-elementor-addons'),
        'team-carousel' => esc_html__('Display your team members of your company/organization in an attractive carousel.', 'easy-elementor-addons'),
        'testimonial' => esc_html__('Showcase the positive words given by your clients in a stunning way.', 'easy-elementor-addons'),
        'testimonial-carousel' => esc_html__('Showcase the positive words given by your client in a beautiful slider.', 'easy-elementor-addons'),
        'toggle' => esc_html__('Display multiple contents and toggle them for comparison.', 'easy-elementor-addons'),
        'twitter-feed' => esc_html__('Display real-time Twitter feeds directly on your website.', 'easy-elementor-addons'),
        'vertical-tab' => esc_html__('Allows you to showcase different information in a responsive vertical tab.', 'easy-elementor-addons'),
        'vertical-timeline' => esc_html__('Adds a vertical timeline to represent the evolution, history and success story of your company in a responsive timeline.', 'easy-elementor-addons'),
        'video-player' => esc_html__('Allow you to embed the videos from Youtube, Vimeo or from your local computer.', 'easy-elementor-addons'),
        'weather' => esc_html__('Adds a weather report of a city with humidity, Pressure and Wind Speed.', 'easy-elementor-addons'),
    );
}


if (!function_exists('eead_materialdesignicons_array')) {

    function eead_materialdesignicons_array() {
        return array('ab-testing', 'abacus', 'abjad-arabic', 'abjad-hebrew', 'abugida-devanagari', 'abugida-thai', 'access-point', 'access-point-check', 'access-point-minus', 'access-point-network', 'access-point-network-off', 'access-point-off', 'access-point-plus', 'access-point-remove', 'account', 'account-alert', 'account-alert-outline', 'account-arrow-down', 'account-arrow-down-outline', 'account-arrow-left', 'account-arrow-left-outline', 'account-arrow-right', 'account-arrow-right-outline', 'account-arrow-up', 'account-arrow-up-outline', 'account-badge', 'account-badge-outline', 'account-box', 'account-box-multiple', 'account-box-multiple-outline', 'account-box-outline', 'account-cancel', 'account-cancel-outline', 'account-card', 'account-card-outline', 'account-cash', 'account-cash-outline', 'account-check', 'account-check-outline', 'account-child', 'account-child-circle', 'account-child-outline', 'account-circle', 'account-circle-outline', 'account-clock', 'account-clock-outline', 'account-cog', 'account-cog-outline', 'account-convert', 'account-convert-outline', 'account-cowboy-hat', 'account-cowboy-hat-outline', 'account-credit-card', 'account-credit-card-outline', 'account-details', 'account-details-outline', 'account-edit', 'account-edit-outline', 'account-eye', 'account-eye-outline', 'account-filter', 'account-filter-outline', 'account-group', 'account-group-outline', 'account-hard-hat', 'account-hard-hat-outline', 'account-heart', 'account-heart-outline', 'account-injury', 'account-injury-outline', 'account-key', 'account-key-outline', 'account-lock', 'account-lock-open', 'account-lock-open-outline', 'account-lock-outline', 'account-minus', 'account-minus-outline', 'account-multiple', 'account-multiple-check', 'account-multiple-check-outline', 'account-multiple-minus', 'account-multiple-minus-outline', 'account-multiple-outline', 'account-multiple-plus', 'account-multiple-plus-outline', 'account-multiple-remove', 'account-multiple-remove-outline', 'account-music', 'account-music-outline', 'account-network', 'account-network-off', 'account-network-off-outline', 'account-network-outline', 'account-off', 'account-off-outline', 'account-outline', 'account-plus', 'account-plus-outline', 'account-question', 'account-question-outline', 'account-reactivate', 'account-reactivate-outline', 'account-remove', 'account-remove-outline', 'account-school', 'account-school-outline', 'account-search', 'account-search-outline', 'account-settings', 'account-settings-outline', 'account-star', 'account-star-outline', 'account-supervisor', 'account-supervisor-circle', 'account-supervisor-circle-outline', 'account-supervisor-outline', 'account-switch', 'account-switch-outline', 'account-sync', 'account-sync-outline', 'account-tag', 'account-tag-outline', 'account-tie', 'account-tie-hat', 'account-tie-hat-outline', 'account-tie-outline', 'account-tie-voice', 'account-tie-voice-off', 'account-tie-voice-off-outline', 'account-tie-voice-outline', 'account-tie-woman', 'account-voice', 'account-voice-off', 'account-wrench', 'account-wrench-outline', 'adjust', 'advertisements', 'advertisements-off', 'air-conditioner', 'air-filter', 'air-horn', 'air-humidifier', 'air-humidifier-off', 'air-purifier', 'air-purifier-off', 'airbag', 'airballoon', 'airballoon-outline', 'airplane', 'airplane-alert', 'airplane-check', 'airplane-clock', 'airplane-cog', 'airplane-edit', 'airplane-landing', 'airplane-marker', 'airplane-minus', 'airplane-off', 'airplane-plus', 'airplane-remove', 'airplane-search', 'airplane-settings', 'airplane-takeoff', 'airport', 'alarm', 'alarm-bell', 'alarm-check', 'alarm-light', 'alarm-light-off', 'alarm-light-off-outline', 'alarm-light-outline', 'alarm-multiple', 'alarm-note', 'alarm-note-off', 'alarm-off', 'alarm-panel', 'alarm-panel-outline', 'alarm-plus', 'alarm-snooze', 'album', 'alert', 'alert-box', 'alert-box-outline', 'alert-circle', 'alert-circle-check', 'alert-circle-check-outline', 'alert-circle-outline', 'alert-decagram', 'alert-decagram-outline', 'alert-minus', 'alert-minus-outline', 'alert-octagon', 'alert-octagon-outline', 'alert-octagram', 'alert-octagram-outline', 'alert-outline', 'alert-plus', 'alert-plus-outline', 'alert-remove', 'alert-remove-outline', 'alert-rhombus', 'alert-rhombus-outline', 'alien', 'alien-outline', 'align-horizontal-center', 'align-horizontal-distribute', 'align-horizontal-left', 'align-horizontal-right', 'align-vertical-bottom', 'align-vertical-center', 'align-vertical-distribute', 'align-vertical-top', 'all-inclusive', 'all-inclusive-box', 'all-inclusive-box-outline', 'allergy', 'alpha', 'alpha-a', 'alpha-a-box', 'alpha-a-box-outline', 'alpha-a-circle', 'alpha-a-circle-outline', 'alpha-b', 'alpha-b-box', 'alpha-b-box-outline', 'alpha-b-circle', 'alpha-b-circle-outline', 'alpha-c', 'alpha-c-box', 'alpha-c-box-outline', 'alpha-c-circle', 'alpha-c-circle-outline', 'alpha-d', 'alpha-d-box', 'alpha-d-box-outline', 'alpha-d-circle', 'alpha-d-circle-outline', 'alpha-e', 'alpha-e-box', 'alpha-e-box-outline', 'alpha-e-circle', 'alpha-e-circle-outline', 'alpha-f', 'alpha-f-box', 'alpha-f-box-outline', 'alpha-f-circle', 'alpha-f-circle-outline', 'alpha-g', 'alpha-g-box', 'alpha-g-box-outline', 'alpha-g-circle', 'alpha-g-circle-outline', 'alpha-h', 'alpha-h-box', 'alpha-h-box-outline', 'alpha-h-circle', 'alpha-h-circle-outline', 'alpha-i', 'alpha-i-box', 'alpha-i-box-outline', 'alpha-i-circle', 'alpha-i-circle-outline', 'alpha-j', 'alpha-j-box', 'alpha-j-box-outline', 'alpha-j-circle', 'alpha-j-circle-outline', 'alpha-k', 'alpha-k-box', 'alpha-k-box-outline', 'alpha-k-circle', 'alpha-k-circle-outline', 'alpha-l', 'alpha-l-box', 'alpha-l-box-outline', 'alpha-l-circle', 'alpha-l-circle-outline', 'alpha-m', 'alpha-m-box', 'alpha-m-box-outline', 'alpha-m-circle', 'alpha-m-circle-outline', 'alpha-n', 'alpha-n-box', 'alpha-n-box-outline', 'alpha-n-circle', 'alpha-n-circle-outline', 'alpha-o', 'alpha-o-box', 'alpha-o-box-outline', 'alpha-o-circle', 'alpha-o-circle-outline', 'alpha-p', 'alpha-p-box', 'alpha-p-box-outline', 'alpha-p-circle', 'alpha-p-circle-outline', 'alpha-q', 'alpha-q-box', 'alpha-q-box-outline', 'alpha-q-circle', 'alpha-q-circle-outline', 'alpha-r', 'alpha-r-box', 'alpha-r-box-outline', 'alpha-r-circle', 'alpha-r-circle-outline', 'alpha-s', 'alpha-s-box', 'alpha-s-box-outline', 'alpha-s-circle', 'alpha-s-circle-outline', 'alpha-t', 'alpha-t-box', 'alpha-t-box-outline', 'alpha-t-circle', 'alpha-t-circle-outline', 'alpha-u', 'alpha-u-box', 'alpha-u-box-outline', 'alpha-u-circle', 'alpha-u-circle-outline', 'alpha-v', 'alpha-v-box', 'alpha-v-box-outline', 'alpha-v-circle', 'alpha-v-circle-outline', 'alpha-w', 'alpha-w-box', 'alpha-w-box-outline', 'alpha-w-circle', 'alpha-w-circle-outline', 'alpha-x', 'alpha-x-box', 'alpha-x-box-outline', 'alpha-x-circle', 'alpha-x-circle-outline', 'alpha-y', 'alpha-y-box', 'alpha-y-box-outline', 'alpha-y-circle', 'alpha-y-circle-outline', 'alpha-z', 'alpha-z-box', 'alpha-z-box-outline', 'alpha-z-circle', 'alpha-z-circle-outline', 'alphabet-aurebesh', 'alphabet-cyrillic', 'alphabet-greek', 'alphabet-latin', 'alphabet-piqad', 'alphabet-tengwar', 'alphabetical', 'alphabetical-off', 'alphabetical-variant', 'alphabetical-variant-off', 'altimeter', 'ambulance', 'ammunition', 'ampersand', 'amplifier', 'amplifier-off', 'anchor', 'android', 'android-studio', 'angle-acute', 'angle-obtuse', 'angle-right', 'angular', 'angularjs', 'animation', 'animation-outline', 'animation-play', 'animation-play-outline', 'ansible', 'antenna', 'anvil', 'apache-kafka', 'api', 'api-off', 'apple', 'apple-finder', 'apple-icloud', 'apple-ios', 'apple-keyboard-caps', 'apple-keyboard-command', 'apple-keyboard-control', 'apple-keyboard-option', 'apple-keyboard-shift', 'apple-safari', 'application', 'application-array', 'application-array-outline', 'application-braces', 'application-braces-outline', 'application-brackets', 'application-brackets-outline', 'application-cog', 'application-cog-outline', 'application-edit', 'application-edit-outline', 'application-export', 'application-import', 'application-outline', 'application-parentheses', 'application-parentheses-outline', 'application-settings', 'application-settings-outline', 'application-variable', 'application-variable-outline', 'approximately-equal', 'approximately-equal-box', 'apps', 'apps-box', 'arch', 'archive', 'archive-alert', 'archive-alert-outline', 'archive-arrow-down', 'archive-arrow-down-outline', 'archive-arrow-up', 'archive-arrow-up-outline', 'archive-cancel', 'archive-cancel-outline', 'archive-check', 'archive-check-outline', 'archive-clock', 'archive-clock-outline', 'archive-cog', 'archive-cog-outline', 'archive-edit', 'archive-edit-outline', 'archive-eye', 'archive-eye-outline', 'archive-lock', 'archive-lock-open', 'archive-lock-open-outline', 'archive-lock-outline', 'archive-marker', 'archive-marker-outline', 'archive-minus', 'archive-minus-outline', 'archive-music', 'archive-music-outline', 'archive-off', 'archive-off-outline', 'archive-outline', 'archive-plus', 'archive-plus-outline', 'archive-refresh', 'archive-refresh-outline', 'archive-remove', 'archive-remove-outline', 'archive-search', 'archive-search-outline', 'archive-settings', 'archive-settings-outline', 'archive-star', 'archive-star-outline', 'archive-sync', 'archive-sync-outline', 'arm-flex', 'arm-flex-outline', 'arrange-bring-forward', 'arrange-bring-to-front', 'arrange-send-backward', 'arrange-send-to-back', 'arrow-all', 'arrow-bottom-left', 'arrow-bottom-left-bold-box', 'arrow-bottom-left-bold-box-outline', 'arrow-bottom-left-bold-outline', 'arrow-bottom-left-thick', 'arrow-bottom-left-thin', 'arrow-bottom-left-thin-circle-outline', 'arrow-bottom-right', 'arrow-bottom-right-bold-box', 'arrow-bottom-right-bold-box-outline', 'arrow-bottom-right-bold-outline', 'arrow-bottom-right-thick', 'arrow-bottom-right-thin', 'arrow-bottom-right-thin-circle-outline', 'arrow-collapse', 'arrow-collapse-all', 'arrow-collapse-down', 'arrow-collapse-horizontal', 'arrow-collapse-left', 'arrow-collapse-right', 'arrow-collapse-up', 'arrow-collapse-vertical', 'arrow-decision', 'arrow-decision-auto', 'arrow-decision-auto-outline', 'arrow-decision-outline', 'arrow-down', 'arrow-down-bold', 'arrow-down-bold-box', 'arrow-down-bold-box-outline', 'arrow-down-bold-circle', 'arrow-down-bold-circle-outline', 'arrow-down-bold-hexagon-outline', 'arrow-down-bold-outline', 'arrow-down-box', 'arrow-down-circle', 'arrow-down-circle-outline', 'arrow-down-drop-circle', 'arrow-down-drop-circle-outline', 'arrow-down-left', 'arrow-down-left-bold', 'arrow-down-right', 'arrow-down-right-bold', 'arrow-down-thick', 'arrow-down-thin', 'arrow-down-thin-circle-outline', 'arrow-expand', 'arrow-expand-all', 'arrow-expand-down', 'arrow-expand-horizontal', 'arrow-expand-left', 'arrow-expand-right', 'arrow-expand-up', 'arrow-expand-vertical', 'arrow-horizontal-lock', 'arrow-left', 'arrow-left-bold', 'arrow-left-bold-box', 'arrow-left-bold-box-outline', 'arrow-left-bold-circle', 'arrow-left-bold-circle-outline', 'arrow-left-bold-hexagon-outline', 'arrow-left-bold-outline', 'arrow-left-bottom', 'arrow-left-bottom-bold', 'arrow-left-box', 'arrow-left-circle', 'arrow-left-circle-outline', 'arrow-left-drop-circle', 'arrow-left-drop-circle-outline', 'arrow-left-right', 'arrow-left-right-bold', 'arrow-left-right-bold-outline', 'arrow-left-thick', 'arrow-left-thin', 'arrow-left-thin-circle-outline', 'arrow-left-top', 'arrow-left-top-bold', 'arrow-projectile', 'arrow-projectile-multiple', 'arrow-right', 'arrow-right-bold', 'arrow-right-bold-box', 'arrow-right-bold-box-outline', 'arrow-right-bold-circle', 'arrow-right-bold-circle-outline', 'arrow-right-bold-hexagon-outline', 'arrow-right-bold-outline', 'arrow-right-bottom', 'arrow-right-bottom-bold', 'arrow-right-box', 'arrow-right-circle', 'arrow-right-circle-outline', 'arrow-right-drop-circle', 'arrow-right-drop-circle-outline', 'arrow-right-thick', 'arrow-right-thin', 'arrow-right-thin-circle-outline', 'arrow-right-top', 'arrow-right-top-bold', 'arrow-split-horizontal', 'arrow-split-vertical', 'arrow-top-left', 'arrow-top-left-bold-box', 'arrow-top-left-bold-box-outline', 'arrow-top-left-bold-outline', 'arrow-top-left-bottom-right', 'arrow-top-left-bottom-right-bold', 'arrow-top-left-thick', 'arrow-top-left-thin', 'arrow-top-left-thin-circle-outline', 'arrow-top-right', 'arrow-top-right-bold-box', 'arrow-top-right-bold-box-outline', 'arrow-top-right-bold-outline', 'arrow-top-right-bottom-left', 'arrow-top-right-bottom-left-bold', 'arrow-top-right-thick', 'arrow-top-right-thin', 'arrow-top-right-thin-circle-outline', 'arrow-u-down-left', 'arrow-u-down-left-bold', 'arrow-u-down-right', 'arrow-u-down-right-bold', 'arrow-u-left-bottom', 'arrow-u-left-bottom-bold', 'arrow-u-left-top', 'arrow-u-left-top-bold', 'arrow-u-right-bottom', 'arrow-u-right-bottom-bold', 'arrow-u-right-top', 'arrow-u-right-top-bold', 'arrow-u-up-left', 'arrow-u-up-left-bold', 'arrow-u-up-right', 'arrow-u-up-right-bold', 'arrow-up', 'arrow-up-bold', 'arrow-up-bold-box', 'arrow-up-bold-box-outline', 'arrow-up-bold-circle', 'arrow-up-bold-circle-outline', 'arrow-up-bold-hexagon-outline', 'arrow-up-bold-outline', 'arrow-up-box', 'arrow-up-circle', 'arrow-up-circle-outline', 'arrow-up-down', 'arrow-up-down-bold', 'arrow-up-down-bold-outline', 'arrow-up-drop-circle', 'arrow-up-drop-circle-outline', 'arrow-up-left', 'arrow-up-left-bold', 'arrow-up-right', 'arrow-up-right-bold', 'arrow-up-thick', 'arrow-up-thin', 'arrow-up-thin-circle-outline', 'arrow-vertical-lock', 'artboard', 'artstation', 'aspect-ratio', 'assistant', 'asterisk', 'asterisk-circle-outline', 'at', 'atlassian', 'atm', 'atom', 'atom-variant', 'attachment', 'attachment-check', 'attachment-lock', 'attachment-minus', 'attachment-off', 'attachment-plus', 'attachment-remove', 'atv', 'audio-input-rca', 'audio-input-stereo-minijack', 'audio-input-xlr', 'audio-video', 'audio-video-off', 'augmented-reality', 'aurora', 'auto-download', 'auto-fix', 'auto-upload', 'autorenew', 'autorenew-off', 'av-timer', 'awning', 'awning-outline', 'aws', 'axe', 'axe-battle', 'axis', 'axis-arrow', 'axis-arrow-info', 'axis-arrow-lock', 'axis-lock', 'axis-x-arrow', 'axis-x-arrow-lock', 'axis-x-rotate-clockwise', 'axis-x-rotate-counterclockwise', 'axis-x-y-arrow-lock', 'axis-y-arrow', 'axis-y-arrow-lock', 'axis-y-rotate-clockwise', 'axis-y-rotate-counterclockwise', 'axis-z-arrow', 'axis-z-arrow-lock', 'axis-z-rotate-clockwise', 'axis-z-rotate-counterclockwise', 'babel', 'baby', 'baby-bottle', 'baby-bottle-outline', 'baby-buggy', 'baby-buggy-off', 'baby-carriage', 'baby-carriage-off', 'baby-face', 'baby-face-outline', 'backburger', 'backspace', 'backspace-outline', 'backspace-reverse', 'backspace-reverse-outline', 'backup-restore', 'bacteria', 'bacteria-outline', 'badge-account', 'badge-account-alert', 'badge-account-alert-outline', 'badge-account-horizontal', 'badge-account-horizontal-outline', 'badge-account-outline', 'badminton', 'bag-carry-on', 'bag-carry-on-check', 'bag-carry-on-off', 'bag-checked', 'bag-personal', 'bag-personal-off', 'bag-personal-off-outline', 'bag-personal-outline', 'bag-personal-tag', 'bag-personal-tag-outline', 'bag-suitcase', 'bag-suitcase-off', 'bag-suitcase-off-outline', 'bag-suitcase-outline', 'baguette', 'balcony', 'balloon', 'ballot', 'ballot-outline', 'ballot-recount', 'ballot-recount-outline', 'bandage', 'bank', 'bank-check', 'bank-circle', 'bank-circle-outline', 'bank-minus', 'bank-off', 'bank-off-outline', 'bank-outline', 'bank-plus', 'bank-remove', 'bank-transfer', 'bank-transfer-in', 'bank-transfer-out', 'barcode', 'barcode-off', 'barcode-scan', 'barley', 'barley-off', 'barn', 'barrel', 'barrel-outline', 'baseball', 'baseball-bat', 'baseball-diamond', 'baseball-diamond-outline', 'bash', 'basket', 'basket-check', 'basket-check-outline', 'basket-fill', 'basket-minus', 'basket-minus-outline', 'basket-off', 'basket-off-outline', 'basket-outline', 'basket-plus', 'basket-plus-outline', 'basket-remove', 'basket-remove-outline', 'basket-unfill', 'basketball', 'basketball-hoop', 'basketball-hoop-outline', 'bat', 'bathtub', 'bathtub-outline', 'battery', 'battery-10', 'battery-10-bluetooth', 'battery-20', 'battery-20-bluetooth', 'battery-30', 'battery-30-bluetooth', 'battery-40', 'battery-40-bluetooth', 'battery-50', 'battery-50-bluetooth', 'battery-60', 'battery-60-bluetooth', 'battery-70', 'battery-70-bluetooth', 'battery-80', 'battery-80-bluetooth', 'battery-90', 'battery-90-bluetooth', 'battery-alert', 'battery-alert-bluetooth', 'battery-alert-variant', 'battery-alert-variant-outline', 'battery-arrow-down', 'battery-arrow-down-outline', 'battery-arrow-up', 'battery-arrow-up-outline', 'battery-bluetooth', 'battery-bluetooth-variant', 'battery-charging', 'battery-charging-10', 'battery-charging-100', 'battery-charging-20', 'battery-charging-30', 'battery-charging-40', 'battery-charging-50', 'battery-charging-60', 'battery-charging-70', 'battery-charging-80', 'battery-charging-90', 'battery-charging-high', 'battery-charging-low', 'battery-charging-medium', 'battery-charging-outline', 'battery-charging-wireless', 'battery-charging-wireless-10', 'battery-charging-wireless-20', 'battery-charging-wireless-30', 'battery-charging-wireless-40', 'battery-charging-wireless-50', 'battery-charging-wireless-60', 'battery-charging-wireless-70', 'battery-charging-wireless-80', 'battery-charging-wireless-90', 'battery-charging-wireless-alert', 'battery-charging-wireless-outline', 'battery-check', 'battery-check-outline', 'battery-clock', 'battery-clock-outline', 'battery-heart', 'battery-heart-outline', 'battery-heart-variant', 'battery-high', 'battery-lock', 'battery-lock-open', 'battery-low', 'battery-medium', 'battery-minus', 'battery-minus-outline', 'battery-minus-variant', 'battery-negative', 'battery-off', 'battery-off-outline', 'battery-outline', 'battery-plus', 'battery-plus-outline', 'battery-plus-variant', 'battery-positive', 'battery-remove', 'battery-remove-outline', 'battery-sync', 'battery-sync-outline', 'battery-unknown', 'battery-unknown-bluetooth', 'beach', 'beaker', 'beaker-alert', 'beaker-alert-outline', 'beaker-check', 'beaker-check-outline', 'beaker-minus', 'beaker-minus-outline', 'beaker-outline', 'beaker-plus', 'beaker-plus-outline', 'beaker-question', 'beaker-question-outline', 'beaker-remove', 'beaker-remove-outline', 'bed', 'bed-clock', 'bed-double', 'bed-double-outline', 'bed-empty', 'bed-king', 'bed-king-outline', 'bed-outline', 'bed-queen', 'bed-queen-outline', 'bed-single', 'bed-single-outline', 'bee', 'bee-flower', 'beehive-off-outline', 'beehive-outline', 'beekeeper', 'beer', 'beer-outline', 'bell', 'bell-alert', 'bell-alert-outline', 'bell-badge', 'bell-badge-outline', 'bell-cancel', 'bell-cancel-outline', 'bell-check', 'bell-check-outline', 'bell-circle', 'bell-circle-outline', 'bell-cog', 'bell-cog-outline', 'bell-minus', 'bell-minus-outline', 'bell-off', 'bell-off-outline', 'bell-outline', 'bell-plus', 'bell-plus-outline', 'bell-remove', 'bell-remove-outline', 'bell-ring', 'bell-ring-outline', 'bell-sleep', 'bell-sleep-outline', 'beta', 'betamax', 'biathlon', 'bicycle', 'bicycle-basket', 'bicycle-cargo', 'bicycle-electric', 'bicycle-penny-farthing', 'bike', 'bike-fast', 'billboard', 'billiards', 'billiards-rack', 'binoculars', 'bio', 'biohazard', 'bird', 'bitbucket', 'bitcoin', 'black-mesa', 'blender', 'blender-outline', 'blender-software', 'blinds', 'blinds-horizontal', 'blinds-horizontal-closed', 'blinds-open', 'blinds-vertical', 'blinds-vertical-closed', 'block-helper', 'blood-bag', 'bluetooth', 'bluetooth-audio', 'bluetooth-connect', 'bluetooth-off', 'bluetooth-settings', 'bluetooth-transfer', 'blur', 'blur-linear', 'blur-off', 'blur-radial', 'bolt', 'bomb', 'bomb-off', 'bone', 'bone-off', 'book', 'book-account', 'book-account-outline', 'book-alert', 'book-alert-outline', 'book-alphabet', 'book-arrow-down', 'book-arrow-down-outline', 'book-arrow-left', 'book-arrow-left-outline', 'book-arrow-right', 'book-arrow-right-outline', 'book-arrow-up', 'book-arrow-up-outline', 'book-cancel', 'book-cancel-outline', 'book-check', 'book-check-outline', 'book-clock', 'book-clock-outline', 'book-cog', 'book-cog-outline', 'book-cross', 'book-edit', 'book-edit-outline', 'book-education', 'book-education-outline', 'book-heart', 'book-heart-outline', 'book-information-variant', 'book-lock', 'book-lock-open', 'book-lock-open-outline', 'book-lock-outline', 'book-marker', 'book-marker-outline', 'book-minus', 'book-minus-multiple', 'book-minus-multiple-outline', 'book-minus-outline', 'book-multiple', 'book-multiple-outline', 'book-music', 'book-music-outline', 'book-off', 'book-off-outline', 'book-open', 'book-open-blank-variant', 'book-open-outline', 'book-open-page-variant', 'book-open-page-variant-outline', 'book-open-variant', 'book-outline', 'book-play', 'book-play-outline', 'book-plus', 'book-plus-multiple', 'book-plus-multiple-outline', 'book-plus-outline', 'book-refresh', 'book-refresh-outline', 'book-remove', 'book-remove-multiple', 'book-remove-multiple-outline', 'book-remove-outline', 'book-search', 'book-search-outline', 'book-settings', 'book-settings-outline', 'book-sync', 'book-sync-outline', 'book-variant', 'bookmark', 'bookmark-box', 'bookmark-box-multiple', 'bookmark-box-multiple-outline', 'bookmark-box-outline', 'bookmark-check', 'bookmark-check-outline', 'bookmark-minus', 'bookmark-minus-outline', 'bookmark-multiple', 'bookmark-multiple-outline', 'bookmark-music', 'bookmark-music-outline', 'bookmark-off', 'bookmark-off-outline', 'bookmark-outline', 'bookmark-plus', 'bookmark-plus-outline', 'bookmark-remove', 'bookmark-remove-outline', 'bookshelf', 'boom-gate', 'boom-gate-alert', 'boom-gate-alert-outline', 'boom-gate-arrow-down', 'boom-gate-arrow-down-outline', 'boom-gate-arrow-up', 'boom-gate-arrow-up-outline', 'boom-gate-outline', 'boom-gate-up', 'boom-gate-up-outline', 'boombox', 'boomerang', 'bootstrap', 'border-all', 'border-all-variant', 'border-bottom', 'border-bottom-variant', 'border-color', 'border-horizontal', 'border-inside', 'border-left', 'border-left-variant', 'border-none', 'border-none-variant', 'border-outside', 'border-radius', 'border-right', 'border-right-variant', 'border-style', 'border-top', 'border-top-variant', 'border-vertical', 'bottle-soda', 'bottle-soda-classic', 'bottle-soda-classic-outline', 'bottle-soda-outline', 'bottle-tonic', 'bottle-tonic-outline', 'bottle-tonic-plus', 'bottle-tonic-plus-outline', 'bottle-tonic-skull', 'bottle-tonic-skull-outline', 'bottle-wine', 'bottle-wine-outline', 'bow-arrow', 'bow-tie', 'bowl', 'bowl-mix', 'bowl-mix-outline', 'bowl-outline', 'bowling', 'box', 'box-cutter', 'box-cutter-off', 'box-shadow', 'boxing-glove', 'braille', 'brain', 'bread-slice', 'bread-slice-outline', 'bridge', 'briefcase', 'briefcase-account', 'briefcase-account-outline', 'briefcase-arrow-left-right', 'briefcase-arrow-left-right-outline', 'briefcase-arrow-up-down', 'briefcase-arrow-up-down-outline', 'briefcase-check', 'briefcase-check-outline', 'briefcase-clock', 'briefcase-clock-outline', 'briefcase-download', 'briefcase-download-outline', 'briefcase-edit', 'briefcase-edit-outline', 'briefcase-eye', 'briefcase-eye-outline', 'briefcase-minus', 'briefcase-minus-outline', 'briefcase-off', 'briefcase-off-outline', 'briefcase-outline', 'briefcase-plus', 'briefcase-plus-outline', 'briefcase-remove', 'briefcase-remove-outline', 'briefcase-search', 'briefcase-search-outline', 'briefcase-upload', 'briefcase-upload-outline', 'briefcase-variant', 'briefcase-variant-off', 'briefcase-variant-off-outline', 'briefcase-variant-outline', 'brightness-1', 'brightness-2', 'brightness-3', 'brightness-4', 'brightness-5', 'brightness-6', 'brightness-7', 'brightness-auto', 'brightness-percent', 'broadcast', 'broadcast-off', 'broom', 'brush', 'brush-off', 'brush-outline', 'brush-variant', 'bucket', 'bucket-outline', 'buffet', 'bug', 'bug-check', 'bug-check-outline', 'bug-outline', 'bug-pause', 'bug-pause-outline', 'bug-play', 'bug-play-outline', 'bug-stop', 'bug-stop-outline', 'bugle', 'bulkhead-light', 'bulldozer', 'bullet', 'bulletin-board', 'bullhorn', 'bullhorn-outline', 'bullhorn-variant', 'bullhorn-variant-outline', 'bullseye', 'bullseye-arrow', 'bulma', 'bunk-bed', 'bunk-bed-outline', 'bus', 'bus-alert', 'bus-articulated-end', 'bus-articulated-front', 'bus-clock', 'bus-double-decker', 'bus-electric', 'bus-marker', 'bus-multiple', 'bus-school', 'bus-side', 'bus-stop', 'bus-stop-covered', 'bus-stop-uncovered', 'butterfly', 'butterfly-outline', 'button-cursor', 'button-pointer', 'cabin-a-frame', 'cable-data', 'cached', 'cactus', 'cake', 'cake-layered', 'cake-variant', 'cake-variant-outline', 'calculator', 'calculator-variant', 'calculator-variant-outline', 'calendar', 'calendar-account', 'calendar-account-outline', 'calendar-alert', 'calendar-alert-outline', 'calendar-arrow-left', 'calendar-arrow-right', 'calendar-badge', 'calendar-badge-outline', 'calendar-blank', 'calendar-blank-multiple', 'calendar-blank-outline', 'calendar-check', 'calendar-check-outline', 'calendar-clock', 'calendar-clock-outline', 'calendar-collapse-horizontal', 'calendar-collapse-horizontal-outline', 'calendar-cursor', 'calendar-cursor-outline', 'calendar-edit', 'calendar-edit-outline', 'calendar-end', 'calendar-end-outline', 'calendar-expand-horizontal', 'calendar-expand-horizontal-outline', 'calendar-export', 'calendar-export-outline', 'calendar-filter', 'calendar-filter-outline', 'calendar-heart', 'calendar-heart-outline', 'calendar-import', 'calendar-import-outline', 'calendar-lock', 'calendar-lock-open', 'calendar-lock-open-outline', 'calendar-lock-outline', 'calendar-minus', 'calendar-minus-outline', 'calendar-month', 'calendar-month-outline', 'calendar-multiple', 'calendar-multiple-check', 'calendar-multiselect', 'calendar-multiselect-outline', 'calendar-outline', 'calendar-plus', 'calendar-plus-outline', 'calendar-question', 'calendar-question-outline', 'calendar-range', 'calendar-range-outline', 'calendar-refresh', 'calendar-refresh-outline', 'calendar-remove', 'calendar-remove-outline', 'calendar-search', 'calendar-search-outline', 'calendar-star', 'calendar-star-outline', 'calendar-start', 'calendar-start-outline', 'calendar-sync', 'calendar-sync-outline', 'calendar-text', 'calendar-text-outline', 'calendar-today', 'calendar-today-outline', 'calendar-week', 'calendar-week-begin', 'calendar-week-begin-outline', 'calendar-week-outline', 'calendar-weekend', 'calendar-weekend-outline', 'call-made', 'call-merge', 'call-missed', 'call-received', 'call-split', 'camcorder', 'camcorder-off', 'camera', 'camera-account', 'camera-burst', 'camera-control', 'camera-document', 'camera-document-off', 'camera-enhance', 'camera-enhance-outline', 'camera-flip', 'camera-flip-outline', 'camera-front', 'camera-front-variant', 'camera-gopro', 'camera-image', 'camera-iris', 'camera-lock', 'camera-lock-open', 'camera-lock-open-outline', 'camera-lock-outline', 'camera-marker', 'camera-marker-outline', 'camera-metering-center', 'camera-metering-matrix', 'camera-metering-partial', 'camera-metering-spot', 'camera-off', 'camera-off-outline', 'camera-outline', 'camera-party-mode', 'camera-plus', 'camera-plus-outline', 'camera-rear', 'camera-rear-variant', 'camera-retake', 'camera-retake-outline', 'camera-switch', 'camera-switch-outline', 'camera-timer', 'camera-wireless', 'camera-wireless-outline', 'campfire', 'cancel', 'candelabra', 'candelabra-fire', 'candle', 'candy', 'candy-off', 'candy-off-outline', 'candy-outline', 'candycane', 'cannabis', 'cannabis-off', 'caps-lock', 'car', 'car-2-plus', 'car-3-plus', 'car-arrow-left', 'car-arrow-right', 'car-back', 'car-battery', 'car-brake-abs', 'car-brake-alert', 'car-brake-fluid-level', 'car-brake-hold', 'car-brake-low-pressure', 'car-brake-parking', 'car-brake-retarder', 'car-brake-temperature', 'car-brake-worn-linings', 'car-child-seat', 'car-clock', 'car-clutch', 'car-cog', 'car-connected', 'car-convertible', 'car-coolant-level', 'car-cruise-control', 'car-defrost-front', 'car-defrost-rear', 'car-door', 'car-door-lock', 'car-electric', 'car-electric-outline', 'car-emergency', 'car-esp', 'car-estate', 'car-hatchback', 'car-info', 'car-key', 'car-lifted-pickup', 'car-light-alert', 'car-light-dimmed', 'car-light-fog', 'car-light-high', 'car-limousine', 'car-multiple', 'car-off', 'car-outline', 'car-parking-lights', 'car-pickup', 'car-search', 'car-search-outline', 'car-seat', 'car-seat-cooler', 'car-seat-heater', 'car-select', 'car-settings', 'car-shift-pattern', 'car-side', 'car-speed-limiter', 'car-sports', 'car-tire-alert', 'car-traction-control', 'car-turbocharger', 'car-wash', 'car-windshield', 'car-windshield-outline', 'car-wireless', 'car-wrench', 'carabiner', 'caravan', 'card', 'card-account-details', 'card-account-details-outline', 'card-account-details-star', 'card-account-details-star-outline', 'card-account-mail', 'card-account-mail-outline', 'card-account-phone', 'card-account-phone-outline', 'card-bulleted', 'card-bulleted-off', 'card-bulleted-off-outline', 'card-bulleted-outline', 'card-bulleted-settings', 'card-bulleted-settings-outline', 'card-minus', 'card-minus-outline', 'card-multiple', 'card-multiple-outline', 'card-off', 'card-off-outline', 'card-outline', 'card-plus', 'card-plus-outline', 'card-remove', 'card-remove-outline', 'card-search', 'card-search-outline', 'card-text', 'card-text-outline', 'cards', 'cards-club', 'cards-club-outline', 'cards-diamond', 'cards-diamond-outline', 'cards-heart', 'cards-heart-outline', 'cards-outline', 'cards-playing', 'cards-playing-club', 'cards-playing-club-multiple', 'cards-playing-club-multiple-outline', 'cards-playing-club-outline', 'cards-playing-diamond', 'cards-playing-diamond-multiple', 'cards-playing-diamond-multiple-outline', 'cards-playing-diamond-outline', 'cards-playing-heart', 'cards-playing-heart-multiple', 'cards-playing-heart-multiple-outline', 'cards-playing-heart-outline', 'cards-playing-outline', 'cards-playing-spade', 'cards-playing-spade-multiple', 'cards-playing-spade-multiple-outline', 'cards-playing-spade-outline', 'cards-spade', 'cards-spade-outline', 'cards-variant', 'carrot', 'cart', 'cart-arrow-down', 'cart-arrow-right', 'cart-arrow-up', 'cart-check', 'cart-heart', 'cart-minus', 'cart-off', 'cart-outline', 'cart-percent', 'cart-plus', 'cart-remove', 'cart-variant', 'case-sensitive-alt', 'cash', 'cash-100', 'cash-check', 'cash-clock', 'cash-fast', 'cash-lock', 'cash-lock-open', 'cash-marker', 'cash-minus', 'cash-multiple', 'cash-plus', 'cash-refund', 'cash-register', 'cash-remove', 'cash-sync', 'cassette', 'cast', 'cast-audio', 'cast-audio-variant', 'cast-connected', 'cast-education', 'cast-off', 'cast-variant', 'castle', 'cat', 'cctv', 'cctv-off', 'ceiling-fan', 'ceiling-fan-light', 'ceiling-light', 'ceiling-light-multiple', 'ceiling-light-multiple-outline', 'ceiling-light-outline', 'cellphone', 'cellphone-arrow-down', 'cellphone-arrow-down-variant', 'cellphone-basic', 'cellphone-charging', 'cellphone-check', 'cellphone-cog', 'cellphone-dock', 'cellphone-information', 'cellphone-key', 'cellphone-link', 'cellphone-link-off', 'cellphone-lock', 'cellphone-marker', 'cellphone-message', 'cellphone-message-off', 'cellphone-nfc', 'cellphone-nfc-off', 'cellphone-off', 'cellphone-play', 'cellphone-remove', 'cellphone-screenshot', 'cellphone-settings', 'cellphone-sound', 'cellphone-text', 'cellphone-wireless', 'centos', 'certificate', 'certificate-outline', 'chair-rolling', 'chair-school', 'chandelier', 'charity', 'chart-arc', 'chart-areaspline', 'chart-areaspline-variant', 'chart-bar', 'chart-bar-stacked', 'chart-bell-curve', 'chart-bell-curve-cumulative', 'chart-box', 'chart-box-outline', 'chart-box-plus-outline', 'chart-bubble', 'chart-donut', 'chart-donut-variant', 'chart-gantt', 'chart-histogram', 'chart-line', 'chart-line-stacked', 'chart-line-variant', 'chart-multiline', 'chart-multiple', 'chart-pie', 'chart-pie-outline', 'chart-ppf', 'chart-sankey', 'chart-sankey-variant', 'chart-scatter-plot', 'chart-scatter-plot-hexbin', 'chart-timeline', 'chart-timeline-variant', 'chart-timeline-variant-shimmer', 'chart-tree', 'chart-waterfall', 'chat', 'chat-alert', 'chat-alert-outline', 'chat-minus', 'chat-minus-outline', 'chat-outline', 'chat-plus', 'chat-plus-outline', 'chat-processing', 'chat-processing-outline', 'chat-question', 'chat-question-outline', 'chat-remove', 'chat-remove-outline', 'chat-sleep', 'chat-sleep-outline', 'check', 'check-all', 'check-bold', 'check-circle', 'check-circle-outline', 'check-decagram', 'check-decagram-outline', 'check-network', 'check-network-outline', 'check-outline', 'check-underline', 'check-underline-circle', 'check-underline-circle-outline', 'checkbook', 'checkbox-blank', 'checkbox-blank-badge', 'checkbox-blank-badge-outline', 'checkbox-blank-circle', 'checkbox-blank-circle-outline', 'checkbox-blank-off', 'checkbox-blank-off-outline', 'checkbox-blank-outline', 'checkbox-intermediate', 'checkbox-intermediate-variant', 'checkbox-marked', 'checkbox-marked-circle', 'checkbox-marked-circle-outline', 'checkbox-marked-circle-plus-outline', 'checkbox-marked-outline', 'checkbox-multiple-blank', 'checkbox-multiple-blank-circle', 'checkbox-multiple-blank-circle-outline', 'checkbox-multiple-blank-outline', 'checkbox-multiple-marked', 'checkbox-multiple-marked-circle', 'checkbox-multiple-marked-circle-outline', 'checkbox-multiple-marked-outline', 'checkbox-multiple-outline', 'checkbox-outline', 'checkerboard', 'checkerboard-minus', 'checkerboard-plus', 'checkerboard-remove', 'cheese', 'cheese-off', 'chef-hat', 'chemical-weapon', 'chess-bishop', 'chess-king', 'chess-knight', 'chess-pawn', 'chess-queen', 'chess-rook', 'chevron-double-down', 'chevron-double-left', 'chevron-double-right', 'chevron-double-up', 'chevron-down', 'chevron-down-box', 'chevron-down-box-outline', 'chevron-down-circle', 'chevron-down-circle-outline', 'chevron-left', 'chevron-left-box', 'chevron-left-box-outline', 'chevron-left-circle', 'chevron-left-circle-outline', 'chevron-right', 'chevron-right-box', 'chevron-right-box-outline', 'chevron-right-circle', 'chevron-right-circle-outline', 'chevron-triple-down', 'chevron-triple-left', 'chevron-triple-right', 'chevron-triple-up', 'chevron-up', 'chevron-up-box', 'chevron-up-box-outline', 'chevron-up-circle', 'chevron-up-circle-outline', 'chili-alert', 'chili-alert-outline', 'chili-hot', 'chili-hot-outline', 'chili-medium', 'chili-medium-outline', 'chili-mild', 'chili-mild-outline', 'chili-off', 'chili-off-outline', 'chip', 'church', 'church-outline', 'cigar', 'cigar-off', 'circle', 'circle-box', 'circle-box-outline', 'circle-double', 'circle-edit-outline', 'circle-expand', 'circle-half', 'circle-half-full', 'circle-medium', 'circle-multiple', 'circle-multiple-outline', 'circle-off-outline', 'circle-opacity', 'circle-outline', 'circle-slice-1', 'circle-slice-2', 'circle-slice-3', 'circle-slice-4', 'circle-slice-5', 'circle-slice-6', 'circle-slice-7', 'circle-slice-8', 'circle-small', 'circular-saw', 'city', 'city-variant', 'city-variant-outline', 'clipboard', 'clipboard-account', 'clipboard-account-outline', 'clipboard-alert', 'clipboard-alert-outline', 'clipboard-arrow-down', 'clipboard-arrow-down-outline', 'clipboard-arrow-left', 'clipboard-arrow-left-outline', 'clipboard-arrow-right', 'clipboard-arrow-right-outline', 'clipboard-arrow-up', 'clipboard-arrow-up-outline', 'clipboard-check', 'clipboard-check-multiple', 'clipboard-check-multiple-outline', 'clipboard-check-outline', 'clipboard-clock', 'clipboard-clock-outline', 'clipboard-edit', 'clipboard-edit-outline', 'clipboard-file', 'clipboard-file-outline', 'clipboard-flow', 'clipboard-flow-outline', 'clipboard-list', 'clipboard-list-outline', 'clipboard-minus', 'clipboard-minus-outline', 'clipboard-multiple', 'clipboard-multiple-outline', 'clipboard-off', 'clipboard-off-outline', 'clipboard-outline', 'clipboard-play', 'clipboard-play-multiple', 'clipboard-play-multiple-outline', 'clipboard-play-outline', 'clipboard-plus', 'clipboard-plus-outline', 'clipboard-pulse', 'clipboard-pulse-outline', 'clipboard-remove', 'clipboard-remove-outline', 'clipboard-search', 'clipboard-search-outline', 'clipboard-text', 'clipboard-text-clock', 'clipboard-text-clock-outline', 'clipboard-text-multiple', 'clipboard-text-multiple-outline', 'clipboard-text-off', 'clipboard-text-off-outline', 'clipboard-text-outline', 'clipboard-text-play', 'clipboard-text-play-outline', 'clipboard-text-search', 'clipboard-text-search-outline', 'clippy', 'clock', 'clock-alert', 'clock-alert-outline', 'clock-check', 'clock-check-outline', 'clock-digital', 'clock-edit', 'clock-edit-outline', 'clock-end', 'clock-fast', 'clock-in', 'clock-minus', 'clock-minus-outline', 'clock-out', 'clock-outline', 'clock-plus', 'clock-plus-outline', 'clock-remove', 'clock-remove-outline', 'clock-start', 'clock-time-eight', 'clock-time-eight-outline', 'clock-time-eleven', 'clock-time-eleven-outline', 'clock-time-five', 'clock-time-five-outline', 'clock-time-four', 'clock-time-four-outline', 'clock-time-nine', 'clock-time-nine-outline', 'clock-time-one', 'clock-time-one-outline', 'clock-time-seven', 'clock-time-seven-outline', 'clock-time-six', 'clock-time-six-outline', 'clock-time-ten', 'clock-time-ten-outline', 'clock-time-three', 'clock-time-three-outline', 'clock-time-twelve', 'clock-time-twelve-outline', 'clock-time-two', 'clock-time-two-outline', 'close', 'close-box', 'close-box-multiple', 'close-box-multiple-outline', 'close-box-outline', 'close-circle', 'close-circle-multiple', 'close-circle-multiple-outline', 'close-circle-outline', 'close-network', 'close-network-outline', 'close-octagon', 'close-octagon-outline', 'close-outline', 'close-thick', 'closed-caption', 'closed-caption-outline', 'cloud', 'cloud-alert', 'cloud-alert-outline', 'cloud-arrow-down', 'cloud-arrow-down-outline', 'cloud-arrow-left', 'cloud-arrow-left-outline', 'cloud-arrow-right', 'cloud-arrow-right-outline', 'cloud-arrow-up', 'cloud-arrow-up-outline', 'cloud-braces', 'cloud-cancel', 'cloud-cancel-outline', 'cloud-check', 'cloud-check-outline', 'cloud-check-variant', 'cloud-check-variant-outline', 'cloud-circle', 'cloud-circle-outline', 'cloud-clock', 'cloud-clock-outline', 'cloud-cog', 'cloud-cog-outline', 'cloud-download', 'cloud-download-outline', 'cloud-lock', 'cloud-lock-open', 'cloud-lock-open-outline', 'cloud-lock-outline', 'cloud-minus', 'cloud-minus-outline', 'cloud-off', 'cloud-off-outline', 'cloud-outline', 'cloud-percent', 'cloud-percent-outline', 'cloud-plus', 'cloud-plus-outline', 'cloud-print', 'cloud-print-outline', 'cloud-question', 'cloud-question-outline', 'cloud-refresh', 'cloud-refresh-outline', 'cloud-refresh-variant', 'cloud-refresh-variant-outline', 'cloud-remove', 'cloud-remove-outline', 'cloud-search', 'cloud-search-outline', 'cloud-sync', 'cloud-sync-outline', 'cloud-tags', 'cloud-upload', 'cloud-upload-outline', 'clouds', 'clover', 'coach-lamp', 'coach-lamp-variant', 'coat-rack', 'code-array', 'code-braces', 'code-braces-box', 'code-brackets', 'code-equal', 'code-greater-than', 'code-greater-than-or-equal', 'code-json', 'code-less-than', 'code-less-than-or-equal', 'code-not-equal', 'code-not-equal-variant', 'code-parentheses', 'code-parentheses-box', 'code-string', 'code-tags', 'code-tags-check', 'codepen', 'coffee', 'coffee-maker', 'coffee-maker-check', 'coffee-maker-check-outline', 'coffee-maker-outline', 'coffee-off', 'coffee-off-outline', 'coffee-outline', 'coffee-to-go', 'coffee-to-go-outline', 'coffin', 'cog', 'cog-box', 'cog-clockwise', 'cog-counterclockwise', 'cog-off', 'cog-off-outline', 'cog-outline', 'cog-pause', 'cog-pause-outline', 'cog-play', 'cog-play-outline', 'cog-refresh', 'cog-refresh-outline', 'cog-stop', 'cog-stop-outline', 'cog-sync', 'cog-sync-outline', 'cog-transfer', 'cog-transfer-outline', 'cogs', 'collage', 'collapse-all', 'collapse-all-outline', 'color-helper', 'comma', 'comma-box', 'comma-box-outline', 'comma-circle', 'comma-circle-outline', 'comment', 'comment-account', 'comment-account-outline', 'comment-alert', 'comment-alert-outline', 'comment-arrow-left', 'comment-arrow-left-outline', 'comment-arrow-right', 'comment-arrow-right-outline', 'comment-bookmark', 'comment-bookmark-outline', 'comment-check', 'comment-check-outline', 'comment-edit', 'comment-edit-outline', 'comment-eye', 'comment-eye-outline', 'comment-flash', 'comment-flash-outline', 'comment-minus', 'comment-minus-outline', 'comment-multiple', 'comment-multiple-outline', 'comment-off', 'comment-off-outline', 'comment-outline', 'comment-plus', 'comment-plus-outline', 'comment-processing', 'comment-processing-outline', 'comment-question', 'comment-question-outline', 'comment-quote', 'comment-quote-outline', 'comment-remove', 'comment-remove-outline', 'comment-search', 'comment-search-outline', 'comment-text', 'comment-text-multiple', 'comment-text-multiple-outline', 'comment-text-outline', 'compare', 'compare-horizontal', 'compare-remove', 'compare-vertical', 'compass', 'compass-off', 'compass-off-outline', 'compass-outline', 'compass-rose', 'compost', 'cone', 'cone-off', 'connection', 'console', 'console-line', 'console-network', 'console-network-outline', 'consolidate', 'contactless-payment', 'contactless-payment-circle', 'contactless-payment-circle-outline', 'contacts', 'contacts-outline', 'contain', 'contain-end', 'contain-start', 'content-copy', 'content-cut', 'content-duplicate', 'content-paste', 'content-save', 'content-save-alert', 'content-save-alert-outline', 'content-save-all', 'content-save-all-outline', 'content-save-check', 'content-save-check-outline', 'content-save-cog', 'content-save-cog-outline', 'content-save-edit', 'content-save-edit-outline', 'content-save-minus', 'content-save-minus-outline', 'content-save-move', 'content-save-move-outline', 'content-save-off', 'content-save-off-outline', 'content-save-outline', 'content-save-plus', 'content-save-plus-outline', 'content-save-settings', 'content-save-settings-outline', 'contrast', 'contrast-box', 'contrast-circle', 'controller', 'controller-classic', 'controller-classic-outline', 'controller-off', 'cookie', 'cookie-alert', 'cookie-alert-outline', 'cookie-check', 'cookie-check-outline', 'cookie-clock', 'cookie-clock-outline', 'cookie-cog', 'cookie-cog-outline', 'cookie-edit', 'cookie-edit-outline', 'cookie-lock', 'cookie-lock-outline', 'cookie-minus', 'cookie-minus-outline', 'cookie-off', 'cookie-off-outline', 'cookie-outline', 'cookie-plus', 'cookie-plus-outline', 'cookie-refresh', 'cookie-refresh-outline', 'cookie-remove', 'cookie-remove-outline', 'cookie-settings', 'cookie-settings-outline', 'coolant-temperature', 'copyleft', 'copyright', 'cordova', 'corn', 'corn-off', 'cosine-wave', 'counter', 'countertop', 'countertop-outline', 'cow', 'cow-off', 'cpu-32-bit', 'cpu-64-bit', 'cradle', 'cradle-outline', 'crane', 'creation', 'creative-commons', 'credit-card', 'credit-card-check', 'credit-card-check-outline', 'credit-card-chip', 'credit-card-chip-outline', 'credit-card-clock', 'credit-card-clock-outline', 'credit-card-edit', 'credit-card-edit-outline', 'credit-card-fast', 'credit-card-fast-outline', 'credit-card-lock', 'credit-card-lock-outline', 'credit-card-marker', 'credit-card-marker-outline', 'credit-card-minus', 'credit-card-minus-outline', 'credit-card-multiple', 'credit-card-multiple-outline', 'credit-card-off', 'credit-card-off-outline', 'credit-card-outline', 'credit-card-plus', 'credit-card-plus-outline', 'credit-card-refresh', 'credit-card-refresh-outline', 'credit-card-refund', 'credit-card-refund-outline', 'credit-card-remove', 'credit-card-remove-outline', 'credit-card-scan', 'credit-card-scan-outline', 'credit-card-search', 'credit-card-search-outline', 'credit-card-settings', 'credit-card-settings-outline', 'credit-card-sync', 'credit-card-sync-outline', 'credit-card-wireless', 'credit-card-wireless-off', 'credit-card-wireless-off-outline', 'credit-card-wireless-outline', 'cricket', 'crop', 'crop-free', 'crop-landscape', 'crop-portrait', 'crop-rotate', 'crop-square', 'cross', 'cross-bolnisi', 'cross-celtic', 'cross-outline', 'crosshairs', 'crosshairs-gps', 'crosshairs-off', 'crosshairs-question', 'crowd', 'crown', 'crown-circle', 'crown-circle-outline', 'crown-outline', 'cryengine', 'crystal-ball', 'cube', 'cube-off', 'cube-off-outline', 'cube-outline', 'cube-scan', 'cube-send', 'cube-unfolded', 'cup', 'cup-off', 'cup-off-outline', 'cup-outline', 'cup-water', 'cupboard', 'cupboard-outline', 'cupcake', 'curling', 'currency-bdt', 'currency-brl', 'currency-btc', 'currency-cny', 'currency-eth', 'currency-eur', 'currency-eur-off', 'currency-fra', 'currency-gbp', 'currency-ils', 'currency-inr', 'currency-jpy', 'currency-krw', 'currency-kzt', 'currency-mnt', 'currency-ngn', 'currency-php', 'currency-rial', 'currency-rub', 'currency-rupee', 'currency-sign', 'currency-thb', 'currency-try', 'currency-twd', 'currency-uah', 'currency-usd', 'currency-usd-off', 'current-ac', 'current-dc', 'cursor-default', 'cursor-default-click', 'cursor-default-click-outline', 'cursor-default-gesture', 'cursor-default-gesture-outline', 'cursor-default-outline', 'cursor-move', 'cursor-pointer', 'cursor-text', 'curtains', 'curtains-closed', 'cylinder', 'cylinder-off', 'dance-ballroom', 'dance-pole', 'data-matrix', 'data-matrix-edit', 'data-matrix-minus', 'data-matrix-plus', 'data-matrix-remove', 'data-matrix-scan', 'database', 'database-alert', 'database-alert-outline', 'database-arrow-down', 'database-arrow-down-outline', 'database-arrow-left', 'database-arrow-left-outline', 'database-arrow-right', 'database-arrow-right-outline', 'database-arrow-up', 'database-arrow-up-outline', 'database-check', 'database-check-outline', 'database-clock', 'database-clock-outline', 'database-cog', 'database-cog-outline', 'database-edit', 'database-edit-outline', 'database-export', 'database-export-outline', 'database-eye', 'database-eye-off', 'database-eye-off-outline', 'database-eye-outline', 'database-import', 'database-import-outline', 'database-lock', 'database-lock-outline', 'database-marker', 'database-marker-outline', 'database-minus', 'database-minus-outline', 'database-off', 'database-off-outline', 'database-outline', 'database-plus', 'database-plus-outline', 'database-refresh', 'database-refresh-outline', 'database-remove', 'database-remove-outline', 'database-search', 'database-search-outline', 'database-settings', 'database-settings-outline', 'database-sync', 'database-sync-outline', 'death-star', 'death-star-variant', 'deathly-hallows', 'debian', 'debug-step-into', 'debug-step-out', 'debug-step-over', 'decagram', 'decagram-outline', 'decimal', 'decimal-comma', 'decimal-comma-decrease', 'decimal-comma-increase', 'decimal-decrease', 'decimal-increase', 'delete', 'delete-alert', 'delete-alert-outline', 'delete-circle', 'delete-circle-outline', 'delete-clock', 'delete-clock-outline', 'delete-empty', 'delete-empty-outline', 'delete-forever', 'delete-forever-outline', 'delete-off', 'delete-off-outline', 'delete-outline', 'delete-restore', 'delete-sweep', 'delete-sweep-outline', 'delete-variant', 'delta', 'desk', 'desk-lamp', 'desk-lamp-off', 'desk-lamp-on', 'deskphone', 'desktop-classic', 'desktop-tower', 'desktop-tower-monitor', 'details', 'dev-to', 'developer-board', 'deviantart', 'devices', 'dharmachakra', 'diabetes', 'dialpad', 'diameter', 'diameter-outline', 'diameter-variant', 'diamond', 'diamond-outline', 'diamond-stone', 'dice-1', 'dice-1-outline', 'dice-2', 'dice-2-outline', 'dice-3', 'dice-3-outline', 'dice-4', 'dice-4-outline', 'dice-5', 'dice-5-outline', 'dice-6', 'dice-6-outline', 'dice-d10', 'dice-d10-outline', 'dice-d12', 'dice-d12-outline', 'dice-d20', 'dice-d20-outline', 'dice-d4', 'dice-d4-outline', 'dice-d6', 'dice-d6-outline', 'dice-d8', 'dice-d8-outline', 'dice-multiple', 'dice-multiple-outline', 'digital-ocean', 'dip-switch', 'directions', 'directions-fork', 'disc', 'disc-alert', 'disc-player', 'dishwasher', 'dishwasher-alert', 'dishwasher-off', 'disqus', 'distribute-horizontal-center', 'distribute-horizontal-left', 'distribute-horizontal-right', 'distribute-vertical-bottom', 'distribute-vertical-center', 'distribute-vertical-top', 'diversify', 'diving', 'diving-flippers', 'diving-helmet', 'diving-scuba', 'diving-scuba-flag', 'diving-scuba-mask', 'diving-scuba-tank', 'diving-scuba-tank-multiple', 'diving-snorkel', 'division', 'division-box', 'dlna', 'dna', 'dns', 'dns-outline', 'dock-bottom', 'dock-left', 'dock-right', 'dock-top', 'dock-window', 'docker', 'doctor', 'dog', 'dog-service', 'dog-side', 'dog-side-off', 'dolby', 'dolly', 'dolphin', 'domain', 'domain-off', 'domain-plus', 'domain-remove', 'dome-light', 'domino-mask', 'donkey', 'door', 'door-closed', 'door-closed-lock', 'door-open', 'door-sliding', 'door-sliding-lock', 'door-sliding-open', 'doorbell', 'doorbell-video', 'dot-net', 'dots-circle', 'dots-grid', 'dots-hexagon', 'dots-horizontal', 'dots-horizontal-circle', 'dots-horizontal-circle-outline', 'dots-square', 'dots-triangle', 'dots-vertical', 'dots-vertical-circle', 'dots-vertical-circle-outline', 'download', 'download-box', 'download-box-outline', 'download-circle', 'download-circle-outline', 'download-lock', 'download-lock-outline', 'download-multiple', 'download-network', 'download-network-outline', 'download-off', 'download-off-outline', 'download-outline', 'drag', 'drag-horizontal', 'drag-horizontal-variant', 'drag-variant', 'drag-vertical', 'drag-vertical-variant', 'drama-masks', 'draw', 'draw-pen', 'drawing', 'drawing-box', 'dresser', 'dresser-outline', 'drone', 'dropbox', 'drupal', 'duck', 'dumbbell', 'dump-truck', 'ear-hearing', 'ear-hearing-loop', 'ear-hearing-off', 'earbuds', 'earbuds-off', 'earbuds-off-outline', 'earbuds-outline', 'earth', 'earth-arrow-right', 'earth-box', 'earth-box-minus', 'earth-box-off', 'earth-box-plus', 'earth-box-remove', 'earth-minus', 'earth-off', 'earth-plus', 'earth-remove', 'egg', 'egg-easter', 'egg-fried', 'egg-off', 'egg-off-outline', 'egg-outline', 'eiffel-tower', 'eight-track', 'eject', 'eject-circle', 'eject-circle-outline', 'eject-outline', 'electric-switch', 'electric-switch-closed', 'electron-framework', 'elephant', 'elevation-decline', 'elevation-rise', 'elevator', 'elevator-down', 'elevator-passenger', 'elevator-passenger-off', 'elevator-passenger-off-outline', 'elevator-passenger-outline', 'elevator-up', 'ellipse', 'ellipse-outline', 'email', 'email-alert', 'email-alert-outline', 'email-arrow-left', 'email-arrow-left-outline', 'email-arrow-right', 'email-arrow-right-outline', 'email-box', 'email-check', 'email-check-outline', 'email-edit', 'email-edit-outline', 'email-fast', 'email-fast-outline', 'email-lock', 'email-lock-outline', 'email-mark-as-unread', 'email-minus', 'email-minus-outline', 'email-multiple', 'email-multiple-outline', 'email-newsletter', 'email-off', 'email-off-outline', 'email-open', 'email-open-multiple', 'email-open-multiple-outline', 'email-open-outline', 'email-outline', 'email-plus', 'email-plus-outline', 'email-remove', 'email-remove-outline', 'email-seal', 'email-seal-outline', 'email-search', 'email-search-outline', 'email-sync', 'email-sync-outline', 'email-variant', 'ember', 'emby', 'emoticon', 'emoticon-angry', 'emoticon-angry-outline', 'emoticon-confused', 'emoticon-confused-outline', 'emoticon-cool', 'emoticon-cool-outline', 'emoticon-cry', 'emoticon-cry-outline', 'emoticon-dead', 'emoticon-dead-outline', 'emoticon-devil', 'emoticon-devil-outline', 'emoticon-excited', 'emoticon-excited-outline', 'emoticon-frown', 'emoticon-frown-outline', 'emoticon-happy', 'emoticon-happy-outline', 'emoticon-kiss', 'emoticon-kiss-outline', 'emoticon-lol', 'emoticon-lol-outline', 'emoticon-neutral', 'emoticon-neutral-outline', 'emoticon-outline', 'emoticon-poop', 'emoticon-poop-outline', 'emoticon-sad', 'emoticon-sad-outline', 'emoticon-sick', 'emoticon-sick-outline', 'emoticon-tongue', 'emoticon-tongue-outline', 'emoticon-wink', 'emoticon-wink-outline', 'engine', 'engine-off', 'engine-off-outline', 'engine-outline', 'epsilon', 'equal', 'equal-box', 'equalizer', 'equalizer-outline', 'eraser', 'eraser-variant', 'escalator', 'escalator-box', 'escalator-down', 'escalator-up', 'eslint', 'et', 'ethereum', 'ethernet', 'ethernet-cable', 'ethernet-cable-off', 'ev-plug-ccs1', 'ev-plug-ccs2', 'ev-plug-chademo', 'ev-plug-tesla', 'ev-plug-type1', 'ev-plug-type2', 'ev-station', 'evernote', 'excavator', 'exclamation', 'exclamation-thick', 'exit-run', 'exit-to-app', 'expand-all', 'expand-all-outline', 'expansion-card', 'expansion-card-variant', 'exponent', 'exponent-box', 'export', 'export-variant', 'eye', 'eye-arrow-left', 'eye-arrow-left-outline', 'eye-arrow-right', 'eye-arrow-right-outline', 'eye-check', 'eye-check-outline', 'eye-circle', 'eye-circle-outline', 'eye-lock', 'eye-lock-open', 'eye-lock-open-outline', 'eye-lock-outline', 'eye-minus', 'eye-minus-outline', 'eye-off', 'eye-off-outline', 'eye-outline', 'eye-plus', 'eye-plus-outline', 'eye-refresh', 'eye-refresh-outline', 'eye-remove', 'eye-remove-outline', 'eye-settings', 'eye-settings-outline', 'eyedropper', 'eyedropper-minus', 'eyedropper-off', 'eyedropper-plus', 'eyedropper-remove', 'eyedropper-variant', 'face-agent', 'face-man', 'face-man-outline', 'face-man-profile', 'face-man-shimmer', 'face-man-shimmer-outline', 'face-mask', 'face-mask-outline', 'face-recognition', 'face-woman', 'face-woman-outline', 'face-woman-profile', 'face-woman-shimmer', 'face-woman-shimmer-outline', 'facebook', 'facebook-gaming', 'facebook-messenger', 'facebook-workplace', 'factory', 'family-tree', 'fan', 'fan-alert', 'fan-auto', 'fan-chevron-down', 'fan-chevron-up', 'fan-clock', 'fan-minus', 'fan-off', 'fan-plus', 'fan-remove', 'fan-speed-1', 'fan-speed-2', 'fan-speed-3', 'fast-forward', 'fast-forward-10', 'fast-forward-15', 'fast-forward-30', 'fast-forward-45', 'fast-forward-5', 'fast-forward-60', 'fast-forward-outline', 'faucet', 'faucet-variant', 'fax', 'feather', 'feature-search', 'feature-search-outline', 'fedora', 'fence', 'fence-electric', 'fencing', 'ferris-wheel', 'ferry', 'file', 'file-account', 'file-account-outline', 'file-alert', 'file-alert-outline', 'file-arrow-left-right', 'file-arrow-left-right-outline', 'file-arrow-up-down', 'file-arrow-up-down-outline', 'file-cabinet', 'file-cad', 'file-cad-box', 'file-cancel', 'file-cancel-outline', 'file-certificate', 'file-certificate-outline', 'file-chart', 'file-chart-check', 'file-chart-check-outline', 'file-chart-outline', 'file-check', 'file-check-outline', 'file-clock', 'file-clock-outline', 'file-cloud', 'file-cloud-outline', 'file-code', 'file-code-outline', 'file-cog', 'file-cog-outline', 'file-compare', 'file-delimited', 'file-delimited-outline', 'file-document', 'file-document-alert', 'file-document-alert-outline', 'file-document-arrow-right', 'file-document-arrow-right-outline', 'file-document-check', 'file-document-check-outline', 'file-document-edit', 'file-document-edit-outline', 'file-document-minus', 'file-document-minus-outline', 'file-document-multiple', 'file-document-multiple-outline', 'file-document-outline', 'file-document-plus', 'file-document-plus-outline', 'file-document-remove', 'file-document-remove-outline', 'file-download', 'file-download-outline', 'file-edit', 'file-edit-outline', 'file-excel', 'file-excel-box', 'file-excel-box-outline', 'file-excel-outline', 'file-export', 'file-export-outline', 'file-eye', 'file-eye-outline', 'file-find', 'file-find-outline', 'file-gif-box', 'file-hidden', 'file-image', 'file-image-marker', 'file-image-marker-outline', 'file-image-minus', 'file-image-minus-outline', 'file-image-outline', 'file-image-plus', 'file-image-plus-outline', 'file-image-remove', 'file-image-remove-outline', 'file-import', 'file-import-outline', 'file-jpg-box', 'file-key', 'file-key-outline', 'file-link', 'file-link-outline', 'file-lock', 'file-lock-open', 'file-lock-open-outline', 'file-lock-outline', 'file-marker', 'file-marker-outline', 'file-minus', 'file-minus-outline', 'file-move', 'file-move-outline', 'file-multiple', 'file-multiple-outline', 'file-music', 'file-music-outline', 'file-outline', 'file-pdf-box', 'file-percent', 'file-percent-outline', 'file-phone', 'file-phone-outline', 'file-plus', 'file-plus-outline', 'file-png-box', 'file-powerpoint', 'file-powerpoint-box', 'file-powerpoint-box-outline', 'file-powerpoint-outline', 'file-presentation-box', 'file-question', 'file-question-outline', 'file-refresh', 'file-refresh-outline', 'file-remove', 'file-remove-outline', 'file-replace', 'file-replace-outline', 'file-restore', 'file-restore-outline', 'file-rotate-left', 'file-rotate-left-outline', 'file-rotate-right', 'file-rotate-right-outline', 'file-search', 'file-search-outline', 'file-send', 'file-send-outline', 'file-settings', 'file-settings-outline', 'file-sign', 'file-star', 'file-star-outline', 'file-swap', 'file-swap-outline', 'file-sync', 'file-sync-outline', 'file-table', 'file-table-box', 'file-table-box-multiple', 'file-table-box-multiple-outline', 'file-table-box-outline', 'file-table-outline', 'file-tree', 'file-tree-outline', 'file-undo', 'file-undo-outline', 'file-upload', 'file-upload-outline', 'file-video', 'file-video-outline', 'file-word', 'file-word-box', 'file-word-box-outline', 'file-word-outline', 'file-xml-box', 'film', 'filmstrip', 'filmstrip-box', 'filmstrip-box-multiple', 'filmstrip-off', 'filter', 'filter-check', 'filter-check-outline', 'filter-cog', 'filter-cog-outline', 'filter-menu', 'filter-menu-outline', 'filter-minus', 'filter-minus-outline', 'filter-multiple', 'filter-multiple-outline', 'filter-off', 'filter-off-outline', 'filter-outline', 'filter-plus', 'filter-plus-outline', 'filter-remove', 'filter-remove-outline', 'filter-settings', 'filter-settings-outline', 'filter-variant', 'filter-variant-minus', 'filter-variant-plus', 'filter-variant-remove', 'finance', 'find-replace', 'fingerprint', 'fingerprint-off', 'fire', 'fire-alert', 'fire-circle', 'fire-extinguisher', 'fire-hydrant', 'fire-hydrant-alert', 'fire-hydrant-off', 'fire-off', 'fire-truck', 'firebase', 'firefox', 'fireplace', 'fireplace-off', 'firewire', 'firework', 'firework-off', 'fish', 'fish-off', 'fishbowl', 'fishbowl-outline', 'fit-to-page', 'fit-to-page-outline', 'fit-to-screen', 'fit-to-screen-outline', 'flag', 'flag-checkered', 'flag-minus', 'flag-minus-outline', 'flag-off', 'flag-off-outline', 'flag-outline', 'flag-plus', 'flag-plus-outline', 'flag-remove', 'flag-remove-outline', 'flag-triangle', 'flag-variant', 'flag-variant-minus', 'flag-variant-minus-outline', 'flag-variant-off', 'flag-variant-off-outline', 'flag-variant-outline', 'flag-variant-plus', 'flag-variant-plus-outline', 'flag-variant-remove', 'flag-variant-remove-outline', 'flare', 'flash', 'flash-alert', 'flash-alert-outline', 'flash-auto', 'flash-off', 'flash-off-outline', 'flash-outline', 'flash-red-eye', 'flash-triangle', 'flash-triangle-outline', 'flashlight', 'flashlight-off', 'flask', 'flask-empty', 'flask-empty-minus', 'flask-empty-minus-outline', 'flask-empty-off', 'flask-empty-off-outline', 'flask-empty-outline', 'flask-empty-plus', 'flask-empty-plus-outline', 'flask-empty-remove', 'flask-empty-remove-outline', 'flask-minus', 'flask-minus-outline', 'flask-off', 'flask-off-outline', 'flask-outline', 'flask-plus', 'flask-plus-outline', 'flask-remove', 'flask-remove-outline', 'flask-round-bottom', 'flask-round-bottom-empty', 'flask-round-bottom-empty-outline', 'flask-round-bottom-outline', 'fleur-de-lis', 'flip-horizontal', 'flip-to-back', 'flip-to-front', 'flip-vertical', 'floor-lamp', 'floor-lamp-dual', 'floor-lamp-dual-outline', 'floor-lamp-outline', 'floor-lamp-torchiere', 'floor-lamp-torchiere-outline', 'floor-lamp-torchiere-variant', 'floor-lamp-torchiere-variant-outline', 'floor-plan', 'floppy', 'floppy-variant', 'flower', 'flower-outline', 'flower-pollen', 'flower-pollen-outline', 'flower-poppy', 'flower-tulip', 'flower-tulip-outline', 'focus-auto', 'focus-field', 'focus-field-horizontal', 'focus-field-vertical', 'folder', 'folder-account', 'folder-account-outline', 'folder-alert', 'folder-alert-outline', 'folder-arrow-down', 'folder-arrow-down-outline', 'folder-arrow-left', 'folder-arrow-left-outline', 'folder-arrow-left-right', 'folder-arrow-left-right-outline', 'folder-arrow-right', 'folder-arrow-right-outline', 'folder-arrow-up', 'folder-arrow-up-down', 'folder-arrow-up-down-outline', 'folder-arrow-up-outline', 'folder-cancel', 'folder-cancel-outline', 'folder-check', 'folder-check-outline', 'folder-clock', 'folder-clock-outline', 'folder-cog', 'folder-cog-outline', 'folder-download', 'folder-download-outline', 'folder-edit', 'folder-edit-outline', 'folder-eye', 'folder-eye-outline', 'folder-file', 'folder-file-outline', 'folder-google-drive', 'folder-heart', 'folder-heart-outline', 'folder-hidden', 'folder-home', 'folder-home-outline', 'folder-image', 'folder-information', 'folder-information-outline', 'folder-key', 'folder-key-network', 'folder-key-network-outline', 'folder-key-outline', 'folder-lock', 'folder-lock-open', 'folder-lock-open-outline', 'folder-lock-outline', 'folder-marker', 'folder-marker-outline', 'folder-minus', 'folder-minus-outline', 'folder-move', 'folder-move-outline', 'folder-multiple', 'folder-multiple-image', 'folder-multiple-outline', 'folder-multiple-plus', 'folder-multiple-plus-outline', 'folder-music', 'folder-music-outline', 'folder-network', 'folder-network-outline', 'folder-off', 'folder-off-outline', 'folder-open', 'folder-open-outline', 'folder-outline', 'folder-play', 'folder-play-outline', 'folder-plus', 'folder-plus-outline', 'folder-pound', 'folder-pound-outline', 'folder-question', 'folder-question-outline', 'folder-refresh', 'folder-refresh-outline', 'folder-remove', 'folder-remove-outline', 'folder-search', 'folder-search-outline', 'folder-settings', 'folder-settings-outline', 'folder-star', 'folder-star-multiple', 'folder-star-multiple-outline', 'folder-star-outline', 'folder-swap', 'folder-swap-outline', 'folder-sync', 'folder-sync-outline', 'folder-table', 'folder-table-outline', 'folder-text', 'folder-text-outline', 'folder-upload', 'folder-upload-outline', 'folder-wrench', 'folder-wrench-outline', 'folder-zip', 'folder-zip-outline', 'font-awesome', 'food', 'food-apple', 'food-apple-outline', 'food-croissant', 'food-drumstick', 'food-drumstick-off', 'food-drumstick-off-outline', 'food-drumstick-outline', 'food-fork-drink', 'food-halal', 'food-hot-dog', 'food-kosher', 'food-off', 'food-off-outline', 'food-outline', 'food-steak', 'food-steak-off', 'food-takeout-box', 'food-takeout-box-outline', 'food-turkey', 'food-variant', 'food-variant-off', 'foot-print', 'football', 'football-australian', 'football-helmet', 'forest', 'forklift', 'form-dropdown', 'form-select', 'form-textarea', 'form-textbox', 'form-textbox-lock', 'form-textbox-password', 'format-align-bottom', 'format-align-center', 'format-align-justify', 'format-align-left', 'format-align-middle', 'format-align-right', 'format-align-top', 'format-annotation-minus', 'format-annotation-plus', 'format-bold', 'format-clear', 'format-color-fill', 'format-color-highlight', 'format-color-marker-cancel', 'format-color-text', 'format-columns', 'format-float-center', 'format-float-left', 'format-float-none', 'format-float-right', 'format-font', 'format-font-size-decrease', 'format-font-size-increase', 'format-header-1', 'format-header-2', 'format-header-3', 'format-header-4', 'format-header-5', 'format-header-6', 'format-header-decrease', 'format-header-equal', 'format-header-increase', 'format-header-pound', 'format-horizontal-align-center', 'format-horizontal-align-left', 'format-horizontal-align-right', 'format-indent-decrease', 'format-indent-increase', 'format-italic', 'format-letter-case', 'format-letter-case-lower', 'format-letter-case-upper', 'format-letter-ends-with', 'format-letter-matches', 'format-letter-spacing', 'format-letter-spacing-variant', 'format-letter-starts-with', 'format-line-height', 'format-line-spacing', 'format-line-style', 'format-line-weight', 'format-list-bulleted', 'format-list-bulleted-square', 'format-list-bulleted-triangle', 'format-list-bulleted-type', 'format-list-checkbox', 'format-list-checks', 'format-list-group', 'format-list-group-plus', 'format-list-numbered', 'format-list-numbered-rtl', 'format-list-text', 'format-overline', 'format-page-break', 'format-page-split', 'format-paint', 'format-paragraph', 'format-paragraph-spacing', 'format-pilcrow', 'format-pilcrow-arrow-left', 'format-pilcrow-arrow-right', 'format-quote-close', 'format-quote-close-outline', 'format-quote-open', 'format-quote-open-outline', 'format-rotate-90', 'format-section', 'format-size', 'format-strikethrough', 'format-strikethrough-variant', 'format-subscript', 'format-superscript', 'format-text', 'format-text-rotation-angle-down', 'format-text-rotation-angle-up', 'format-text-rotation-down', 'format-text-rotation-down-vertical', 'format-text-rotation-none', 'format-text-rotation-up', 'format-text-rotation-vertical', 'format-text-variant', 'format-text-variant-outline', 'format-text-wrapping-clip', 'format-text-wrapping-overflow', 'format-text-wrapping-wrap', 'format-textbox', 'format-title', 'format-underline', 'format-underline-wavy', 'format-vertical-align-bottom', 'format-vertical-align-center', 'format-vertical-align-top', 'format-wrap-inline', 'format-wrap-square', 'format-wrap-tight', 'format-wrap-top-bottom', 'forum', 'forum-minus', 'forum-minus-outline', 'forum-outline', 'forum-plus', 'forum-plus-outline', 'forum-remove', 'forum-remove-outline', 'forward', 'forwardburger', 'fountain', 'fountain-pen', 'fountain-pen-tip', 'fraction-one-half', 'freebsd', 'french-fries', 'frequently-asked-questions', 'fridge', 'fridge-alert', 'fridge-alert-outline', 'fridge-bottom', 'fridge-industrial', 'fridge-industrial-alert', 'fridge-industrial-alert-outline', 'fridge-industrial-off', 'fridge-industrial-off-outline', 'fridge-industrial-outline', 'fridge-off', 'fridge-off-outline', 'fridge-outline', 'fridge-top', 'fridge-variant', 'fridge-variant-alert', 'fridge-variant-alert-outline', 'fridge-variant-off', 'fridge-variant-off-outline', 'fridge-variant-outline', 'fruit-cherries', 'fruit-cherries-off', 'fruit-citrus', 'fruit-citrus-off', 'fruit-grapes', 'fruit-grapes-outline', 'fruit-pear', 'fruit-pineapple', 'fruit-watermelon', 'fuel', 'fuel-cell', 'fullscreen', 'fullscreen-exit', 'function', 'function-variant', 'furigana-horizontal', 'furigana-vertical', 'fuse', 'fuse-alert', 'fuse-blade', 'fuse-off', 'gamepad', 'gamepad-circle', 'gamepad-circle-down', 'gamepad-circle-left', 'gamepad-circle-outline', 'gamepad-circle-right', 'gamepad-circle-up', 'gamepad-down', 'gamepad-left', 'gamepad-outline', 'gamepad-right', 'gamepad-round', 'gamepad-round-down', 'gamepad-round-left', 'gamepad-round-outline', 'gamepad-round-right', 'gamepad-round-up', 'gamepad-square', 'gamepad-square-outline', 'gamepad-up', 'gamepad-variant', 'gamepad-variant-outline', 'gamma', 'gantry-crane', 'garage', 'garage-alert', 'garage-alert-variant', 'garage-lock', 'garage-open', 'garage-open-variant', 'garage-variant', 'garage-variant-lock', 'gas-burner', 'gas-cylinder', 'gas-station', 'gas-station-off', 'gas-station-off-outline', 'gas-station-outline', 'gate', 'gate-alert', 'gate-and', 'gate-arrow-left', 'gate-arrow-right', 'gate-buffer', 'gate-nand', 'gate-nor', 'gate-not', 'gate-open', 'gate-or', 'gate-xnor', 'gate-xor', 'gatsby', 'gauge', 'gauge-empty', 'gauge-full', 'gauge-low', 'gavel', 'gender-female', 'gender-male', 'gender-male-female', 'gender-male-female-variant', 'gender-non-binary', 'gender-transgender', 'gentoo', 'gesture', 'gesture-double-tap', 'gesture-pinch', 'gesture-spread', 'gesture-swipe', 'gesture-swipe-down', 'gesture-swipe-horizontal', 'gesture-swipe-left', 'gesture-swipe-right', 'gesture-swipe-up', 'gesture-swipe-vertical', 'gesture-tap', 'gesture-tap-box', 'gesture-tap-button', 'gesture-tap-hold', 'gesture-two-double-tap', 'gesture-two-tap', 'ghost', 'ghost-off', 'ghost-off-outline', 'ghost-outline', 'gift', 'gift-off', 'gift-off-outline', 'gift-open', 'gift-open-outline', 'gift-outline', 'git', 'github', 'gitlab', 'glass-cocktail', 'glass-cocktail-off', 'glass-flute', 'glass-fragile', 'glass-mug', 'glass-mug-off', 'glass-mug-variant', 'glass-mug-variant-off', 'glass-pint-outline', 'glass-stange', 'glass-tulip', 'glass-wine', 'glasses', 'globe-light', 'globe-light-outline', 'globe-model', 'gmail', 'gnome', 'go-kart', 'go-kart-track', 'gog', 'gold', 'golf', 'golf-cart', 'golf-tee', 'gondola', 'goodreads', 'google', 'google-ads', 'google-analytics', 'google-assistant', 'google-cardboard', 'google-chrome', 'google-circles', 'google-circles-communities', 'google-circles-extended', 'google-circles-group', 'google-classroom', 'google-cloud', 'google-downasaur', 'google-drive', 'google-earth', 'google-fit', 'google-glass', 'google-hangouts', 'google-keep', 'google-lens', 'google-maps', 'google-my-business', 'google-nearby', 'google-play', 'google-plus', 'google-podcast', 'google-spreadsheet', 'google-street-view', 'google-translate', 'gradient-horizontal', 'gradient-vertical', 'grain', 'graph', 'graph-outline', 'graphql', 'grass', 'grave-stone', 'grease-pencil', 'greater-than', 'greater-than-or-equal', 'greenhouse', 'grid', 'grid-large', 'grid-off', 'grill', 'grill-outline', 'group', 'guitar-acoustic', 'guitar-electric', 'guitar-pick', 'guitar-pick-outline', 'guy-fawkes-mask', 'gymnastics', 'hail', 'hair-dryer', 'hair-dryer-outline', 'halloween', 'hamburger', 'hamburger-check', 'hamburger-minus', 'hamburger-off', 'hamburger-plus', 'hamburger-remove', 'hammer', 'hammer-screwdriver', 'hammer-sickle', 'hammer-wrench', 'hand-back-left', 'hand-back-left-off', 'hand-back-left-off-outline', 'hand-back-left-outline', 'hand-back-right', 'hand-back-right-off', 'hand-back-right-off-outline', 'hand-back-right-outline', 'hand-clap', 'hand-clap-off', 'hand-coin', 'hand-coin-outline', 'hand-cycle', 'hand-extended', 'hand-extended-outline', 'hand-front-left', 'hand-front-left-outline', 'hand-front-right', 'hand-front-right-outline', 'hand-heart', 'hand-heart-outline', 'hand-okay', 'hand-peace', 'hand-peace-variant', 'hand-pointing-down', 'hand-pointing-left', 'hand-pointing-right', 'hand-pointing-up', 'hand-saw', 'hand-wash', 'hand-wash-outline', 'hand-water', 'hand-wave', 'hand-wave-outline', 'handball', 'handcuffs', 'hands-pray', 'handshake', 'handshake-outline', 'hanger', 'hard-hat', 'harddisk', 'harddisk-plus', 'harddisk-remove', 'hat-fedora', 'hazard-lights', 'hdmi-port', 'hdr', 'hdr-off', 'head', 'head-alert', 'head-alert-outline', 'head-check', 'head-check-outline', 'head-cog', 'head-cog-outline', 'head-dots-horizontal', 'head-dots-horizontal-outline', 'head-flash', 'head-flash-outline', 'head-heart', 'head-heart-outline', 'head-lightbulb', 'head-lightbulb-outline', 'head-minus', 'head-minus-outline', 'head-outline', 'head-plus', 'head-plus-outline', 'head-question', 'head-question-outline', 'head-remove', 'head-remove-outline', 'head-snowflake', 'head-snowflake-outline', 'head-sync', 'head-sync-outline', 'headphones', 'headphones-bluetooth', 'headphones-box', 'headphones-off', 'headphones-settings', 'headset', 'headset-dock', 'headset-off', 'heart', 'heart-box', 'heart-box-outline', 'heart-broken', 'heart-broken-outline', 'heart-circle', 'heart-circle-outline', 'heart-cog', 'heart-cog-outline', 'heart-flash', 'heart-half', 'heart-half-full', 'heart-half-outline', 'heart-minus', 'heart-minus-outline', 'heart-multiple', 'heart-multiple-outline', 'heart-off', 'heart-off-outline', 'heart-outline', 'heart-plus', 'heart-plus-outline', 'heart-pulse', 'heart-remove', 'heart-remove-outline', 'heart-settings', 'heart-settings-outline', 'heat-pump', 'heat-pump-outline', 'heat-wave', 'heating-coil', 'helicopter', 'help', 'help-box', 'help-box-multiple', 'help-box-multiple-outline', 'help-box-outline', 'help-circle', 'help-circle-outline', 'help-network', 'help-network-outline', 'help-rhombus', 'help-rhombus-outline', 'hexadecimal', 'hexagon', 'hexagon-multiple', 'hexagon-multiple-outline', 'hexagon-outline', 'hexagon-slice-1', 'hexagon-slice-2', 'hexagon-slice-3', 'hexagon-slice-4', 'hexagon-slice-5', 'hexagon-slice-6', 'hexagram', 'hexagram-outline', 'high-definition', 'high-definition-box', 'highway', 'hiking', 'history', 'hockey-puck', 'hockey-sticks', 'hololens', 'home', 'home-account', 'home-alert', 'home-alert-outline', 'home-analytics', 'home-assistant', 'home-automation', 'home-battery', 'home-battery-outline', 'home-circle', 'home-circle-outline', 'home-city', 'home-city-outline', 'home-clock', 'home-clock-outline', 'home-edit', 'home-edit-outline', 'home-export-outline', 'home-flood', 'home-floor-0', 'home-floor-1', 'home-floor-2', 'home-floor-3', 'home-floor-a', 'home-floor-b', 'home-floor-g', 'home-floor-l', 'home-floor-negative-1', 'home-group', 'home-group-minus', 'home-group-plus', 'home-group-remove', 'home-heart', 'home-import-outline', 'home-lightbulb', 'home-lightbulb-outline', 'home-lightning-bolt', 'home-lightning-bolt-outline', 'home-lock', 'home-lock-open', 'home-map-marker', 'home-minus', 'home-minus-outline', 'home-modern', 'home-off', 'home-off-outline', 'home-outline', 'home-plus', 'home-plus-outline', 'home-remove', 'home-remove-outline', 'home-roof', 'home-search', 'home-search-outline', 'home-silo', 'home-silo-outline', 'home-switch', 'home-switch-outline', 'home-thermometer', 'home-thermometer-outline', 'home-variant', 'home-variant-outline', 'hook', 'hook-off', 'hoop-house', 'hops', 'horizontal-rotate-clockwise', 'horizontal-rotate-counterclockwise', 'horse', 'horse-human', 'horse-variant', 'horse-variant-fast', 'horseshoe', 'hospital', 'hospital-box', 'hospital-box-outline', 'hospital-building', 'hospital-marker', 'hot-tub', 'hours-24', 'hubspot', 'hulu', 'human', 'human-baby-changing-table', 'human-cane', 'human-capacity-decrease', 'human-capacity-increase', 'human-child', 'human-dolly', 'human-edit', 'human-female', 'human-female-boy', 'human-female-dance', 'human-female-female', 'human-female-girl', 'human-greeting', 'human-greeting-proximity', 'human-greeting-variant', 'human-handsdown', 'human-handsup', 'human-male', 'human-male-board', 'human-male-board-poll', 'human-male-boy', 'human-male-child', 'human-male-female', 'human-male-female-child', 'human-male-girl', 'human-male-height', 'human-male-height-variant', 'human-male-male', 'human-non-binary', 'human-pregnant', 'human-queue', 'human-scooter', 'human-walker', 'human-wheelchair', 'human-white-cane', 'humble-bundle', 'hvac', 'hvac-off', 'hydraulic-oil-level', 'hydraulic-oil-temperature', 'hydro-power', 'hydrogen-station', 'ice-cream', 'ice-cream-off', 'ice-pop', 'id-card', 'identifier', 'ideogram-cjk', 'ideogram-cjk-variant', 'image', 'image-album', 'image-area', 'image-area-close', 'image-auto-adjust', 'image-broken', 'image-broken-variant', 'image-check', 'image-check-outline', 'image-edit', 'image-edit-outline', 'image-filter-black-white', 'image-filter-center-focus', 'image-filter-center-focus-strong', 'image-filter-center-focus-strong-outline', 'image-filter-center-focus-weak', 'image-filter-drama', 'image-filter-drama-outline', 'image-filter-frames', 'image-filter-hdr', 'image-filter-none', 'image-filter-tilt-shift', 'image-filter-vintage', 'image-frame', 'image-lock', 'image-lock-outline', 'image-marker', 'image-marker-outline', 'image-minus', 'image-minus-outline', 'image-move', 'image-multiple', 'image-multiple-outline', 'image-off', 'image-off-outline', 'image-outline', 'image-plus', 'image-plus-outline', 'image-refresh', 'image-refresh-outline', 'image-remove', 'image-remove-outline', 'image-search', 'image-search-outline', 'image-size-select-actual', 'image-size-select-large', 'image-size-select-small', 'image-sync', 'image-sync-outline', 'image-text', 'import', 'inbox', 'inbox-arrow-down', 'inbox-arrow-down-outline', 'inbox-arrow-up', 'inbox-arrow-up-outline', 'inbox-full', 'inbox-full-outline', 'inbox-multiple', 'inbox-multiple-outline', 'inbox-outline', 'inbox-remove', 'inbox-remove-outline', 'incognito', 'incognito-circle', 'incognito-circle-off', 'incognito-off', 'induction', 'infinity', 'information', 'information-off', 'information-off-outline', 'information-outline', 'information-variant', 'instagram', 'instrument-triangle', 'integrated-circuit-chip', 'invert-colors', 'invert-colors-off', 'iobroker', 'ip', 'ip-network', 'ip-network-outline', 'ip-outline', 'ipod', 'iron', 'iron-board', 'iron-outline', 'island', 'iv-bag', 'jabber', 'jeepney', 'jellyfish', 'jellyfish-outline', 'jira', 'jquery', 'jsfiddle', 'jump-rope', 'kabaddi', 'kangaroo', 'karate', 'kayaking', 'keg', 'kettle', 'kettle-alert', 'kettle-alert-outline', 'kettle-off', 'kettle-off-outline', 'kettle-outline', 'kettle-pour-over', 'kettle-steam', 'kettle-steam-outline', 'kettlebell', 'key', 'key-alert', 'key-alert-outline', 'key-arrow-right', 'key-chain', 'key-chain-variant', 'key-change', 'key-link', 'key-minus', 'key-outline', 'key-plus', 'key-remove', 'key-star', 'key-variant', 'key-wireless', 'keyboard', 'keyboard-backspace', 'keyboard-caps', 'keyboard-close', 'keyboard-close-outline', 'keyboard-esc', 'keyboard-f1', 'keyboard-f10', 'keyboard-f11', 'keyboard-f12', 'keyboard-f2', 'keyboard-f3', 'keyboard-f4', 'keyboard-f5', 'keyboard-f6', 'keyboard-f7', 'keyboard-f8', 'keyboard-f9', 'keyboard-off', 'keyboard-off-outline', 'keyboard-outline', 'keyboard-return', 'keyboard-settings', 'keyboard-settings-outline', 'keyboard-space', 'keyboard-tab', 'keyboard-tab-reverse', 'keyboard-variant', 'khanda', 'kickstarter', 'kite', 'kite-outline', 'kitesurfing', 'klingon', 'knife', 'knife-military', 'knob', 'koala', 'kodi', 'kubernetes', 'label', 'label-multiple', 'label-multiple-outline', 'label-off', 'label-off-outline', 'label-outline', 'label-percent', 'label-percent-outline', 'label-variant', 'label-variant-outline', 'ladder', 'ladybug', 'lambda', 'lamp', 'lamp-outline', 'lamps', 'lamps-outline', 'lan', 'lan-check', 'lan-connect', 'lan-disconnect', 'lan-pending', 'land-fields', 'land-plots', 'land-plots-circle', 'land-plots-circle-variant', 'land-rows-horizontal', 'land-rows-vertical', 'landslide', 'landslide-outline', 'language-c', 'language-cpp', 'language-csharp', 'language-css3', 'language-fortran', 'language-go', 'language-haskell', 'language-html5', 'language-java', 'language-javascript', 'language-kotlin', 'language-lua', 'language-markdown', 'language-markdown-outline', 'language-php', 'language-python', 'language-r', 'language-ruby', 'language-ruby-on-rails', 'language-rust', 'language-swift', 'language-typescript', 'language-xaml', 'laptop', 'laptop-account', 'laptop-off', 'laravel', 'laser-pointer', 'lasso', 'lastpass', 'latitude', 'launch', 'lava-lamp', 'layers', 'layers-edit', 'layers-minus', 'layers-off', 'layers-off-outline', 'layers-outline', 'layers-plus', 'layers-remove', 'layers-search', 'layers-search-outline', 'layers-triple', 'layers-triple-outline', 'lead-pencil', 'leaf', 'leaf-circle', 'leaf-circle-outline', 'leaf-maple', 'leaf-maple-off', 'leaf-off', 'leak', 'leak-off', 'lectern', 'led-off', 'led-on', 'led-outline', 'led-strip', 'led-strip-variant', 'led-strip-variant-off', 'led-variant-off', 'led-variant-on', 'led-variant-outline', 'leek', 'less-than', 'less-than-or-equal', 'library', 'library-outline', 'library-shelves', 'license', 'lifebuoy', 'light-flood-down', 'light-flood-up', 'light-recessed', 'light-switch', 'light-switch-off', 'lightbulb', 'lightbulb-alert', 'lightbulb-alert-outline', 'lightbulb-auto', 'lightbulb-auto-outline', 'lightbulb-cfl', 'lightbulb-cfl-off', 'lightbulb-cfl-spiral', 'lightbulb-cfl-spiral-off', 'lightbulb-fluorescent-tube', 'lightbulb-fluorescent-tube-outline', 'lightbulb-group', 'lightbulb-group-off', 'lightbulb-group-off-outline', 'lightbulb-group-outline', 'lightbulb-multiple', 'lightbulb-multiple-off', 'lightbulb-multiple-off-outline', 'lightbulb-multiple-outline', 'lightbulb-night', 'lightbulb-night-outline', 'lightbulb-off', 'lightbulb-off-outline', 'lightbulb-on', 'lightbulb-on-10', 'lightbulb-on-20', 'lightbulb-on-30', 'lightbulb-on-40', 'lightbulb-on-50', 'lightbulb-on-60', 'lightbulb-on-70', 'lightbulb-on-80', 'lightbulb-on-90', 'lightbulb-on-outline', 'lightbulb-outline', 'lightbulb-question', 'lightbulb-question-outline', 'lightbulb-spot', 'lightbulb-spot-off', 'lightbulb-variant', 'lightbulb-variant-outline', 'lighthouse', 'lighthouse-on', 'lightning-bolt', 'lightning-bolt-circle', 'lightning-bolt-outline', 'line-scan', 'lingerie', 'link', 'link-box', 'link-box-outline', 'link-box-variant', 'link-box-variant-outline', 'link-lock', 'link-off', 'link-plus', 'link-variant', 'link-variant-minus', 'link-variant-off', 'link-variant-plus', 'link-variant-remove', 'linkedin', 'linux', 'linux-mint', 'lipstick', 'liquid-spot', 'liquor', 'list-box', 'list-box-outline', 'list-status', 'litecoin', 'loading', 'location-enter', 'location-exit', 'lock', 'lock-alert', 'lock-alert-outline', 'lock-check', 'lock-check-outline', 'lock-clock', 'lock-minus', 'lock-minus-outline', 'lock-off', 'lock-off-outline', 'lock-open', 'lock-open-alert', 'lock-open-alert-outline', 'lock-open-check', 'lock-open-check-outline', 'lock-open-minus', 'lock-open-minus-outline', 'lock-open-outline', 'lock-open-plus', 'lock-open-plus-outline', 'lock-open-remove', 'lock-open-remove-outline', 'lock-open-variant', 'lock-open-variant-outline', 'lock-outline', 'lock-pattern', 'lock-percent', 'lock-percent-open', 'lock-percent-open-outline', 'lock-percent-open-variant', 'lock-percent-open-variant-outline', 'lock-percent-outline', 'lock-plus', 'lock-plus-outline', 'lock-question', 'lock-remove', 'lock-remove-outline', 'lock-reset', 'lock-smart', 'locker', 'locker-multiple', 'login', 'login-variant', 'logout', 'logout-variant', 'longitude', 'looks', 'lotion', 'lotion-outline', 'lotion-plus', 'lotion-plus-outline', 'loupe', 'lumx', 'lungs', 'mace', 'magazine-pistol', 'magazine-rifle', 'magic-staff', 'magnet', 'magnet-on', 'magnify', 'magnify-close', 'magnify-expand', 'magnify-minus', 'magnify-minus-cursor', 'magnify-minus-outline', 'magnify-plus', 'magnify-plus-cursor', 'magnify-plus-outline', 'magnify-remove-cursor', 'magnify-remove-outline', 'magnify-scan', 'mail', 'mailbox', 'mailbox-open', 'mailbox-open-outline', 'mailbox-open-up', 'mailbox-open-up-outline', 'mailbox-outline', 'mailbox-up', 'mailbox-up-outline', 'manjaro', 'map', 'map-check', 'map-check-outline', 'map-clock', 'map-clock-outline', 'map-legend', 'map-marker', 'map-marker-account', 'map-marker-account-outline', 'map-marker-alert', 'map-marker-alert-outline', 'map-marker-check', 'map-marker-check-outline', 'map-marker-circle', 'map-marker-distance', 'map-marker-down', 'map-marker-left', 'map-marker-left-outline', 'map-marker-minus', 'map-marker-minus-outline', 'map-marker-multiple', 'map-marker-multiple-outline', 'map-marker-off', 'map-marker-off-outline', 'map-marker-outline', 'map-marker-path', 'map-marker-plus', 'map-marker-plus-outline', 'map-marker-question', 'map-marker-question-outline', 'map-marker-radius', 'map-marker-radius-outline', 'map-marker-remove', 'map-marker-remove-outline', 'map-marker-remove-variant', 'map-marker-right', 'map-marker-right-outline', 'map-marker-star', 'map-marker-star-outline', 'map-marker-up', 'map-minus', 'map-outline', 'map-plus', 'map-search', 'map-search-outline', 'mapbox', 'margin', 'marker', 'marker-cancel', 'marker-check', 'mastodon', 'material-design', 'material-ui', 'math-compass', 'math-cos', 'math-integral', 'math-integral-box', 'math-log', 'math-norm', 'math-norm-box', 'math-sin', 'math-tan', 'matrix', 'medal', 'medal-outline', 'medical-bag', 'medical-cotton-swab', 'medication', 'medication-outline', 'meditation', 'memory', 'menorah', 'menorah-fire', 'menu', 'menu-down', 'menu-down-outline', 'menu-left', 'menu-left-outline', 'menu-open', 'menu-right', 'menu-right-outline', 'menu-swap', 'menu-swap-outline', 'menu-up', 'menu-up-outline', 'merge', 'message', 'message-alert', 'message-alert-outline', 'message-arrow-left', 'message-arrow-left-outline', 'message-arrow-right', 'message-arrow-right-outline', 'message-badge', 'message-badge-outline', 'message-bookmark', 'message-bookmark-outline', 'message-bulleted', 'message-bulleted-off', 'message-check', 'message-check-outline', 'message-cog', 'message-cog-outline', 'message-draw', 'message-fast', 'message-fast-outline', 'message-flash', 'message-flash-outline', 'message-image', 'message-image-outline', 'message-lock', 'message-lock-outline', 'message-minus', 'message-minus-outline', 'message-off', 'message-off-outline', 'message-outline', 'message-plus', 'message-plus-outline', 'message-processing', 'message-processing-outline', 'message-question', 'message-question-outline', 'message-reply', 'message-reply-outline', 'message-reply-text', 'message-reply-text-outline', 'message-settings', 'message-settings-outline', 'message-star', 'message-star-outline', 'message-text', 'message-text-clock', 'message-text-clock-outline', 'message-text-fast', 'message-text-fast-outline', 'message-text-lock', 'message-text-lock-outline', 'message-text-outline', 'message-video', 'meteor', 'meter-electric', 'meter-electric-outline', 'meter-gas', 'meter-gas-outline', 'metronome', 'metronome-tick', 'micro-sd', 'microphone', 'microphone-message', 'microphone-message-off', 'microphone-minus', 'microphone-off', 'microphone-outline', 'microphone-plus', 'microphone-question', 'microphone-question-outline', 'microphone-settings', 'microphone-variant', 'microphone-variant-off', 'microscope', 'microsoft', 'microsoft-access', 'microsoft-azure', 'microsoft-azure-devops', 'microsoft-bing', 'microsoft-dynamics-365', 'microsoft-edge', 'microsoft-excel', 'microsoft-internet-explorer', 'microsoft-office', 'microsoft-onedrive', 'microsoft-onenote', 'microsoft-outlook', 'microsoft-powerpoint', 'microsoft-sharepoint', 'microsoft-teams', 'microsoft-visual-studio', 'microsoft-visual-studio-code', 'microsoft-windows', 'microsoft-windows-classic', 'microsoft-word', 'microsoft-xbox', 'microsoft-xbox-controller', 'microsoft-xbox-controller-battery-alert', 'microsoft-xbox-controller-battery-charging', 'microsoft-xbox-controller-battery-empty', 'microsoft-xbox-controller-battery-full', 'microsoft-xbox-controller-battery-low', 'microsoft-xbox-controller-battery-medium', 'microsoft-xbox-controller-battery-unknown', 'microsoft-xbox-controller-menu', 'microsoft-xbox-controller-off', 'microsoft-xbox-controller-view', 'microwave', 'microwave-off', 'middleware', 'middleware-outline', 'midi', 'midi-port', 'mine', 'minecraft', 'mini-sd', 'minidisc', 'minus', 'minus-box', 'minus-box-multiple', 'minus-box-multiple-outline', 'minus-box-outline', 'minus-circle', 'minus-circle-multiple', 'minus-circle-multiple-outline', 'minus-circle-off', 'minus-circle-off-outline', 'minus-circle-outline', 'minus-network', 'minus-network-outline', 'minus-thick', 'mirror', 'mirror-rectangle', 'mirror-variant', 'mixed-martial-arts', 'mixed-reality', 'molecule', 'molecule-co', 'molecule-co2', 'monitor', 'monitor-account', 'monitor-arrow-down', 'monitor-arrow-down-variant', 'monitor-cellphone', 'monitor-cellphone-star', 'monitor-dashboard', 'monitor-edit', 'monitor-eye', 'monitor-lock', 'monitor-multiple', 'monitor-off', 'monitor-screenshot', 'monitor-share', 'monitor-shimmer', 'monitor-small', 'monitor-speaker', 'monitor-speaker-off', 'monitor-star', 'moon-first-quarter', 'moon-full', 'moon-last-quarter', 'moon-new', 'moon-waning-crescent', 'moon-waning-gibbous', 'moon-waxing-crescent', 'moon-waxing-gibbous', 'moped', 'moped-electric', 'moped-electric-outline', 'moped-outline', 'more', 'mortar-pestle', 'mortar-pestle-plus', 'mosque', 'mosque-outline', 'mother-heart', 'mother-nurse', 'motion', 'motion-outline', 'motion-pause', 'motion-pause-outline', 'motion-play', 'motion-play-outline', 'motion-sensor', 'motion-sensor-off', 'motorbike', 'motorbike-electric', 'motorbike-off', 'mouse', 'mouse-bluetooth', 'mouse-move-down', 'mouse-move-up', 'mouse-move-vertical', 'mouse-off', 'mouse-variant', 'mouse-variant-off', 'move-resize', 'move-resize-variant', 'movie', 'movie-check', 'movie-check-outline', 'movie-cog', 'movie-cog-outline', 'movie-edit', 'movie-edit-outline', 'movie-filter', 'movie-filter-outline', 'movie-minus', 'movie-minus-outline', 'movie-off', 'movie-off-outline', 'movie-open', 'movie-open-check', 'movie-open-check-outline', 'movie-open-cog', 'movie-open-cog-outline', 'movie-open-edit', 'movie-open-edit-outline', 'movie-open-minus', 'movie-open-minus-outline', 'movie-open-off', 'movie-open-off-outline', 'movie-open-outline', 'movie-open-play', 'movie-open-play-outline', 'movie-open-plus', 'movie-open-plus-outline', 'movie-open-remove', 'movie-open-remove-outline', 'movie-open-settings', 'movie-open-settings-outline', 'movie-open-star', 'movie-open-star-outline', 'movie-outline', 'movie-play', 'movie-play-outline', 'movie-plus', 'movie-plus-outline', 'movie-remove', 'movie-remove-outline', 'movie-roll', 'movie-search', 'movie-search-outline', 'movie-settings', 'movie-settings-outline', 'movie-star', 'movie-star-outline', 'mower', 'mower-bag', 'mower-bag-on', 'mower-on', 'muffin', 'multicast', 'multimedia', 'multiplication', 'multiplication-box', 'mushroom', 'mushroom-off', 'mushroom-off-outline', 'mushroom-outline', 'music', 'music-accidental-double-flat', 'music-accidental-double-sharp', 'music-accidental-flat', 'music-accidental-natural', 'music-accidental-sharp', 'music-box', 'music-box-multiple', 'music-box-multiple-outline', 'music-box-outline', 'music-circle', 'music-circle-outline', 'music-clef-alto', 'music-clef-bass', 'music-clef-treble', 'music-note', 'music-note-bluetooth', 'music-note-bluetooth-off', 'music-note-eighth', 'music-note-eighth-dotted', 'music-note-half', 'music-note-half-dotted', 'music-note-minus', 'music-note-off', 'music-note-off-outline', 'music-note-outline', 'music-note-plus', 'music-note-quarter', 'music-note-quarter-dotted', 'music-note-sixteenth', 'music-note-sixteenth-dotted', 'music-note-whole', 'music-note-whole-dotted', 'music-off', 'music-rest-eighth', 'music-rest-half', 'music-rest-quarter', 'music-rest-sixteenth', 'music-rest-whole', 'mustache', 'nail', 'nas', 'nativescript', 'nature', 'nature-people', 'navigation', 'navigation-outline', 'navigation-variant', 'navigation-variant-outline', 'near-me', 'necklace', 'needle', 'needle-off', 'netflix', 'network', 'network-off', 'network-off-outline', 'network-outline', 'network-pos', 'network-strength-1', 'network-strength-1-alert', 'network-strength-2', 'network-strength-2-alert', 'network-strength-3', 'network-strength-3-alert', 'network-strength-4', 'network-strength-4-alert', 'network-strength-4-cog', 'network-strength-off', 'network-strength-off-outline', 'network-strength-outline', 'new-box', 'newspaper', 'newspaper-check', 'newspaper-minus', 'newspaper-plus', 'newspaper-remove', 'newspaper-variant', 'newspaper-variant-multiple', 'newspaper-variant-multiple-outline', 'newspaper-variant-outline', 'nfc', 'nfc-search-variant', 'nfc-tap', 'nfc-variant', 'nfc-variant-off', 'ninja', 'nintendo-game-boy', 'nintendo-switch', 'nintendo-wii', 'nintendo-wiiu', 'nix', 'nodejs', 'noodles', 'not-equal', 'not-equal-variant', 'note', 'note-alert', 'note-alert-outline', 'note-check', 'note-check-outline', 'note-edit', 'note-edit-outline', 'note-minus', 'note-minus-outline', 'note-multiple', 'note-multiple-outline', 'note-off', 'note-off-outline', 'note-outline', 'note-plus', 'note-plus-outline', 'note-remove', 'note-remove-outline', 'note-search', 'note-search-outline', 'note-text', 'note-text-outline', 'notebook', 'notebook-check', 'notebook-check-outline', 'notebook-edit', 'notebook-edit-outline', 'notebook-heart', 'notebook-heart-outline', 'notebook-minus', 'notebook-minus-outline', 'notebook-multiple', 'notebook-outline', 'notebook-plus', 'notebook-plus-outline', 'notebook-remove', 'notebook-remove-outline', 'notification-clear-all', 'npm', 'nuke', 'null', 'numeric', 'numeric-0', 'numeric-0-box', 'numeric-0-box-multiple', 'numeric-0-box-multiple-outline', 'numeric-0-box-outline', 'numeric-0-circle', 'numeric-0-circle-outline', 'numeric-1', 'numeric-1-box', 'numeric-1-box-multiple', 'numeric-1-box-multiple-outline', 'numeric-1-box-outline', 'numeric-1-circle', 'numeric-1-circle-outline', 'numeric-10', 'numeric-10-box', 'numeric-10-box-multiple', 'numeric-10-box-multiple-outline', 'numeric-10-box-outline', 'numeric-10-circle', 'numeric-10-circle-outline', 'numeric-2', 'numeric-2-box', 'numeric-2-box-multiple', 'numeric-2-box-multiple-outline', 'numeric-2-box-outline', 'numeric-2-circle', 'numeric-2-circle-outline', 'numeric-3', 'numeric-3-box', 'numeric-3-box-multiple', 'numeric-3-box-multiple-outline', 'numeric-3-box-outline', 'numeric-3-circle', 'numeric-3-circle-outline', 'numeric-4', 'numeric-4-box', 'numeric-4-box-multiple', 'numeric-4-box-multiple-outline', 'numeric-4-box-outline', 'numeric-4-circle', 'numeric-4-circle-outline', 'numeric-5', 'numeric-5-box', 'numeric-5-box-multiple', 'numeric-5-box-multiple-outline', 'numeric-5-box-outline', 'numeric-5-circle', 'numeric-5-circle-outline', 'numeric-6', 'numeric-6-box', 'numeric-6-box-multiple', 'numeric-6-box-multiple-outline', 'numeric-6-box-outline', 'numeric-6-circle', 'numeric-6-circle-outline', 'numeric-7', 'numeric-7-box', 'numeric-7-box-multiple', 'numeric-7-box-multiple-outline', 'numeric-7-box-outline', 'numeric-7-circle', 'numeric-7-circle-outline', 'numeric-8', 'numeric-8-box', 'numeric-8-box-multiple', 'numeric-8-box-multiple-outline', 'numeric-8-box-outline', 'numeric-8-circle', 'numeric-8-circle-outline', 'numeric-9', 'numeric-9-box', 'numeric-9-box-multiple', 'numeric-9-box-multiple-outline', 'numeric-9-box-outline', 'numeric-9-circle', 'numeric-9-circle-outline', 'numeric-9-plus', 'numeric-9-plus-box', 'numeric-9-plus-box-multiple', 'numeric-9-plus-box-multiple-outline', 'numeric-9-plus-box-outline', 'numeric-9-plus-circle', 'numeric-9-plus-circle-outline', 'numeric-negative-1', 'numeric-off', 'numeric-positive-1', 'nut', 'nutrition', 'nuxt', 'oar', 'ocarina', 'oci', 'ocr', 'octagon', 'octagon-outline', 'octagram', 'octagram-outline', 'octahedron', 'octahedron-off', 'odnoklassniki', 'offer', 'office-building', 'office-building-cog', 'office-building-cog-outline', 'office-building-marker', 'office-building-marker-outline', 'office-building-minus', 'office-building-minus-outline', 'office-building-outline', 'office-building-plus', 'office-building-plus-outline', 'office-building-remove', 'office-building-remove-outline', 'oil', 'oil-lamp', 'oil-level', 'oil-temperature', 'om', 'omega', 'one-up', 'onepassword', 'opacity', 'open-in-app', 'open-in-new', 'open-source-initiative', 'openid', 'opera', 'orbit', 'orbit-variant', 'order-alphabetical-ascending', 'order-alphabetical-descending', 'order-bool-ascending', 'order-bool-ascending-variant', 'order-bool-descending', 'order-bool-descending-variant', 'order-numeric-ascending', 'order-numeric-descending', 'origin', 'ornament', 'ornament-variant', 'outdoor-lamp', 'overscan', 'owl', 'pac-man', 'package', 'package-check', 'package-down', 'package-up', 'package-variant', 'package-variant-closed', 'package-variant-closed-check', 'package-variant-closed-minus', 'package-variant-closed-plus', 'package-variant-closed-remove', 'package-variant-minus', 'package-variant-plus', 'package-variant-remove', 'page-first', 'page-last', 'page-layout-body', 'page-layout-footer', 'page-layout-header', 'page-layout-header-footer', 'page-layout-sidebar-left', 'page-layout-sidebar-right', 'page-next', 'page-next-outline', 'page-previous', 'page-previous-outline', 'pail', 'pail-minus', 'pail-minus-outline', 'pail-off', 'pail-off-outline', 'pail-outline', 'pail-plus', 'pail-plus-outline', 'pail-remove', 'pail-remove-outline', 'palette', 'palette-advanced', 'palette-outline', 'palette-swatch', 'palette-swatch-outline', 'palette-swatch-variant', 'palm-tree', 'pan', 'pan-bottom-left', 'pan-bottom-right', 'pan-down', 'pan-horizontal', 'pan-left', 'pan-right', 'pan-top-left', 'pan-top-right', 'pan-up', 'pan-vertical', 'panda', 'pandora', 'panorama', 'panorama-fisheye', 'panorama-horizontal', 'panorama-horizontal-outline', 'panorama-outline', 'panorama-sphere', 'panorama-sphere-outline', 'panorama-variant', 'panorama-variant-outline', 'panorama-vertical', 'panorama-vertical-outline', 'panorama-wide-angle', 'panorama-wide-angle-outline', 'paper-cut-vertical', 'paper-roll', 'paper-roll-outline', 'paperclip', 'paperclip-check', 'paperclip-lock', 'paperclip-minus', 'paperclip-off', 'paperclip-plus', 'paperclip-remove', 'parachute', 'parachute-outline', 'paragliding', 'parking', 'party-popper', 'passport', 'passport-biometric', 'pasta', 'patio-heater', 'patreon', 'pause', 'pause-box', 'pause-box-outline', 'pause-circle', 'pause-circle-outline', 'pause-octagon', 'pause-octagon-outline', 'paw', 'paw-off', 'paw-off-outline', 'paw-outline', 'peace', 'peanut', 'peanut-off', 'peanut-off-outline', 'peanut-outline', 'pen', 'pen-lock', 'pen-minus', 'pen-off', 'pen-plus', 'pen-remove', 'pencil', 'pencil-box', 'pencil-box-multiple', 'pencil-box-multiple-outline', 'pencil-box-outline', 'pencil-circle', 'pencil-circle-outline', 'pencil-lock', 'pencil-lock-outline', 'pencil-minus', 'pencil-minus-outline', 'pencil-off', 'pencil-off-outline', 'pencil-outline', 'pencil-plus', 'pencil-plus-outline', 'pencil-remove', 'pencil-remove-outline', 'pencil-ruler', 'pencil-ruler-outline', 'penguin', 'pentagon', 'pentagon-outline', 'pentagram', 'percent', 'percent-box', 'percent-box-outline', 'percent-circle', 'percent-circle-outline', 'percent-outline', 'periodic-table', 'perspective-less', 'perspective-more', 'ph', 'phone', 'phone-alert', 'phone-alert-outline', 'phone-bluetooth', 'phone-bluetooth-outline', 'phone-cancel', 'phone-cancel-outline', 'phone-check', 'phone-check-outline', 'phone-classic', 'phone-classic-off', 'phone-clock', 'phone-dial', 'phone-dial-outline', 'phone-forward', 'phone-forward-outline', 'phone-hangup', 'phone-hangup-outline', 'phone-in-talk', 'phone-in-talk-outline', 'phone-incoming', 'phone-incoming-outgoing', 'phone-incoming-outgoing-outline', 'phone-incoming-outline', 'phone-lock', 'phone-lock-outline', 'phone-log', 'phone-log-outline', 'phone-message', 'phone-message-outline', 'phone-minus', 'phone-minus-outline', 'phone-missed', 'phone-missed-outline', 'phone-off', 'phone-off-outline', 'phone-outgoing', 'phone-outgoing-outline', 'phone-outline', 'phone-paused', 'phone-paused-outline', 'phone-plus', 'phone-plus-outline', 'phone-refresh', 'phone-refresh-outline', 'phone-remove', 'phone-remove-outline', 'phone-return', 'phone-return-outline', 'phone-ring', 'phone-ring-outline', 'phone-rotate-landscape', 'phone-rotate-portrait', 'phone-settings', 'phone-settings-outline', 'phone-sync', 'phone-sync-outline', 'phone-voip', 'pi', 'pi-box', 'pi-hole', 'piano', 'piano-off', 'pickaxe', 'picture-in-picture-bottom-right', 'picture-in-picture-bottom-right-outline', 'picture-in-picture-top-right', 'picture-in-picture-top-right-outline', 'pier', 'pier-crane', 'pig', 'pig-variant', 'pig-variant-outline', 'piggy-bank', 'piggy-bank-outline', 'pill', 'pill-multiple', 'pill-off', 'pillar', 'pin', 'pin-off', 'pin-off-outline', 'pin-outline', 'pine-tree', 'pine-tree-box', 'pine-tree-fire', 'pinterest', 'pinwheel', 'pinwheel-outline', 'pipe', 'pipe-disconnected', 'pipe-leak', 'pipe-valve', 'pipe-wrench', 'pirate', 'pistol', 'piston', 'pitchfork', 'pizza', 'plane-car', 'plane-train', 'play', 'play-box', 'play-box-lock', 'play-box-lock-open', 'play-box-lock-open-outline', 'play-box-lock-outline', 'play-box-multiple', 'play-box-multiple-outline', 'play-box-outline', 'play-circle', 'play-circle-outline', 'play-network', 'play-network-outline', 'play-outline', 'play-pause', 'play-protected-content', 'play-speed', 'playlist-check', 'playlist-edit', 'playlist-minus', 'playlist-music', 'playlist-music-outline', 'playlist-play', 'playlist-plus', 'playlist-remove', 'playlist-star', 'plex', 'pliers', 'plus', 'plus-box', 'plus-box-multiple', 'plus-box-multiple-outline', 'plus-box-outline', 'plus-circle', 'plus-circle-multiple', 'plus-circle-multiple-outline', 'plus-circle-outline', 'plus-lock', 'plus-lock-open', 'plus-minus', 'plus-minus-box', 'plus-minus-variant', 'plus-network', 'plus-network-outline', 'plus-outline', 'plus-thick', 'podcast', 'podium', 'podium-bronze', 'podium-gold', 'podium-silver', 'point-of-sale', 'pokeball', 'pokemon-go', 'poker-chip', 'polaroid', 'police-badge', 'police-badge-outline', 'police-station', 'poll', 'polo', 'polymer', 'pool', 'pool-thermometer', 'popcorn', 'post', 'post-lamp', 'post-outline', 'postage-stamp', 'pot', 'pot-mix', 'pot-mix-outline', 'pot-outline', 'pot-steam', 'pot-steam-outline', 'pound', 'pound-box', 'pound-box-outline', 'power', 'power-cycle', 'power-off', 'power-on', 'power-plug', 'power-plug-off', 'power-plug-off-outline', 'power-plug-outline', 'power-settings', 'power-sleep', 'power-socket', 'power-socket-au', 'power-socket-ch', 'power-socket-de', 'power-socket-eu', 'power-socket-fr', 'power-socket-it', 'power-socket-jp', 'power-socket-uk', 'power-socket-us', 'power-standby', 'powershell', 'prescription', 'presentation', 'presentation-play', 'pretzel', 'printer', 'printer-3d', 'printer-3d-nozzle', 'printer-3d-nozzle-alert', 'printer-3d-nozzle-alert-outline', 'printer-3d-nozzle-heat', 'printer-3d-nozzle-heat-outline', 'printer-3d-nozzle-off', 'printer-3d-nozzle-off-outline', 'printer-3d-nozzle-outline', 'printer-3d-off', 'printer-alert', 'printer-check', 'printer-eye', 'printer-off', 'printer-off-outline', 'printer-outline', 'printer-pos', 'printer-pos-alert', 'printer-pos-alert-outline', 'printer-pos-cancel', 'printer-pos-cancel-outline', 'printer-pos-check', 'printer-pos-check-outline', 'printer-pos-cog', 'printer-pos-cog-outline', 'printer-pos-edit', 'printer-pos-edit-outline', 'printer-pos-minus', 'printer-pos-minus-outline', 'printer-pos-network', 'printer-pos-network-outline', 'printer-pos-off', 'printer-pos-off-outline', 'printer-pos-outline', 'printer-pos-pause', 'printer-pos-pause-outline', 'printer-pos-play', 'printer-pos-play-outline', 'printer-pos-plus', 'printer-pos-plus-outline', 'printer-pos-refresh', 'printer-pos-refresh-outline', 'printer-pos-remove', 'printer-pos-remove-outline', 'printer-pos-star', 'printer-pos-star-outline', 'printer-pos-stop', 'printer-pos-stop-outline', 'printer-pos-sync', 'printer-pos-sync-outline', 'printer-pos-wrench', 'printer-pos-wrench-outline', 'printer-search', 'printer-settings', 'printer-wireless', 'priority-high', 'priority-low', 'professional-hexagon', 'progress-alert', 'progress-check', 'progress-clock', 'progress-close', 'progress-download', 'progress-helper', 'progress-pencil', 'progress-question', 'progress-star', 'progress-upload', 'progress-wrench', 'projector', 'projector-off', 'projector-screen', 'projector-screen-off', 'projector-screen-off-outline', 'projector-screen-outline', 'projector-screen-variant', 'projector-screen-variant-off', 'projector-screen-variant-off-outline', 'projector-screen-variant-outline', 'propane-tank', 'propane-tank-outline', 'protocol', 'publish', 'publish-off', 'pulse', 'pump', 'pump-off', 'pumpkin', 'purse', 'purse-outline', 'puzzle', 'puzzle-check', 'puzzle-check-outline', 'puzzle-edit', 'puzzle-edit-outline', 'puzzle-heart', 'puzzle-heart-outline', 'puzzle-minus', 'puzzle-minus-outline', 'puzzle-outline', 'puzzle-plus', 'puzzle-plus-outline', 'puzzle-remove', 'puzzle-remove-outline', 'puzzle-star', 'puzzle-star-outline', 'pyramid', 'pyramid-off', 'qi', 'qqchat', 'qrcode', 'qrcode-edit', 'qrcode-minus', 'qrcode-plus', 'qrcode-remove', 'qrcode-scan', 'quadcopter', 'quality-high', 'quality-low', 'quality-medium', 'quora', 'rabbit', 'rabbit-variant', 'rabbit-variant-outline', 'racing-helmet', 'racquetball', 'radar', 'radiator', 'radiator-disabled', 'radiator-off', 'radio', 'radio-am', 'radio-fm', 'radio-handheld', 'radio-off', 'radio-tower', 'radioactive', 'radioactive-circle', 'radioactive-circle-outline', 'radioactive-off', 'radiobox-blank', 'radiobox-marked', 'radiology-box', 'radiology-box-outline', 'radius', 'radius-outline', 'railroad-light', 'rake', 'raspberry-pi', 'raw', 'raw-off', 'ray-end', 'ray-end-arrow', 'ray-start', 'ray-start-arrow', 'ray-start-end', 'ray-start-vertex-end', 'ray-vertex', 'razor-double-edge', 'razor-single-edge', 'react', 'read', 'receipt', 'receipt-outline', 'receipt-text', 'receipt-text-check', 'receipt-text-check-outline', 'receipt-text-minus', 'receipt-text-minus-outline', 'receipt-text-outline', 'receipt-text-plus', 'receipt-text-plus-outline', 'receipt-text-remove', 'receipt-text-remove-outline', 'record', 'record-circle', 'record-circle-outline', 'record-player', 'record-rec', 'rectangle', 'rectangle-outline', 'recycle', 'recycle-variant', 'reddit', 'redhat', 'redo', 'redo-variant', 'reflect-horizontal', 'reflect-vertical', 'refresh', 'refresh-auto', 'refresh-circle', 'regex', 'registered-trademark', 'reiterate', 'relation-many-to-many', 'relation-many-to-one', 'relation-many-to-one-or-many', 'relation-many-to-only-one', 'relation-many-to-zero-or-many', 'relation-many-to-zero-or-one', 'relation-one-or-many-to-many', 'relation-one-or-many-to-one', 'relation-one-or-many-to-one-or-many', 'relation-one-or-many-to-only-one', 'relation-one-or-many-to-zero-or-many', 'relation-one-or-many-to-zero-or-one', 'relation-one-to-many', 'relation-one-to-one', 'relation-one-to-one-or-many', 'relation-one-to-only-one', 'relation-one-to-zero-or-many', 'relation-one-to-zero-or-one', 'relation-only-one-to-many', 'relation-only-one-to-one', 'relation-only-one-to-one-or-many', 'relation-only-one-to-only-one', 'relation-only-one-to-zero-or-many', 'relation-only-one-to-zero-or-one', 'relation-zero-or-many-to-many', 'relation-zero-or-many-to-one', 'relation-zero-or-many-to-one-or-many', 'relation-zero-or-many-to-only-one', 'relation-zero-or-many-to-zero-or-many', 'relation-zero-or-many-to-zero-or-one', 'relation-zero-or-one-to-many', 'relation-zero-or-one-to-one', 'relation-zero-or-one-to-one-or-many', 'relation-zero-or-one-to-only-one', 'relation-zero-or-one-to-zero-or-many', 'relation-zero-or-one-to-zero-or-one', 'relative-scale', 'reload', 'reload-alert', 'reminder', 'remote', 'remote-desktop', 'remote-off', 'remote-tv', 'remote-tv-off', 'rename', 'rename-box', 'rename-box-outline', 'rename-outline', 'reorder-horizontal', 'reorder-vertical', 'repeat', 'repeat-off', 'repeat-once', 'repeat-variant', 'replay', 'reply', 'reply-all', 'reply-all-outline', 'reply-circle', 'reply-outline', 'reproduction', 'resistor', 'resistor-nodes', 'resize', 'resize-bottom-right', 'responsive', 'restart', 'restart-alert', 'restart-off', 'restore', 'restore-alert', 'rewind', 'rewind-10', 'rewind-15', 'rewind-30', 'rewind-45', 'rewind-5', 'rewind-60', 'rewind-outline', 'rhombus', 'rhombus-medium', 'rhombus-medium-outline', 'rhombus-outline', 'rhombus-split', 'rhombus-split-outline', 'ribbon', 'rice', 'rickshaw', 'rickshaw-electric', 'ring', 'rivet', 'road', 'road-variant', 'robber', 'robot', 'robot-angry', 'robot-angry-outline', 'robot-confused', 'robot-confused-outline', 'robot-dead', 'robot-dead-outline', 'robot-excited', 'robot-excited-outline', 'robot-happy', 'robot-happy-outline', 'robot-industrial', 'robot-industrial-outline', 'robot-love', 'robot-love-outline', 'robot-mower', 'robot-mower-outline', 'robot-off', 'robot-off-outline', 'robot-outline', 'robot-vacuum', 'robot-vacuum-alert', 'robot-vacuum-off', 'robot-vacuum-variant', 'robot-vacuum-variant-alert', 'robot-vacuum-variant-off', 'rocket', 'rocket-launch', 'rocket-launch-outline', 'rocket-outline', 'rodent', 'roller-shade', 'roller-shade-closed', 'roller-skate', 'roller-skate-off', 'rollerblade', 'rollerblade-off', 'rollupjs', 'rolodex', 'rolodex-outline', 'roman-numeral-1', 'roman-numeral-10', 'roman-numeral-2', 'roman-numeral-3', 'roman-numeral-4', 'roman-numeral-5', 'roman-numeral-6', 'roman-numeral-7', 'roman-numeral-8', 'roman-numeral-9', 'room-service', 'room-service-outline', 'rotate-360', 'rotate-3d', 'rotate-3d-variant', 'rotate-left', 'rotate-left-variant', 'rotate-orbit', 'rotate-right', 'rotate-right-variant', 'rounded-corner', 'router', 'router-network', 'router-wireless', 'router-wireless-off', 'router-wireless-settings', 'routes', 'routes-clock', 'rowing', 'rss', 'rss-box', 'rss-off', 'rug', 'rugby', 'ruler', 'ruler-square', 'ruler-square-compass', 'run', 'run-fast', 'rv-truck', 'sack', 'sack-percent', 'safe', 'safe-square', 'safe-square-outline', 'safety-goggles', 'sail-boat', 'sail-boat-sink', 'sale', 'sale-outline', 'salesforce', 'sass', 'satellite', 'satellite-uplink', 'satellite-variant', 'sausage', 'sausage-off', 'saw-blade', 'sawtooth-wave', 'saxophone', 'scale', 'scale-balance', 'scale-bathroom', 'scale-off', 'scale-unbalanced', 'scan-helper', 'scanner', 'scanner-off', 'scatter-plot', 'scatter-plot-outline', 'scent', 'scent-off', 'school', 'school-outline', 'scissors-cutting', 'scooter', 'scooter-electric', 'scoreboard', 'scoreboard-outline', 'screen-rotation', 'screen-rotation-lock', 'screw-flat-top', 'screw-lag', 'screw-machine-flat-top', 'screw-machine-round-top', 'screw-round-top', 'screwdriver', 'script', 'script-outline', 'script-text', 'script-text-key', 'script-text-key-outline', 'script-text-outline', 'script-text-play', 'script-text-play-outline', 'sd', 'seal', 'seal-variant', 'search-web', 'seat', 'seat-flat', 'seat-flat-angled', 'seat-individual-suite', 'seat-legroom-extra', 'seat-legroom-normal', 'seat-legroom-reduced', 'seat-outline', 'seat-passenger', 'seat-recline-extra', 'seat-recline-normal', 'seatbelt', 'security', 'security-network', 'seed', 'seed-off', 'seed-off-outline', 'seed-outline', 'seed-plus', 'seed-plus-outline', 'seesaw', 'segment', 'select', 'select-all', 'select-arrow-down', 'select-arrow-up', 'select-color', 'select-compare', 'select-drag', 'select-group', 'select-inverse', 'select-marker', 'select-multiple', 'select-multiple-marker', 'select-off', 'select-place', 'select-remove', 'select-search', 'selection', 'selection-drag', 'selection-ellipse', 'selection-ellipse-arrow-inside', 'selection-ellipse-remove', 'selection-marker', 'selection-multiple', 'selection-multiple-marker', 'selection-off', 'selection-remove', 'selection-search', 'semantic-web', 'send', 'send-check', 'send-check-outline', 'send-circle', 'send-circle-outline', 'send-clock', 'send-clock-outline', 'send-lock', 'send-lock-outline', 'send-outline', 'serial-port', 'server', 'server-minus', 'server-network', 'server-network-off', 'server-off', 'server-plus', 'server-remove', 'server-security', 'set-all', 'set-center', 'set-center-right', 'set-left', 'set-left-center', 'set-left-right', 'set-merge', 'set-none', 'set-right', 'set-split', 'set-square', 'set-top-box', 'settings-helper', 'shaker', 'shaker-outline', 'shape', 'shape-circle-plus', 'shape-outline', 'shape-oval-plus', 'shape-plus', 'shape-polygon-plus', 'shape-rectangle-plus', 'shape-square-plus', 'shape-square-rounded-plus', 'share', 'share-all', 'share-all-outline', 'share-circle', 'share-off', 'share-off-outline', 'share-outline', 'share-variant', 'share-variant-outline', 'shark', 'shark-fin', 'shark-fin-outline', 'shark-off', 'sheep', 'shield', 'shield-account', 'shield-account-outline', 'shield-account-variant', 'shield-account-variant-outline', 'shield-airplane', 'shield-airplane-outline', 'shield-alert', 'shield-alert-outline', 'shield-bug', 'shield-bug-outline', 'shield-car', 'shield-check', 'shield-check-outline', 'shield-cross', 'shield-cross-outline', 'shield-crown', 'shield-crown-outline', 'shield-edit', 'shield-edit-outline', 'shield-half', 'shield-half-full', 'shield-home', 'shield-home-outline', 'shield-key', 'shield-key-outline', 'shield-link-variant', 'shield-link-variant-outline', 'shield-lock', 'shield-lock-open', 'shield-lock-open-outline', 'shield-lock-outline', 'shield-moon', 'shield-moon-outline', 'shield-off', 'shield-off-outline', 'shield-outline', 'shield-plus', 'shield-plus-outline', 'shield-refresh', 'shield-refresh-outline', 'shield-remove', 'shield-remove-outline', 'shield-search', 'shield-star', 'shield-star-outline', 'shield-sun', 'shield-sun-outline', 'shield-sword', 'shield-sword-outline', 'shield-sync', 'shield-sync-outline', 'shimmer', 'ship-wheel', 'shipping-pallet', 'shoe-ballet', 'shoe-cleat', 'shoe-formal', 'shoe-heel', 'shoe-print', 'shoe-sneaker', 'shopping', 'shopping-music', 'shopping-outline', 'shopping-search', 'shopping-search-outline', 'shore', 'shovel', 'shovel-off', 'shower', 'shower-head', 'shredder', 'shuffle', 'shuffle-disabled', 'shuffle-variant', 'shuriken', 'sickle', 'sigma', 'sigma-lower', 'sign-caution', 'sign-direction', 'sign-direction-minus', 'sign-direction-plus', 'sign-direction-remove', 'sign-language', 'sign-language-outline', 'sign-pole', 'sign-real-estate', 'sign-text', 'sign-yield', 'signal', 'signal-2g', 'signal-3g', 'signal-4g', 'signal-5g', 'signal-cellular-1', 'signal-cellular-2', 'signal-cellular-3', 'signal-cellular-outline', 'signal-distance-variant', 'signal-hspa', 'signal-hspa-plus', 'signal-off', 'signal-variant', 'signature', 'signature-freehand', 'signature-image', 'signature-text', 'silo', 'silo-outline', 'silverware', 'silverware-clean', 'silverware-fork', 'silverware-fork-knife', 'silverware-spoon', 'silverware-variant', 'sim', 'sim-alert', 'sim-alert-outline', 'sim-off', 'sim-off-outline', 'sim-outline', 'simple-icons', 'sina-weibo', 'sine-wave', 'sitemap', 'sitemap-outline', 'size-l', 'size-m', 'size-s', 'size-xl', 'size-xs', 'size-xxl', 'size-xxs', 'size-xxxl', 'skate', 'skate-off', 'skateboard', 'skateboarding', 'skew-less', 'skew-more', 'ski', 'ski-cross-country', 'ski-water', 'skip-backward', 'skip-backward-outline', 'skip-forward', 'skip-forward-outline', 'skip-next', 'skip-next-circle', 'skip-next-circle-outline', 'skip-next-outline', 'skip-previous', 'skip-previous-circle', 'skip-previous-circle-outline', 'skip-previous-outline', 'skull', 'skull-crossbones', 'skull-crossbones-outline', 'skull-outline', 'skull-scan', 'skull-scan-outline', 'skype', 'skype-business', 'slack', 'slash-forward', 'slash-forward-box', 'sledding', 'sleep', 'sleep-off', 'slide', 'slope-downhill', 'slope-uphill', 'slot-machine', 'slot-machine-outline', 'smart-card', 'smart-card-off', 'smart-card-off-outline', 'smart-card-outline', 'smart-card-reader', 'smart-card-reader-outline', 'smog', 'smoke', 'smoke-detector', 'smoke-detector-alert', 'smoke-detector-alert-outline', 'smoke-detector-off', 'smoke-detector-off-outline', 'smoke-detector-outline', 'smoke-detector-variant', 'smoke-detector-variant-alert', 'smoke-detector-variant-off', 'smoking', 'smoking-off', 'smoking-pipe', 'smoking-pipe-off', 'snail', 'snake', 'snapchat', 'snowboard', 'snowflake', 'snowflake-alert', 'snowflake-check', 'snowflake-melt', 'snowflake-off', 'snowflake-thermometer', 'snowflake-variant', 'snowman', 'snowmobile', 'snowshoeing', 'soccer', 'soccer-field', 'social-distance-2-meters', 'social-distance-6-feet', 'sofa', 'sofa-outline', 'sofa-single', 'sofa-single-outline', 'solar-panel', 'solar-panel-large', 'solar-power', 'solar-power-variant', 'solar-power-variant-outline', 'soldering-iron', 'solid', 'sony-playstation', 'sort', 'sort-alphabetical-ascending', 'sort-alphabetical-ascending-variant', 'sort-alphabetical-descending', 'sort-alphabetical-descending-variant', 'sort-alphabetical-variant', 'sort-ascending', 'sort-bool-ascending', 'sort-bool-ascending-variant', 'sort-bool-descending', 'sort-bool-descending-variant', 'sort-calendar-ascending', 'sort-calendar-descending', 'sort-clock-ascending', 'sort-clock-ascending-outline', 'sort-clock-descending', 'sort-clock-descending-outline', 'sort-descending', 'sort-numeric-ascending', 'sort-numeric-ascending-variant', 'sort-numeric-descending', 'sort-numeric-descending-variant', 'sort-numeric-variant', 'sort-reverse-variant', 'sort-variant', 'sort-variant-lock', 'sort-variant-lock-open', 'sort-variant-off', 'sort-variant-remove', 'soundbar', 'soundcloud', 'source-branch', 'source-branch-check', 'source-branch-minus', 'source-branch-plus', 'source-branch-refresh', 'source-branch-remove', 'source-branch-sync', 'source-commit', 'source-commit-end', 'source-commit-end-local', 'source-commit-local', 'source-commit-next-local', 'source-commit-start', 'source-commit-start-next-local', 'source-fork', 'source-merge', 'source-pull', 'source-repository', 'source-repository-multiple', 'soy-sauce', 'soy-sauce-off', 'spa', 'spa-outline', 'space-invaders', 'space-station', 'spade', 'speaker', 'speaker-bluetooth', 'speaker-message', 'speaker-multiple', 'speaker-off', 'speaker-pause', 'speaker-play', 'speaker-stop', 'speaker-wireless', 'spear', 'speedometer', 'speedometer-medium', 'speedometer-slow', 'spellcheck', 'sphere', 'sphere-off', 'spider', 'spider-thread', 'spider-web', 'spirit-level', 'spoon-sugar', 'spotify', 'spotlight', 'spotlight-beam', 'spray', 'spray-bottle', 'sprinkler', 'sprinkler-fire', 'sprinkler-variant', 'sprout', 'sprout-outline', 'square', 'square-circle', 'square-edit-outline', 'square-medium', 'square-medium-outline', 'square-off', 'square-off-outline', 'square-opacity', 'square-outline', 'square-root', 'square-root-box', 'square-rounded', 'square-rounded-badge', 'square-rounded-badge-outline', 'square-rounded-outline', 'square-small', 'square-wave', 'squeegee', 'ssh', 'stack-exchange', 'stack-overflow', 'stackpath', 'stadium', 'stadium-outline', 'stadium-variant', 'stairs', 'stairs-box', 'stairs-down', 'stairs-up', 'stamper', 'standard-definition', 'star', 'star-box', 'star-box-multiple', 'star-box-multiple-outline', 'star-box-outline', 'star-check', 'star-check-outline', 'star-circle', 'star-circle-outline', 'star-cog', 'star-cog-outline', 'star-crescent', 'star-david', 'star-face', 'star-four-points', 'star-four-points-outline', 'star-half', 'star-half-full', 'star-minus', 'star-minus-outline', 'star-off', 'star-off-outline', 'star-outline', 'star-plus', 'star-plus-outline', 'star-remove', 'star-remove-outline', 'star-settings', 'star-settings-outline', 'star-shooting', 'star-shooting-outline', 'star-three-points', 'star-three-points-outline', 'state-machine', 'steam', 'steering', 'steering-off', 'step-backward', 'step-backward-2', 'step-forward', 'step-forward-2', 'stethoscope', 'sticker', 'sticker-alert', 'sticker-alert-outline', 'sticker-check', 'sticker-check-outline', 'sticker-circle-outline', 'sticker-emoji', 'sticker-minus', 'sticker-minus-outline', 'sticker-outline', 'sticker-plus', 'sticker-plus-outline', 'sticker-remove', 'sticker-remove-outline', 'sticker-text', 'sticker-text-outline', 'stocking', 'stomach', 'stool', 'stool-outline', 'stop', 'stop-circle', 'stop-circle-outline', 'storage-tank', 'storage-tank-outline', 'store', 'store-24-hour', 'store-alert', 'store-alert-outline', 'store-check', 'store-check-outline', 'store-clock', 'store-clock-outline', 'store-cog', 'store-cog-outline', 'store-edit', 'store-edit-outline', 'store-marker', 'store-marker-outline', 'store-minus', 'store-minus-outline', 'store-off', 'store-off-outline', 'store-outline', 'store-plus', 'store-plus-outline', 'store-remove', 'store-remove-outline', 'store-search', 'store-search-outline', 'store-settings', 'store-settings-outline', 'storefront', 'storefront-check', 'storefront-check-outline', 'storefront-edit', 'storefront-edit-outline', 'storefront-minus', 'storefront-minus-outline', 'storefront-outline', 'storefront-plus', 'storefront-plus-outline', 'storefront-remove', 'storefront-remove-outline', 'stove', 'strategy', 'stretch-to-page', 'stretch-to-page-outline', 'string-lights', 'string-lights-off', 'subdirectory-arrow-left', 'subdirectory-arrow-right', 'submarine', 'subtitles', 'subtitles-outline', 'subway', 'subway-alert-variant', 'subway-variant', 'summit', 'sun-angle', 'sun-angle-outline', 'sun-clock', 'sun-clock-outline', 'sun-compass', 'sun-snowflake', 'sun-snowflake-variant', 'sun-thermometer', 'sun-thermometer-outline', 'sun-wireless', 'sun-wireless-outline', 'sunglasses', 'surfing', 'surround-sound', 'surround-sound-2-0', 'surround-sound-2-1', 'surround-sound-3-1', 'surround-sound-5-1', 'surround-sound-5-1-2', 'surround-sound-7-1', 'svg', 'swap-horizontal', 'swap-horizontal-bold', 'swap-horizontal-circle', 'swap-horizontal-circle-outline', 'swap-horizontal-variant', 'swap-vertical', 'swap-vertical-bold', 'swap-vertical-circle', 'swap-vertical-circle-outline', 'swap-vertical-variant', 'swim', 'switch', 'sword', 'sword-cross', 'syllabary-hangul', 'syllabary-hiragana', 'syllabary-katakana', 'syllabary-katakana-halfwidth', 'symbol', 'symfony', 'synagogue', 'synagogue-outline', 'sync', 'sync-alert', 'sync-circle', 'sync-off', 'tab', 'tab-minus', 'tab-plus', 'tab-remove', 'tab-search', 'tab-unselected', 'table', 'table-account', 'table-alert', 'table-arrow-down', 'table-arrow-left', 'table-arrow-right', 'table-arrow-up', 'table-border', 'table-cancel', 'table-chair', 'table-check', 'table-clock', 'table-cog', 'table-column', 'table-column-plus-after', 'table-column-plus-before', 'table-column-remove', 'table-column-width', 'table-edit', 'table-eye', 'table-eye-off', 'table-filter', 'table-furniture', 'table-headers-eye', 'table-headers-eye-off', 'table-heart', 'table-key', 'table-large', 'table-large-plus', 'table-large-remove', 'table-lock', 'table-merge-cells', 'table-minus', 'table-multiple', 'table-network', 'table-of-contents', 'table-off', 'table-picnic', 'table-pivot', 'table-plus', 'table-question', 'table-refresh', 'table-remove', 'table-row', 'table-row-height', 'table-row-plus-after', 'table-row-plus-before', 'table-row-remove', 'table-search', 'table-settings', 'table-split-cell', 'table-star', 'table-sync', 'table-tennis', 'tablet', 'tablet-cellphone', 'tablet-dashboard', 'taco', 'tag', 'tag-arrow-down', 'tag-arrow-down-outline', 'tag-arrow-left', 'tag-arrow-left-outline', 'tag-arrow-right', 'tag-arrow-right-outline', 'tag-arrow-up', 'tag-arrow-up-outline', 'tag-check', 'tag-check-outline', 'tag-faces', 'tag-heart', 'tag-heart-outline', 'tag-minus', 'tag-minus-outline', 'tag-multiple', 'tag-multiple-outline', 'tag-off', 'tag-off-outline', 'tag-outline', 'tag-plus', 'tag-plus-outline', 'tag-remove', 'tag-remove-outline', 'tag-search', 'tag-search-outline', 'tag-text', 'tag-text-outline', 'tailwind', 'tally-mark-1', 'tally-mark-2', 'tally-mark-3', 'tally-mark-4', 'tally-mark-5', 'tangram', 'tank', 'tanker-truck', 'tape-drive', 'tape-measure', 'target', 'target-account', 'target-variant', 'taxi', 'tea', 'tea-outline', 'teamviewer', 'teddy-bear', 'telescope', 'television', 'television-ambient-light', 'television-box', 'television-classic', 'television-classic-off', 'television-guide', 'television-off', 'television-pause', 'television-play', 'television-shimmer', 'television-speaker', 'television-speaker-off', 'television-stop', 'temperature-celsius', 'temperature-fahrenheit', 'temperature-kelvin', 'temple-buddhist', 'temple-buddhist-outline', 'temple-hindu', 'temple-hindu-outline', 'tennis', 'tennis-ball', 'tent', 'terraform', 'terrain', 'test-tube', 'test-tube-empty', 'test-tube-off', 'text', 'text-account', 'text-box', 'text-box-check', 'text-box-check-outline', 'text-box-edit', 'text-box-edit-outline', 'text-box-minus', 'text-box-minus-outline', 'text-box-multiple', 'text-box-multiple-outline', 'text-box-outline', 'text-box-plus', 'text-box-plus-outline', 'text-box-remove', 'text-box-remove-outline', 'text-box-search', 'text-box-search-outline', 'text-long', 'text-recognition', 'text-search', 'text-search-variant', 'text-shadow', 'text-short', 'texture', 'texture-box', 'theater', 'theme-light-dark', 'thermometer', 'thermometer-alert', 'thermometer-auto', 'thermometer-bluetooth', 'thermometer-check', 'thermometer-chevron-down', 'thermometer-chevron-up', 'thermometer-high', 'thermometer-lines', 'thermometer-low', 'thermometer-minus', 'thermometer-off', 'thermometer-plus', 'thermometer-probe', 'thermometer-probe-off', 'thermometer-water', 'thermostat', 'thermostat-auto', 'thermostat-box', 'thermostat-box-auto', 'thought-bubble', 'thought-bubble-outline', 'thumb-down', 'thumb-down-outline', 'thumb-up', 'thumb-up-outline', 'thumbs-up-down', 'thumbs-up-down-outline', 'ticket', 'ticket-account', 'ticket-confirmation', 'ticket-confirmation-outline', 'ticket-outline', 'ticket-percent', 'ticket-percent-outline', 'tie', 'tilde', 'tilde-off', 'timelapse', 'timeline', 'timeline-alert', 'timeline-alert-outline', 'timeline-check', 'timeline-check-outline', 'timeline-clock', 'timeline-clock-outline', 'timeline-minus', 'timeline-minus-outline', 'timeline-outline', 'timeline-plus', 'timeline-plus-outline', 'timeline-question', 'timeline-question-outline', 'timeline-remove', 'timeline-remove-outline', 'timeline-text', 'timeline-text-outline', 'timer', 'timer-10', 'timer-3', 'timer-alert', 'timer-alert-outline', 'timer-cancel', 'timer-cancel-outline', 'timer-check', 'timer-check-outline', 'timer-cog', 'timer-cog-outline', 'timer-edit', 'timer-edit-outline', 'timer-lock', 'timer-lock-open', 'timer-lock-open-outline', 'timer-lock-outline', 'timer-marker', 'timer-marker-outline', 'timer-minus', 'timer-minus-outline', 'timer-music', 'timer-music-outline', 'timer-off', 'timer-off-outline', 'timer-outline', 'timer-pause', 'timer-pause-outline', 'timer-play', 'timer-play-outline', 'timer-plus', 'timer-plus-outline', 'timer-refresh', 'timer-refresh-outline', 'timer-remove', 'timer-remove-outline', 'timer-sand', 'timer-sand-complete', 'timer-sand-empty', 'timer-sand-full', 'timer-sand-paused', 'timer-settings', 'timer-settings-outline', 'timer-star', 'timer-star-outline', 'timer-stop', 'timer-stop-outline', 'timer-sync', 'timer-sync-outline', 'timetable', 'tire', 'toaster', 'toaster-off', 'toaster-oven', 'toggle-switch', 'toggle-switch-off', 'toggle-switch-off-outline', 'toggle-switch-outline', 'toggle-switch-variant', 'toggle-switch-variant-off', 'toilet', 'toolbox', 'toolbox-outline', 'tools', 'tooltip', 'tooltip-account', 'tooltip-cellphone', 'tooltip-check', 'tooltip-check-outline', 'tooltip-edit', 'tooltip-edit-outline', 'tooltip-image', 'tooltip-image-outline', 'tooltip-minus', 'tooltip-minus-outline', 'tooltip-outline', 'tooltip-plus', 'tooltip-plus-outline', 'tooltip-question', 'tooltip-question-outline', 'tooltip-remove', 'tooltip-remove-outline', 'tooltip-text', 'tooltip-text-outline', 'tooth', 'tooth-outline', 'toothbrush', 'toothbrush-electric', 'toothbrush-paste', 'torch', 'tortoise', 'toslink', 'tournament', 'tow-truck', 'tower-beach', 'tower-fire', 'town-hall', 'toy-brick', 'toy-brick-marker', 'toy-brick-marker-outline', 'toy-brick-minus', 'toy-brick-minus-outline', 'toy-brick-outline', 'toy-brick-plus', 'toy-brick-plus-outline', 'toy-brick-remove', 'toy-brick-remove-outline', 'toy-brick-search', 'toy-brick-search-outline', 'track-light', 'track-light-off', 'trackpad', 'trackpad-lock', 'tractor', 'tractor-variant', 'trademark', 'traffic-cone', 'traffic-light', 'traffic-light-outline', 'train', 'train-car', 'train-car-autorack', 'train-car-box', 'train-car-box-full', 'train-car-box-open', 'train-car-caboose', 'train-car-centerbeam', 'train-car-centerbeam-full', 'train-car-container', 'train-car-flatbed', 'train-car-flatbed-car', 'train-car-flatbed-tank', 'train-car-gondola', 'train-car-gondola-full', 'train-car-hopper', 'train-car-hopper-covered', 'train-car-hopper-full', 'train-car-intermodal', 'train-car-passenger', 'train-car-passenger-door', 'train-car-passenger-door-open', 'train-car-passenger-variant', 'train-car-tank', 'train-variant', 'tram', 'tram-side', 'transcribe', 'transcribe-close', 'transfer', 'transfer-down', 'transfer-left', 'transfer-right', 'transfer-up', 'transit-connection', 'transit-connection-horizontal', 'transit-connection-variant', 'transit-detour', 'transit-skip', 'transit-transfer', 'transition', 'transition-masked', 'translate', 'translate-off', 'translate-variant', 'transmission-tower', 'transmission-tower-export', 'transmission-tower-import', 'transmission-tower-off', 'trash-can', 'trash-can-outline', 'tray', 'tray-alert', 'tray-arrow-down', 'tray-arrow-up', 'tray-full', 'tray-minus', 'tray-plus', 'tray-remove', 'treasure-chest', 'tree', 'tree-outline', 'trello', 'trending-down', 'trending-neutral', 'trending-up', 'triangle', 'triangle-outline', 'triangle-small-down', 'triangle-small-up', 'triangle-wave', 'triforce', 'trophy', 'trophy-award', 'trophy-broken', 'trophy-outline', 'trophy-variant', 'trophy-variant-outline', 'truck', 'truck-alert', 'truck-alert-outline', 'truck-cargo-container', 'truck-check', 'truck-check-outline', 'truck-delivery', 'truck-delivery-outline', 'truck-fast', 'truck-fast-outline', 'truck-flatbed', 'truck-minus', 'truck-minus-outline', 'truck-outline', 'truck-plus', 'truck-plus-outline', 'truck-remove', 'truck-remove-outline', 'truck-snowflake', 'truck-trailer', 'trumpet', 'tshirt-crew', 'tshirt-crew-outline', 'tshirt-v', 'tshirt-v-outline', 'tsunami', 'tumble-dryer', 'tumble-dryer-alert', 'tumble-dryer-off', 'tune', 'tune-variant', 'tune-vertical', 'tune-vertical-variant', 'tunnel', 'tunnel-outline', 'turbine', 'turkey', 'turnstile', 'turnstile-outline', 'turtle', 'twitch', 'twitter', 'two-factor-authentication', 'typewriter', 'ubisoft', 'ubuntu', 'ufo', 'ufo-outline', 'ultra-high-definition', 'umbraco', 'umbrella', 'umbrella-beach', 'umbrella-beach-outline', 'umbrella-closed', 'umbrella-closed-outline', 'umbrella-closed-variant', 'umbrella-outline', 'undo', 'undo-variant', 'unfold-less-horizontal', 'unfold-less-vertical', 'unfold-more-horizontal', 'unfold-more-vertical', 'ungroup', 'unicode', 'unicorn', 'unicorn-variant', 'unicycle', 'unity', 'unreal', 'update', 'upload', 'upload-lock', 'upload-lock-outline', 'upload-multiple', 'upload-network', 'upload-network-outline', 'upload-off', 'upload-off-outline', 'upload-outline', 'usb', 'usb-flash-drive', 'usb-flash-drive-outline', 'usb-port', 'vacuum', 'vacuum-outline', 'valve', 'valve-closed', 'valve-open', 'van-passenger', 'van-utility', 'vanish', 'vanish-quarter', 'vanity-light', 'variable', 'variable-box', 'vector-arrange-above', 'vector-arrange-below', 'vector-bezier', 'vector-circle', 'vector-circle-variant', 'vector-combine', 'vector-curve', 'vector-difference', 'vector-difference-ab', 'vector-difference-ba', 'vector-ellipse', 'vector-intersection', 'vector-line', 'vector-link', 'vector-point', 'vector-point-edit', 'vector-point-minus', 'vector-point-plus', 'vector-point-select', 'vector-polygon', 'vector-polygon-variant', 'vector-polyline', 'vector-polyline-edit', 'vector-polyline-minus', 'vector-polyline-plus', 'vector-polyline-remove', 'vector-radius', 'vector-rectangle', 'vector-selection', 'vector-square', 'vector-square-close', 'vector-square-edit', 'vector-square-minus', 'vector-square-open', 'vector-square-plus', 'vector-square-remove', 'vector-triangle', 'vector-union', 'vhs', 'vibrate', 'vibrate-off', 'video', 'video-2d', 'video-3d', 'video-3d-off', 'video-3d-variant', 'video-4k-box', 'video-account', 'video-box', 'video-box-off', 'video-check', 'video-check-outline', 'video-high-definition', 'video-image', 'video-input-antenna', 'video-input-component', 'video-input-hdmi', 'video-input-scart', 'video-input-svideo', 'video-marker', 'video-marker-outline', 'video-minus', 'video-minus-outline', 'video-off', 'video-off-outline', 'video-outline', 'video-plus', 'video-plus-outline', 'video-stabilization', 'video-switch', 'video-switch-outline', 'video-vintage', 'video-wireless', 'video-wireless-outline', 'view-agenda', 'view-agenda-outline', 'view-array', 'view-array-outline', 'view-carousel', 'view-carousel-outline', 'view-column', 'view-column-outline', 'view-comfy', 'view-comfy-outline', 'view-compact', 'view-compact-outline', 'view-dashboard', 'view-dashboard-edit', 'view-dashboard-edit-outline', 'view-dashboard-outline', 'view-dashboard-variant', 'view-dashboard-variant-outline', 'view-day', 'view-day-outline', 'view-gallery', 'view-gallery-outline', 'view-grid', 'view-grid-outline', 'view-grid-plus', 'view-grid-plus-outline', 'view-headline', 'view-list', 'view-list-outline', 'view-module', 'view-module-outline', 'view-parallel', 'view-parallel-outline', 'view-quilt', 'view-quilt-outline', 'view-sequential', 'view-sequential-outline', 'view-split-horizontal', 'view-split-vertical', 'view-stream', 'view-stream-outline', 'view-week', 'view-week-outline', 'vimeo', 'violin', 'virtual-reality', 'virus', 'virus-off', 'virus-off-outline', 'virus-outline', 'vlc', 'voicemail', 'volcano', 'volcano-outline', 'volleyball', 'volume-equal', 'volume-high', 'volume-low', 'volume-medium', 'volume-minus', 'volume-mute', 'volume-off', 'volume-plus', 'volume-source', 'volume-variant-off', 'volume-vibrate', 'vote', 'vote-outline', 'vpn', 'vuejs', 'vuetify', 'walk', 'wall', 'wall-fire', 'wall-sconce', 'wall-sconce-flat', 'wall-sconce-flat-outline', 'wall-sconce-flat-variant', 'wall-sconce-flat-variant-outline', 'wall-sconce-outline', 'wall-sconce-round', 'wall-sconce-round-outline', 'wall-sconce-round-variant', 'wall-sconce-round-variant-outline', 'wallet', 'wallet-giftcard', 'wallet-membership', 'wallet-outline', 'wallet-plus', 'wallet-plus-outline', 'wallet-travel', 'wallpaper', 'wan', 'wardrobe', 'wardrobe-outline', 'warehouse', 'washing-machine', 'washing-machine-alert', 'washing-machine-off', 'watch', 'watch-export', 'watch-export-variant', 'watch-import', 'watch-import-variant', 'watch-variant', 'watch-vibrate', 'watch-vibrate-off', 'water', 'water-alert', 'water-alert-outline', 'water-boiler', 'water-boiler-alert', 'water-boiler-auto', 'water-boiler-off', 'water-check', 'water-check-outline', 'water-circle', 'water-minus', 'water-minus-outline', 'water-off', 'water-off-outline', 'water-opacity', 'water-outline', 'water-percent', 'water-percent-alert', 'water-plus', 'water-plus-outline', 'water-polo', 'water-pump', 'water-pump-off', 'water-remove', 'water-remove-outline', 'water-sync', 'water-thermometer', 'water-thermometer-outline', 'water-well', 'water-well-outline', 'waterfall', 'watering-can', 'watering-can-outline', 'watermark', 'wave', 'waveform', 'waves', 'waves-arrow-left', 'waves-arrow-right', 'waves-arrow-up', 'waze', 'weather-cloudy', 'weather-cloudy-alert', 'weather-cloudy-arrow-right', 'weather-cloudy-clock', 'weather-dust', 'weather-fog', 'weather-hail', 'weather-hazy', 'weather-hurricane', 'weather-lightning', 'weather-lightning-rainy', 'weather-night', 'weather-night-partly-cloudy', 'weather-partly-cloudy', 'weather-partly-lightning', 'weather-partly-rainy', 'weather-partly-snowy', 'weather-partly-snowy-rainy', 'weather-pouring', 'weather-rainy', 'weather-snowy', 'weather-snowy-heavy', 'weather-snowy-rainy', 'weather-sunny', 'weather-sunny-alert', 'weather-sunny-off', 'weather-sunset', 'weather-sunset-down', 'weather-sunset-up', 'weather-tornado', 'weather-windy', 'weather-windy-variant', 'web', 'web-box', 'web-cancel', 'web-check', 'web-clock', 'web-minus', 'web-off', 'web-plus', 'web-refresh', 'web-remove', 'web-sync', 'webcam', 'webcam-off', 'webhook', 'webpack', 'webrtc', 'wechat', 'weight', 'weight-gram', 'weight-kilogram', 'weight-lifter', 'weight-pound', 'whatsapp', 'wheel-barrow', 'wheelchair', 'wheelchair-accessibility', 'whistle', 'whistle-outline', 'white-balance-auto', 'white-balance-incandescent', 'white-balance-iridescent', 'white-balance-sunny', 'widgets', 'widgets-outline', 'wifi', 'wifi-alert', 'wifi-arrow-down', 'wifi-arrow-left', 'wifi-arrow-left-right', 'wifi-arrow-right', 'wifi-arrow-up', 'wifi-arrow-up-down', 'wifi-cancel', 'wifi-check', 'wifi-cog', 'wifi-lock', 'wifi-lock-open', 'wifi-marker', 'wifi-minus', 'wifi-off', 'wifi-plus', 'wifi-refresh', 'wifi-remove', 'wifi-settings', 'wifi-star', 'wifi-strength-1', 'wifi-strength-1-alert', 'wifi-strength-1-lock', 'wifi-strength-1-lock-open', 'wifi-strength-2', 'wifi-strength-2-alert', 'wifi-strength-2-lock', 'wifi-strength-2-lock-open', 'wifi-strength-3', 'wifi-strength-3-alert', 'wifi-strength-3-lock', 'wifi-strength-3-lock-open', 'wifi-strength-4', 'wifi-strength-4-alert', 'wifi-strength-4-lock', 'wifi-strength-4-lock-open', 'wifi-strength-alert-outline', 'wifi-strength-lock-open-outline', 'wifi-strength-lock-outline', 'wifi-strength-off', 'wifi-strength-off-outline', 'wifi-strength-outline', 'wifi-sync', 'wikipedia', 'wind-power', 'wind-power-outline', 'wind-turbine', 'wind-turbine-alert', 'wind-turbine-check', 'window-close', 'window-closed', 'window-closed-variant', 'window-maximize', 'window-minimize', 'window-open', 'window-open-variant', 'window-restore', 'window-shutter', 'window-shutter-alert', 'window-shutter-auto', 'window-shutter-cog', 'window-shutter-open', 'window-shutter-settings', 'windsock', 'wiper', 'wiper-wash', 'wiper-wash-alert', 'wizard-hat', 'wordpress', 'wrap', 'wrap-disabled', 'wrench', 'wrench-check', 'wrench-check-outline', 'wrench-clock', 'wrench-clock-outline', 'wrench-cog', 'wrench-cog-outline', 'wrench-outline', 'xamarin', 'xml', 'xmpp', 'yahoo', 'yeast', 'yin-yang', 'yoga', 'youtube', 'youtube-gaming', 'youtube-studio', 'youtube-subscription', 'youtube-tv', 'yurt', 'z-wave', 'zend', 'zigbee', 'zip-box', 'zip-box-outline', 'zip-disk', 'zodiac-aquarius', 'zodiac-aries', 'zodiac-cancer', 'zodiac-capricorn', 'zodiac-gemini', 'zodiac-leo', 'zodiac-libra', 'zodiac-pisces', 'zodiac-sagittarius', 'zodiac-scorpio', 'zodiac-taurus', 'zodiac-virgo');
    }

}

if (!function_exists('eead_icofont_icon_array')) {

    function eead_icofont_icon_array() {
        return array('addons', 'address-book', 'adjust', 'alarm', 'anchor', 'archive', 'at', 'attachment', 'audio', 'automation', 'badge', 'bag-alt', 'bag', 'ban', 'bar-code', 'bars', 'basket', 'battery-empty', 'battery-full', 'battery-half', 'battery-low', 'beaker', 'beard', 'bed', 'bell', 'beverage', 'bill', 'bin', 'binary', 'binoculars', 'bluetooth', 'bomb', 'book-mark', 'box', 'briefcase', 'broken', 'bucket', 'bucket1', 'bucket2', 'bug', 'building', 'bulb-alt', 'bullet', 'bullhorn', 'bullseye', 'calendar', 'camera-alt', 'camera', 'card', 'cart-alt', 'cart', 'cc', 'charging', 'chat', 'check-alt', 'check-circled', 'check', 'checked', 'children-care', 'clip', 'clock-time', 'close-circled', 'close-line-circled', 'close-line-squared-alt', 'close-line-squared', 'close-line', 'close-squared-alt', 'close-squared', 'close', 'cloud-download', 'cloud-refresh', 'cloud-upload', 'cloud', 'code-not-allowed', 'code', 'comment', 'compass-alt', 'compass', 'computer', 'connection', 'console', 'contacts', 'contrast', 'copyright', 'credit-card', 'crop', 'crown', 'cube', 'cubes', 'dashboard-web', 'dashboard', 'data', 'database-add', 'database-locked', 'database-remove', 'database', 'delete', 'diamond', 'dice-multiple', 'dice', 'disc', 'diskette', 'document-folder', 'download-alt', 'download', 'downloaded', 'drag', 'drag1', 'drag2', 'drag3', 'earth', 'ebook', 'edit', 'eject', 'email', 'envelope-open', 'envelope', 'eraser', 'error', 'excavator', 'exchange', 'exclamation-circle', 'exclamation-square', 'exclamation-tringle', 'exclamation', 'exit', 'expand', 'external-link', 'external', 'eye-alt', 'eye-blocked', 'eye-dropper', 'eye', 'favourite', 'fax', 'file-fill', 'film', 'filter', 'fire-alt', 'fire-burn', 'fire', 'flag-alt-1', 'flag-alt-2', 'flag', 'flame-torch', 'flash-light', 'flash', 'flask', 'focus', 'folder-open', 'folder', 'foot-print', 'garbage', 'gear-alt', 'gear', 'gears', 'gift', 'glass', 'globe', 'graffiti', 'grocery', 'hand', 'hanger', 'hard-disk', 'heart-alt', 'heart', 'history', 'home', 'horn', 'hour-glass', 'id', 'image', 'inbox', 'infinite', 'info-circle', 'info-square', 'info', 'institution', 'interface', 'invisible', 'jacket', 'jar', 'jewlery', 'karate', 'key-hole', 'key', 'label', 'lamp', 'layers', 'layout', 'leaf', 'leaflet', 'learn', 'lego', 'lens', 'letter', 'letterbox', 'library', 'license', 'life-bouy', 'life-buoy', 'life-jacket', 'life-ring', 'light-bulb', 'lighter', 'lightning-ray', 'like', 'line-height', 'link-alt', 'link', 'list', 'listening', 'listine-dots', 'listing-box', 'listing-number', 'live-support', 'location-arrow', 'location-pin', 'lock', 'login', 'logout', 'lollipop', 'long-drive', 'look', 'loop', 'luggage', 'lunch', 'lungs', 'magic-alt', 'magic', 'magnet', 'mail-box', 'mail', 'male', 'map-pins', 'map', 'maximize', 'measure', 'medicine', 'mega-phone', 'megaphone-alt', 'megaphone', 'memorial', 'memory-card', 'mic-mute', 'mic', 'military', 'mill', 'minus-circle', 'minus-square', 'minus', 'mobile-phone', 'molecule', 'money', 'moon', 'mop', 'muffin', 'mustache', 'navigation-menu', 'navigation', 'network-tower', 'network', 'news', 'newspaper', 'no-smoking', 'not-allowed', 'notebook', 'notepad', 'notification', 'numbered', 'opposite', 'optic', 'options', 'package', 'page', 'paint', 'paper-plane', 'paperclip', 'papers', 'pay', 'penguin-linux', 'pestle', 'phone-circle', 'phone', 'picture', 'pine', 'pixels', 'plugin', 'plus-circle', 'plus-square', 'plus', 'polygonal', 'power', 'price', 'print', 'puzzle', 'qr-code', 'queen', 'question-circle', 'question-square', 'question', 'quote-left', 'quote-right', 'random', 'recycle', 'refresh', 'repair', 'reply-all', 'reply', 'resize', 'responsive', 'retweet', 'road', 'robot', 'royal', 'rss-feed', 'safety', 'sale-discount', 'sass', 'satellite', 'send-mail', 'server', 'settings-alt', 'settings', 'share-alt', 'share-boxed', 'share', 'shield', 'shopping-cart', 'sign-in', 'sign-out', 'signal', 'site-map', 'smart-phone', 'soccer', 'sort-alt', 'sort', 'space', 'spanner', 'speech-comments', 'speed-meter', 'spinner-alt-1', 'spinner-alt-2', 'spinner-alt-3', 'spinner-alt-4', 'spinner-alt-5', 'spinner-alt-6', 'spinner', 'spreadsheet', 'square', 'ssl-security', 'star-alt-1', 'star-alt-2', 'star', 'street-view', 'support-faq', 'tack-pin', 'tag', 'tags', 'tasks-alt', 'tasks', 'telephone', 'telescope', 'terminal', 'thumbs-down', 'thumbs-up', 'tick-boxed', 'tick-mark', 'ticket', 'tie', 'toggle-off', 'toggle-on', 'tools-alt-2', 'tools', 'touch', 'traffic-light', 'transparent', 'tree', 'unique-idea', 'unlock', 'unlocked', 'upload-alt', 'upload', 'usb-drive', 'usb', 'vector-path', 'verification-check', 'visual-studio', 'vscode', 'vuejs', 'wall-clock', 'wall', 'wallet', 'warning-alt', 'warning', 'water-drop', 'web', 'wheelchair', 'wifi-alt', 'wifi', 'world', 'zigzag', 'zipped', 'apple', 'arabian-coffee', 'artichoke', 'asparagus', 'avocado', 'baby-food', 'banana', 'bbq', 'beans', 'beer', 'bell-pepper-capsicum', 'birthday-cake', 'bread', 'broccoli', 'burger', 'cabbage', 'carrot', 'cauli-flower', 'cheese', 'chef', 'cherry', 'chicken-fry', 'chicken', 'cocktail', 'coconut-water', 'coconut', 'coffee-alt', 'coffee-cup', 'coffee-mug', 'coffee-pot', 'cola', 'corn', 'croissant', 'crop-plant', 'cucumber', 'culinary', 'cup-cake', 'dining-table', 'donut', 'egg-plant', 'egg-poached', 'farmer-alt', 'farmer', 'fast-food', 'food-basket', 'food-cart', 'fork-and-knife', 'french-fries', 'fruits', 'grapes', 'honey', 'hot-dog', 'ice-cream-alt', 'ice-cream', 'juice', 'ketchup', 'kiwi', 'layered-cake', 'lemon-alt', 'lemon', 'lobster', 'mango', 'milk', 'mushroom', 'noodles', 'onion', 'orange', 'pear', 'peas', 'pepper', 'pie-alt', 'pie', 'pineapple', 'pizza-slice', 'pizza', 'plant', 'popcorn', 'potato', 'pumpkin', 'raddish', 'restaurant-menu', 'restaurant', 'salt-and-pepper', 'sandwich', 'sausage', 'soft-drinks', 'soup-bowl', 'spoon-and-fork', 'steak', 'strawberry', 'sub-sandwich', 'sushi', 'taco', 'tea-pot', 'tea', 'tomato', 'watermelon', 'wheat', 'baby-backpack', 'baby-cloth', 'baby-milk-bottle', 'baby-trolley', 'baby', 'candy', 'holding-hands', 'infant-nipple', 'kids-scooter', 'safety-pin', 'teddy-bear', 'toy-ball', 'toy-cat', 'toy-duck', 'toy-elephant', 'toy-hand', 'toy-horse', 'toy-lattu', 'toy-train', 'abacus-alt', 'abacus', 'angle-180', 'angle-45', 'angle-90', 'angle', 'calculator-alt-1', 'calculator-alt-2', 'calculator', 'circle-ruler-alt', 'circle-ruler', 'compass-alt-1', 'compass-alt-2', 'compass-alt-3', 'compass-alt-4', 'golden-ratio', 'marker-alt-1', 'marker-alt-2', 'marker-alt-3', 'marker', 'math', 'mathematical-alt-1', 'mathematical-alt-2', 'mathematical', 'pen-alt-1', 'pen-alt-2', 'pen-alt-3', 'pen-holder-alt-1', 'pen-holder', 'pen', 'pencil-alt-1', 'pencil-alt-2', 'pencil-alt-3', 'pencil-alt-4', 'pencil', 'ruler-alt-1', 'ruler-alt-2', 'ruler-compass-alt', 'ruler-compass', 'ruler-pencil-alt-1', 'ruler-pencil-alt-2', 'ruler-pencil', 'ruler', 'rulers-alt', 'rulers', 'square-root', 'ui-calculator', 'aids', 'ambulance-crescent', 'ambulance-cross', 'ambulance', 'autism', 'bandage', 'blind', 'blood-drop', 'blood-test', 'blood', 'brain-alt', 'brain', 'capsule', 'crutch', 'disabled', 'dna-alt-1', 'dna-alt-2', 'dna', 'doctor-alt', 'doctor', 'drug-pack', 'drug', 'first-aid-alt', 'first-aid', 'heart-beat-alt', 'heart-beat', 'heartbeat', 'herbal', 'hospital', 'icu', 'injection-syringe', 'laboratory', 'medical-sign-alt', 'medical-sign', 'nurse-alt', 'nurse', 'nursing-home', 'operation-theater', 'paralysis-disability', 'patient-bed', 'patient-file', 'pills', 'prescription', 'pulse', 'stethoscope-alt', 'stethoscope', 'stretcher', 'surgeon-alt', 'surgeon', 'tablets', 'test-bottle', 'test-tube', 'thermometer-alt', 'thermometer', 'tooth', 'xray', 'ui-add', 'ui-alarm', 'ui-battery', 'ui-block', 'ui-bluetooth', 'ui-brightness', 'ui-browser', 'ui-calendar', 'ui-call', 'ui-camera', 'ui-cart', 'ui-cell-phone', 'ui-chat', 'ui-check', 'ui-clip-board', 'ui-clip', 'ui-clock', 'ui-close', 'ui-contact-list', 'ui-copy', 'ui-cut', 'ui-delete', 'ui-dial-phone', 'ui-edit', 'ui-email', 'ui-file', 'ui-fire-wall', 'ui-flash-light', 'ui-flight', 'ui-folder', 'ui-game', 'ui-handicapped', 'ui-home', 'ui-image', 'ui-laoding', 'ui-lock', 'ui-love-add', 'ui-love-broken', 'ui-love-remove', 'ui-love', 'ui-map', 'ui-message', 'ui-messaging', 'ui-movie', 'ui-music-player', 'ui-music', 'ui-mute', 'ui-network', 'ui-next', 'ui-note', 'ui-office', 'ui-password', 'ui-pause', 'ui-play-stop', 'ui-play', 'ui-pointer', 'ui-power', 'ui-press', 'ui-previous', 'ui-rate-add', 'ui-rate-blank', 'ui-rate-remove', 'ui-rating', 'ui-record', 'ui-remove', 'ui-reply', 'ui-rotation', 'ui-rss', 'ui-search', 'ui-settings', 'ui-social-link', 'ui-tag', 'ui-text-chat', 'ui-text-loading', 'ui-theme', 'ui-timer', 'ui-touch-phone', 'ui-travel', 'ui-unlock', 'ui-user-group', 'ui-user', 'ui-v-card', 'ui-video-chat', 'ui-video-message', 'ui-video-play', 'ui-video', 'ui-volume', 'ui-weather', 'ui-wifi', 'ui-zoom-in', 'ui-zoom-out', 'cassette-player', 'cassette', 'forward', 'guiter', 'movie', 'multimedia', 'music-alt', 'music-disk', 'music-note', 'music-notes', 'music', 'mute-volume', 'pause', 'play-alt-1', 'play-alt-2', 'play-alt-3', 'play-pause', 'play', 'record', 'retro-music-disk', 'rewind', 'song-notes', 'sound-wave-alt', 'sound-wave', 'stop', 'video-alt', 'video-cam', 'video-clapper', 'video', 'volume-bar', 'volume-down', 'volume-mute', 'volume-off', 'volume-up', 'youtube-play', '2checkout-alt', '2checkout', 'amazon-alt', 'amazon', 'american-express-alt', 'american-express', 'apple-pay-alt', 'apple-pay', 'bank-transfer-alt', 'bank-transfer', 'braintree-alt', 'braintree', 'cash-on-delivery-alt', 'cash-on-delivery', 'diners-club-alt-1', 'diners-club-alt-2', 'diners-club-alt-3', 'diners-club', 'discover-alt', 'discover', 'eway-alt', 'eway', 'google-wallet-alt-1', 'google-wallet-alt-2', 'google-wallet-alt-3', 'google-wallet', 'jcb-alt', 'jcb', 'maestro-alt', 'maestro', 'mastercard-alt', 'mastercard', 'payoneer-alt', 'payoneer', 'paypal-alt', 'paypal', 'sage-alt', 'sage', 'skrill-alt', 'skrill', 'stripe-alt', 'stripe', 'visa-alt', 'visa-electron', 'visa', 'western-union-alt', 'western-union', 'boy', 'business-man-alt-1', 'business-man-alt-2', 'business-man-alt-3', 'business-man', 'female', 'funky-man', 'girl-alt', 'girl', 'group', 'hotel-boy-alt', 'hotel-boy', 'kid', 'man-in-glasses', 'people', 'support', 'user-alt-1', 'user-alt-2', 'user-alt-3', 'user-alt-4', 'user-alt-5', 'user-alt-6', 'user-alt-7', 'user-female', 'user-male', 'user-suited', 'user', 'users-alt-1', 'users-alt-2', 'users-alt-3', 'users-alt-4', 'users-alt-5', 'users-alt-6', 'users-social', 'users', 'waiter-alt', 'waiter', 'woman-in-glasses', 'search-1', 'search-2', 'search-document', 'search-folder', 'search-job', 'search-map', 'search-property', 'search-restaurant', 'search-stock', 'search-user', 'search', '500px', 'aim', 'badoo', 'baidu-tieba', 'bbm-messenger', 'bebo', 'behance', 'blogger', 'bootstrap', 'brightkite', 'cloudapp', 'concrete5', 'delicious', 'designbump', 'designfloat', 'deviantart', 'digg', 'discord', 'dotcms', 'dribbble', 'dribble', 'dropbox', 'ebuddy', 'ello', 'ember', 'envato', 'evernote', 'facebook-messenger', 'facebook', 'feedburner', 'flikr', 'folkd', 'foursquare', 'friendfeed', 'ghost', 'github', 'gnome', 'google-buzz', 'google-hangouts', 'google-map', 'google-plus', 'google-talk', 'hype-machine', 'instagram', 'kakaotalk', 'kickstarter', 'kik', 'kiwibox', 'line-messenger', 'line', 'linkedin', 'linux-mint', 'live-messenger', 'livejournal', 'magento', 'meetme', 'meetup', 'mixx', 'newsvine', 'nimbuss', 'odnoklassniki', 'opencart', 'oscommerce', 'pandora', 'photobucket', 'picasa', 'pinterest', 'prestashop', 'qik', 'qq', 'readernaut', 'reddit', 'renren', 'rss', 'shopify', 'silverstripe', 'skype', 'slack', 'slashdot', 'slidshare', 'smugmug', 'snapchat', 'soundcloud', 'spotify', 'stack-exchange', 'stack-overflow', 'steam', 'stumbleupon', 'tagged', 'technorati', 'telegram', 'tiktok', 'tinder', 'trello', 'tumblr', 'twitch', 'twitter', 'x-twitter', 'typo3', 'ubercart', 'viber', 'viddler', 'vimeo', 'vine', 'virb', 'virtuemart', 'vk', 'wechat', 'weibo', 'whatsapp', 'xing', 'yahoo', 'yelp', 'youku', 'youtube', 'zencart', 'badminton-birdie', 'baseball', 'baseballer', 'basketball-hoop', 'basketball', 'billiard-ball', 'boot-alt-1', 'boot-alt-2', 'boot', 'bowling-alt', 'bowling', 'canoe', 'cheer-leader', 'climbing', 'corner', 'field-alt', 'field', 'football-alt', 'football-american', 'football', 'foul', 'goal-keeper', 'goal', 'golf-alt', 'golf-bag', 'golf-cart', 'golf-field', 'golf', 'golfer', 'helmet', 'hockey-alt', 'hockey', 'ice-skate', 'jersey-alt', 'jersey', 'jumping', 'kick', 'leg', 'match-review', 'medal-sport', 'offside', 'olympic-logo', 'olympic', 'padding', 'penalty-card', 'racer', 'racing-car', 'racing-flag-alt', 'racing-flag', 'racings-wheel', 'referee', 'refree-jersey', 'result-sport', 'rugby-ball', 'rugby-player', 'rugby', 'runner-alt-1', 'runner-alt-2', 'runner', 'score-board', 'skiing-man', 'skydiving-goggles', 'snow-mobile', 'steering', 'stopwatch', 'substitute', 'swimmer', 'table-tennis', 'team-alt', 'team', 'tennis-player', 'tennis', 'tracking', 'trophy-alt', 'trophy', 'volleyball-alt', 'volleyball-fire', 'volleyball', 'water-bottle', 'whistle-alt', 'whistle', 'win-trophy', 'align-center', 'align-left', 'align-right', 'all-caps', 'bold', 'brush', 'clip-board', 'code-alt', 'color-bucket', 'color-picker', 'copy-invert', 'copy', 'cut', 'delete-alt', 'edit-alt', 'eraser-alt', 'font', 'heading', 'indent', 'italic-alt', 'italic', 'justify-all', 'justify-center', 'justify-left', 'justify-right', 'link-broken', 'outdent', 'paper-clip', 'paragraph', 'pin', 'printer', 'redo', 'rotation', 'save', 'small-cap', 'strike-through', 'sub-listing', 'subscript', 'superscript', 'table', 'text-height', 'text-width', 'trash', 'underline', 'undo', 'air-balloon', 'airplane-alt', 'airplane', 'articulated-truck', 'auto-mobile', 'auto-rickshaw', 'bicycle-alt-1', 'bicycle-alt-2', 'bicycle', 'bus-alt-1', 'bus-alt-2', 'bus-alt-3', 'bus', 'cab', 'cable-car', 'car-alt-1', 'car-alt-2', 'car-alt-3', 'car-alt-4', 'car', 'delivery-time', 'fast-delivery', 'fire-truck-alt', 'fire-truck', 'free-delivery', 'helicopter', 'motor-bike-alt', 'motor-bike', 'motor-biker', 'oil-truck', 'rickshaw', 'rocket-alt-1', 'rocket-alt-2', 'rocket', 'sail-boat-alt-1', 'sail-boat-alt-2', 'sail-boat', 'scooter', 'sea-plane', 'ship-alt', 'ship', 'speed-boat', 'taxi', 'tractor', 'train-line', 'train-steam', 'tram', 'truck-alt', 'truck-loaded', 'truck', 'van-alt', 'van', 'yacht', '5-star-hotel', 'air-ticket', 'beach-bed', 'beach', 'camping-vest', 'direction-sign', 'hill-side', 'hill', 'hotel', 'island-alt', 'island', 'sandals-female', 'sandals-male', 'travelling', 'breakdown', 'celsius', 'clouds', 'cloudy', 'dust', 'eclipse', 'fahrenheit', 'forest-fire', 'full-night', 'full-sunny', 'hail-night', 'hail-rainy-night', 'hail-rainy-sunny', 'hail-rainy', 'hail-sunny', 'hail-thunder-night', 'hail-thunder-sunny', 'hail-thunder', 'hail', 'hill-night', 'hill-sunny', 'hurricane', 'meteor', 'night', 'rainy-night', 'rainy-sunny', 'rainy-thunder', 'rainy', 'snow-alt', 'snow-flake', 'snow-temp', 'snow', 'snowy-hail', 'snowy-night-hail', 'snowy-night-rainy', 'snowy-night', 'snowy-rainy', 'snowy-sunny-hail', 'snowy-sunny-rainy', 'snowy-sunny', 'snowy-thunder-night', 'snowy-thunder-sunny', 'snowy-thunder', 'snowy-windy-night', 'snowy-windy-sunny', 'snowy-windy', 'snowy', 'sun-alt', 'sun-rise', 'sun-set', 'sun', 'sunny-day-temp', 'sunny', 'thunder-light', 'tornado', 'umbrella-alt', 'umbrella', 'volcano', 'wave', 'wind-scale-0', 'wind-scale-1', 'wind-scale-10', 'wind-scale-11', 'wind-scale-12', 'wind-scale-2', 'wind-scale-3', 'wind-scale-4', 'wind-scale-5', 'wind-scale-6', 'wind-scale-7', 'wind-scale-8', 'wind-scale-9', 'wind-waves', 'wind', 'windy-hail', 'windy-night', 'windy-raining', 'windy-sunny', 'windy-thunder-raining', 'windy-thunder', 'windy', 'cycling-alt', 'cycling', 'dumbbell', 'dumbbells', 'gym-alt-1', 'gym-alt-2', 'gym-alt-3', 'gym', 'muscle-weight', 'muscle', 'file-alt', 'file-audio', 'file-avi-mp4', 'file-bmp', 'file-code', 'file-css', 'file-document', 'file-eps', 'file-excel', 'file-exe', 'file-file', 'file-flv', 'file-gif', 'file-html5', 'file-image', 'file-iso', 'file-java', 'file-javascript', 'file-jpg', 'file-midi', 'file-mov', 'file-mp3', 'file-pdf', 'file-php', 'file-png', 'file-powerpoint', 'file-presentation', 'file-psb', 'file-psd', 'file-python', 'file-ruby', 'file-spreadsheet', 'file-sql', 'file-svg', 'file-text', 'file-tiff', 'file-video', 'file-wave', 'file-wmv', 'file-word', 'file-zip', 'angry', 'astonished', 'confounded', 'confused', 'crying', 'dizzy', 'expressionless', 'heart-eyes', 'laughing', 'nerd-smile', 'open-mouth', 'rage', 'rolling-eyes', 'sad', 'simple-smile', 'slightly-smile', 'smirk', 'stuck-out-tongue', 'wink-smile', 'worried', 'abc', 'atom', 'award', 'bell-alt', 'black-board', 'book-alt', 'book', 'brainstorming', 'certificate-alt-1', 'certificate-alt-2', 'certificate', 'education', 'electron', 'fountain-pen', 'globe-alt', 'graduate-alt', 'graduate', 'group-students', 'hat-alt', 'hat', 'instrument', 'lamp-light', 'medal', 'microscope-alt', 'microscope', 'paper', 'pen-alt-4', 'pen-nib', 'pencil-alt-5', 'quill-pen', 'read-book-alt', 'read-book', 'school-bag', 'school-bus', 'student-alt', 'student', 'teacher', 'test-bulb', 'test-tube-alt', 'university', 'arrow-down', 'arrow-left', 'arrow-right', 'arrow-up', 'block-down', 'block-left', 'block-right', 'block-up', 'bubble-down', 'bubble-left', 'bubble-right', 'bubble-up', 'caret-down', 'caret-left', 'caret-right', 'caret-up', 'circled-down', 'circled-left', 'circled-right', 'circled-up', 'collapse', 'cursor-drag', 'curved-double-left', 'curved-double-right', 'curved-down', 'curved-left', 'curved-right', 'curved-up', 'dotted-down', 'dotted-left', 'dotted-right', 'dotted-up', 'double-left', 'double-right', 'expand-alt', 'hand-down', 'hand-drag', 'hand-drag1', 'hand-drag2', 'hand-drawn-alt-down', 'hand-drawn-alt-left', 'hand-drawn-alt-right', 'hand-drawn-alt-up', 'hand-drawn-down', 'hand-drawn-left', 'hand-drawn-right', 'hand-drawn-up', 'hand-grippers', 'hand-left', 'hand-right', 'hand-up', 'line-block-down', 'line-block-left', 'line-block-right', 'line-block-up', 'long-arrow-down', 'long-arrow-left', 'long-arrow-right', 'long-arrow-up', 'rounded-collapse', 'rounded-double-left', 'rounded-double-right', 'rounded-down', 'rounded-expand', 'rounded-left-down', 'rounded-left-up', 'rounded-left', 'rounded-right-down', 'rounded-right-up', 'rounded-right', 'rounded-up', 'scroll-bubble-down', 'scroll-bubble-left', 'scroll-bubble-right', 'scroll-bubble-up', 'scroll-double-down', 'scroll-double-left', 'scroll-double-right', 'scroll-double-up', 'scroll-down', 'scroll-left', 'scroll-long-down', 'scroll-long-left', 'scroll-long-right', 'scroll-long-up', 'scroll-right', 'scroll-up', 'simple-down', 'simple-left-down', 'simple-left-up', 'simple-left', 'simple-right-down', 'simple-right-up', 'simple-right', 'simple-up', 'square-down', 'square-left', 'square-right', 'square-up', 'stylish-down', 'stylish-left', 'stylish-right', 'stylish-up', 'swoosh-down', 'swoosh-left', 'swoosh-right', 'swoosh-up', 'thin-double-left', 'thin-double-right', 'thin-down', 'thin-left', 'thin-right', 'thin-up', 'android-nexus', 'android-tablet', 'apple-watch', 'drawing-tablet', 'earphone', 'flash-drive', 'game-console', 'game-controller', 'game-pad', 'game', 'headphone-alt-1', 'headphone-alt-2', 'headphone-alt-3', 'headphone-alt', 'headphone', 'htc-one', 'imac', 'ipad', 'iphone', 'ipod-nano', 'ipod-touch', 'keyboard-alt', 'keyboard-wireless', 'keyboard', 'laptop-alt', 'laptop', 'macbook', 'magic-mouse', 'micro-chip', 'microphone-alt', 'microphone', 'monitor', 'mouse', 'mp3-player', 'nintendo', 'playstation-alt', 'psvita', 'radio-mic', 'radio', 'refrigerator', 'samsung-galaxy', 'surface-tablet', 'ui-head-phone', 'ui-keyboard', 'washing-machine', 'wifi-router', 'wii-u', 'windows-lumia', 'wireless-mouse', 'xbox-360', 'afghani-false', 'afghani-minus', 'afghani-plus', 'afghani-true', 'afghani', 'baht-false', 'baht-minus', 'baht-plus', 'baht-true', 'baht', 'bitcoin-false', 'bitcoin-minus', 'bitcoin-plus', 'bitcoin-true', 'bitcoin', 'dollar-flase', 'dollar-minus', 'dollar-plus', 'dollar-true', 'dollar', 'dong-false', 'dong-minus', 'dong-plus', 'dong-true', 'dong', 'euro-false', 'euro-minus', 'euro-plus', 'euro-true', 'euro', 'frank-false', 'frank-minus', 'frank-plus', 'frank-true', 'frank', 'hryvnia-false', 'hryvnia-minus', 'hryvnia-plus', 'hryvnia-true', 'hryvnia', 'lira-false', 'lira-minus', 'lira-plus', 'lira-true', 'lira', 'peseta-false', 'peseta-minus', 'peseta-plus', 'peseta-true', 'peseta', 'peso-false', 'peso-minus', 'peso-plus', 'peso-true', 'peso', 'pound-false', 'pound-minus', 'pound-plus', 'pound-true', 'pound', 'renminbi-false', 'renminbi-minus', 'renminbi-plus', 'renminbi-true', 'renminbi', 'riyal-false', 'riyal-minus', 'riyal-plus', 'riyal-true', 'riyal', 'rouble-false', 'rouble-minus', 'rouble-plus', 'rouble-true', 'rouble', 'rupee-false', 'rupee-minus', 'rupee-plus', 'rupee-true', 'rupee', 'taka-false', 'taka-minus', 'taka-plus', 'taka-true', 'taka', 'turkish-lira-false', 'turkish-lira-minus', 'turkish-lira-plus', 'turkish-lira-true', 'turkish-lira', 'won-false', 'won-minus', 'won-plus', 'won-true', 'won', 'yen-false', 'yen-minus', 'yen-plus', 'yen-true', 'yen', 'architecture-alt', 'architecture', 'barricade', 'bolt', 'bricks', 'building-alt', 'bull-dozer', 'calculations', 'cement-mix', 'cement-mixer', 'concrete-mixer', 'danger-zone', 'drill', 'eco-energy', 'eco-environmen', 'energy-air', 'energy-oil', 'energy-savings', 'energy-solar', 'energy-water', 'engineer', 'fire-extinguisher-alt', 'fire-extinguisher', 'fix-tools', 'fork-lift', 'glue-oil', 'hammer-alt', 'hammer', 'help-robot', 'industries-1', 'industries-2', 'industries-3', 'industries-4', 'industries-5', 'industries', 'labour', 'mining', 'paint-brush', 'pollution', 'power-zone', 'radio-active', 'recycle-alt', 'recycling-man', 'safety-hat-light', 'safety-hat', 'saw', 'screw-driver', 'tools-1', 'tools-bag', 'tow-truck', 'trolley', 'trowel', 'under-construction-alt', 'under-construction', 'vehicle-cement', 'vehicle-crane', 'vehicle-delivery-van', 'vehicle-dozer', 'vehicle-excavator', 'vehicle-trucktor', 'vehicle-wrecking', 'worker', 'workers-group', 'wrench', 'chart-arrows-axis', 'chart-bar-graph', 'chart-flow-1', 'chart-flow-2', 'chart-flow', 'chart-growth', 'chart-histogram-alt', 'chart-histogram', 'chart-line-alt', 'chart-line', 'chart-pie-alt', 'chart-pie', 'chart-radar-graph', 'bank-alt', 'bank', 'barcode', 'bill-alt', 'billboard', 'briefcase-1', 'briefcase-2', 'businessman', 'businesswoman', 'chair', 'coins', 'company', 'contact-add', 'files-stack', 'handshake-deal', 'id-card', 'meeting-add', 'money-bag', 'pie-chart', 'presentation-alt', 'presentation', 'stamp', 'stock-mobile', 'brand-acer', 'brand-adidas', 'brand-adobe', 'brand-air-new-zealand', 'brand-airbnb', 'brand-aircell', 'brand-airtel', 'brand-alcatel', 'brand-alibaba', 'brand-aliexpress', 'brand-alipay', 'brand-amazon', 'brand-amd', 'brand-american-airlines', 'brand-android-robot', 'brand-android', 'brand-aol', 'brand-apple', 'brand-appstore', 'brand-asus', 'brand-ati', 'brand-att', 'brand-audi', 'brand-axiata', 'brand-bada', 'brand-bbc', 'brand-bing', 'brand-blackberry', 'brand-bmw', 'brand-box', 'brand-burger-king', 'brand-business-insider', 'brand-buzzfeed', 'brand-cannon', 'brand-casio', 'brand-china-mobile', 'brand-china-telecom', 'brand-china-unicom', 'brand-cisco', 'brand-citibank', 'brand-cnet', 'brand-cnn', 'brand-cocal-cola', 'brand-compaq', 'brand-debian', 'brand-delicious', 'brand-dell', 'brand-designbump', 'brand-designfloat', 'brand-disney', 'brand-dodge', 'brand-dove', 'brand-drupal', 'brand-ebay', 'brand-eleven', 'brand-emirates', 'brand-espn', 'brand-etihad-airways', 'brand-etisalat', 'brand-etsy', 'brand-fastrack', 'brand-fedex', 'brand-ferrari', 'brand-fitbit', 'brand-flikr', 'brand-forbes', 'brand-foursquare', 'brand-foxconn', 'brand-fujitsu', 'brand-general-electric', 'brand-gillette', 'brand-gizmodo', 'brand-gnome', 'brand-google', 'brand-gopro', 'brand-gucci', 'brand-hallmark', 'brand-hi5', 'brand-honda', 'brand-hp', 'brand-hsbc', 'brand-htc', 'brand-huawei', 'brand-hulu', 'brand-hyundai', 'brand-ibm', 'brand-icofont', 'brand-icq', 'brand-ikea', 'brand-imdb', 'brand-indiegogo', 'brand-intel', 'brand-ipair', 'brand-jaguar', 'brand-java', 'brand-joomla', 'brand-kickstarter', 'brand-kik', 'brand-lastfm', 'brand-lego', 'brand-lenovo', 'brand-levis', 'brand-lexus', 'brand-lg', 'brand-life-hacker', 'brand-linux-mint', 'brand-linux', 'brand-lionix', 'brand-loreal', 'brand-louis-vuitton', 'brand-mac-os', 'brand-marvel-app', 'brand-mashable', 'brand-mazda', 'brand-mcdonals', 'brand-mercedes', 'brand-micromax', 'brand-microsoft', 'brand-mobileme', 'brand-mobily', 'brand-motorola', 'brand-msi', 'brand-mts', 'brand-myspace', 'brand-mytv', 'brand-nasa', 'brand-natgeo', 'brand-nbc', 'brand-nescafe', 'brand-nestle', 'brand-netflix', 'brand-nexus', 'brand-nike', 'brand-nokia', 'brand-nvidia', 'brand-omega', 'brand-opensuse', 'brand-oracle', 'brand-panasonic', 'brand-paypal', 'brand-pepsi', 'brand-philips', 'brand-pizza-hut', 'brand-playstation', 'brand-puma', 'brand-qatar-air', 'brand-qvc', 'brand-readernaut', 'brand-redbull', 'brand-reebok', 'brand-reuters', 'brand-samsung', 'brand-sap', 'brand-saudia-airlines', 'brand-scribd', 'brand-shell', 'brand-siemens', 'brand-sk-telecom', 'brand-slideshare', 'brand-smashing-magazine', 'brand-snapchat', 'brand-sony-ericsson', 'brand-sony', 'brand-soundcloud', 'brand-sprint', 'brand-squidoo', 'brand-starbucks', 'brand-stc', 'brand-steam', 'brand-suzuki', 'brand-symbian', 'brand-t-mobile', 'brand-tango', 'brand-target', 'brand-tata-indicom', 'brand-techcrunch', 'brand-telenor', 'brand-teliasonera', 'brand-tesla', 'brand-the-verge', 'brand-thenextweb', 'brand-toshiba', 'brand-toyota', 'brand-tribenet', 'brand-ubuntu', 'brand-unilever', 'brand-vaio', 'brand-verizon', 'brand-viber', 'brand-vodafone', 'brand-volkswagen', 'brand-walmart', 'brand-warnerbros', 'brand-whatsapp', 'brand-wikipedia', 'brand-windows', 'brand-wire', 'brand-wordpress', 'brand-xiaomi', 'brand-yahoobuzz', 'brand-yamaha', 'brand-youtube', 'brand-zain', 'figma', 'illustrator', 'photoshop', 'bat', 'bear-face', 'bear-tracks', 'bear', 'bird-alt', 'bird-flying', 'bird', 'birds', 'bone', 'bull', 'butterfly-alt', 'butterfly', 'camel-alt', 'camel-head', 'camel', 'cat-alt-1', 'cat-alt-2', 'cat-alt-3', 'cat-dog', 'cat-face', 'cat', 'cow-head', 'cow', 'crab', 'crocodile', 'deer-head', 'dog-alt', 'dog-barking', 'dog', 'dolphin', 'duck-tracks', 'eagle-head', 'eaten-fish', 'elephant-alt', 'elephant-head-alt', 'elephant-head', 'elephant', 'elk', 'fish-1', 'fish-2', 'fish-3', 'fish-4', 'fish-5', 'fish', 'fox-alt', 'fox', 'frog-tracks', 'frog', 'froggy', 'giraffe-head-1', 'giraffe-head-2', 'giraffe-head', 'giraffe', 'goat-head', 'gorilla', 'hen-tracks', 'horse-head-1', 'horse-head-2', 'horse-head', 'horse-tracks', 'jellyfish', 'kangaroo', 'lemur', 'lion-head-1', 'lion-head-2', 'lion-head', 'lion', 'monkey-2', 'monkey-3', 'monkey-face', 'monkey', 'octopus-alt', 'octopus', 'owl', 'panda-face', 'panda', 'panther', 'parrot-lip', 'parrot', 'paw', 'pelican', 'penguin', 'pig-face', 'pig', 'pigeon-1', 'pigeon-2', 'pigeon', 'rabbit', 'rat', 'rhino-head', 'rhino', 'rooster', 'seahorse', 'seal', 'shrimp-alt', 'shrimp', 'snail-1', 'snail-2', 'snail-3', 'snail', 'snake', 'squid', 'squirrel', 'tiger-face', 'tiger', 'turtle', 'whale', 'woodpecker', 'zebra', 'angry-monster', 'bathtub', 'bird-wings', 'bow', 'castle', 'circuit', 'crown-king', 'crown-queen', 'dart', 'disability-race', 'diving-goggle', 'eye-open', 'flora-flower', 'flora', 'gift-box', 'halloween-pumpkin', 'hand-power', 'hand-thunder', 'king-monster', 'love', 'magician-hat', 'native-american', 'owl-look', 'phoenix', 'robot-face', 'sand-clock', 'shield-alt', 'ship-wheel', 'skull-danger', 'skull-face', 'snowmobile', 'space-shuttle', 'star-shape', 'swirl', 'tattoo-wing', 'throne', 'tree-alt', 'triangle', 'unity-hand', 'weed', 'woman-bird', 'burglar', 'cannon-firing', 'cc-camera', 'cop-badge', 'cop', 'court-hammer', 'court', 'finger-print', 'gavel', 'handcuff-alt', 'handcuff', 'investigation', 'investigator', 'jail', 'judge', 'law-alt-1', 'law-alt-2', 'law-alt-3', 'law-book', 'law-document', 'law-order', 'law-protect', 'law-scales', 'law', 'lawyer-alt-1', 'lawyer-alt-2', 'lawyer', 'legal', 'pistol', 'police-badge', 'police-cap', 'police-car-alt-1', 'police-car-alt-2', 'police-car', 'police-hat', 'police-van', 'police', 'thief-alt', 'thief');
    }

}

if (!function_exists('eead_eleganticons_array')) {

    function eead_eleganticons_array() {
        return array("arrow_up", "arrow_down", "arrow_left", "arrow_right", "arrow_left-up", "arrow_right-up", "arrow_right-down", "arrow_left-down", "arrow-up-down", "arrow_up-down_alt", "arrow_left-right_alt", "arrow_left-right", "arrow_expand_alt2", "arrow_expand_alt", "arrow_condense", "arrow_expand", "arrow_move", "arrow_carrot-up", "arrow_carrot-down", "arrow_carrot-left", "arrow_carrot-right", "arrow_carrot-2up", "arrow_carrot-2down", "arrow_carrot-2left", "arrow_carrot-2right", "arrow_carrot-up_alt2", "arrow_carrot-down_alt2", "arrow_carrot-left_alt2", "arrow_carrot-right_alt2", "arrow_carrot-2up_alt2", "arrow_carrot-2down_alt2", "arrow_carrot-2left_alt2", "arrow_carrot-2right_alt2", "arrow_triangle-up", "arrow_triangle-down", "arrow_triangle-left", "arrow_triangle-right", "arrow_triangle-up_alt2", "arrow_triangle-down_alt2", "arrow_triangle-left_alt2", "arrow_triangle-right_alt2", "arrow_back", "icon_minus-06", "icon_plus", "icon_close", "icon_check", "icon_minus_alt2", "icon_plus_alt2", "icon_close_alt2", "icon_check_alt2", "icon_zoom-out_alt", "icon_zoom-in_alt", "icon_search", "icon_box-empty", "icon_box-selected", "icon_minus-box", "icon_plus-box", "icon_box-checked", "icon_circle-empty", "icon_circle-slelected", "icon_stop_alt2", "icon_stop", "icon_pause_alt2", "icon_pause", "icon_menu", "icon_menu-square_alt2", "icon_menu-circle_alt2", "icon_ul", "icon_ol", "icon_adjust-horiz", "icon_adjust-vert", "icon_document_alt", "icon_documents_alt", "icon_pencil", "icon_pencil-edit_alt", "icon_pencil-edit", "icon_folder-alt", "icon_folder-open_alt", "icon_folder-add_alt", "icon_info_alt", "icon_error-oct_alt", "icon_error-circle_alt", "icon_error-triangle_alt", "icon_question_alt2", "icon_question", "icon_comment_alt", "icon_chat_alt", "icon_vol-mute_alt", "icon_volume-low_alt", "icon_volume-high_alt", "icon_quotations", "icon_quotations_alt2", "icon_clock_alt", "icon_lock_alt", "icon_lock-open_alt", "icon_key_alt", "icon_cloud_alt", "icon_cloud-upload_alt", "icon_cloud-download_alt", "icon_image", "icon_images", "icon_lightbulb_alt", "icon_gift_alt", "icon_house_alt", "icon_genius", "icon_mobile", "icon_tablet", "icon_laptop", "icon_desktop", "icon_camera_alt", "icon_mail_alt", "icon_cone_alt", "icon_ribbon_alt", "icon_bag_alt", "icon_creditcard", "icon_cart_alt", "icon_paperclip", "icon_tag_alt", "icon_tags_alt", "icon_trash_alt", "icon_cursor_alt", "icon_mic_alt", "icon_compass_alt", "icon_pin_alt", "icon_pushpin_alt", "icon_map_alt", "icon_drawer_alt", "icon_toolbox_alt", "icon_book_alt", "icon_calendar", "icon_film", "icon_table", "icon_contacts_alt", "icon_headphones", "icon_lifesaver", "icon_piechart", "icon_refresh", "icon_link_alt", "icon_link", "icon_loading", "icon_blocked", "icon_archive_alt", "icon_heart_alt", "icon_star_alt", "icon_star-half_alt", "icon_star", "icon_star-half", "icon_tools", "icon_tool", "icon_cog", "icon_cogs", "arrow_up_alt", "arrow_down_alt", "arrow_left_alt", "arrow_right_alt", "arrow_left-up_alt", "arrow_right-up_alt", "arrow_right-down_alt", "arrow_left-down_alt", "arrow_condense_alt", "arrow_expand_alt3", "arrow_carrot_up_alt", "arrow_carrot-down_alt", "arrow_carrot-left_alt", "arrow_carrot-right_alt", "arrow_carrot-2up_alt", "arrow_carrot-2dwnn_alt", "arrow_carrot-2left_alt", "arrow_carrot-2right_alt", "arrow_triangle-up_alt", "arrow_triangle-down_alt", "arrow_triangle-left_alt", "arrow_triangle-right_alt", "icon_minus_alt", "icon_plus_alt", "icon_close_alt", "icon_check_alt", "icon_zoom-out", "icon_zoom-in", "icon_stop_alt", "icon_menu-square_alt", "icon_menu-circle_alt", "icon_document", "icon_documents", "icon_pencil_alt", "icon_folder", "icon_folder-open", "icon_folder-add", "icon_folder_upload", "icon_folder_download", "icon_info", "icon_error-circle", "icon_error-oct", "icon_error-triangle", "icon_question_alt", "icon_comment", "icon_chat", "icon_vol-mute", "icon_volume-low", "icon_volume-high", "icon_quotations_alt", "icon_clock", "icon_lock", "icon_lock-open", "icon_key", "icon_cloud", "icon_cloud-upload", "icon_cloud-download", "icon_lightbulb", "icon_gift", "icon_house", "icon_camera", "icon_mail", "icon_cone", "icon_ribbon", "icon_bag", "icon_cart", "icon_tag", "icon_tags", "icon_trash", "icon_cursor", "icon_mic", "icon_compass", "icon_pin", "icon_pushpin", "icon_map", "icon_drawer", "icon_toolbox", "icon_book", "icon_contacts", "icon_archive", "icon_heart", "icon_profile", "icon_group", "icon_grid-2x2", "icon_grid-3x3", "icon_music", "icon_pause_alt", "icon_phone", "icon_upload", "icon_download", "icon_printer", "icon_calulator", "icon_building", "icon_floppy", "icon_drive", "icon_search-2", "icon_id", "icon_id-2", "icon_puzzle", "icon_like", "icon_dislike", "icon_mug", "icon_currency", "icon_wallet", "icon_pens", "icon_easel", "icon_flowchart", "icon_datareport", "icon_briefcase", "icon_shield", "icon_percent", "icon_globe", "icon_globe-2", "icon_target", "icon_hourglass", "icon_balance", "icon_rook", "icon_printer-alt", "icon_calculator_alt", "icon_building_alt", "icon_floppy_alt", "icon_drive_alt", "icon_search_alt", "icon_id_alt", "icon_id-2_alt", "icon_puzzle_alt", "icon_like_alt", "icon_dislike_alt", "icon_mug_alt", "icon_currency_alt", "icon_wallet_alt", "icon_pens_alt", "icon_easel_alt", "icon_flowchart_alt", "icon_datareport_alt", "icon_briefcase_alt", "icon_shield_alt", "icon_percent_alt", "icon_globe_alt", "icon_clipboard", "social_facebook", "social_twitter", "social_pinterest", "social_googleplus", "social_tumblr", "social_tumbleupon", "social_wordpress", "social_instagram", "social_dribbble", "social_vimeo", "social_linkedin", "social_rss", "social_deviantart", "social_share", "social_myspace", "social_skype", "social_youtube", "social_picassa", "social_googledrive", "social_flickr", "social_blogger", "social_spotify", "social_delicious", "social_facebook_circle", "social_twitter_circle", "social_pinterest_circle", "social_googleplus_circle", "social_tumblr_circle", "social_stumbleupon_circle", "social_wordpress_circle", "social_instagram_circle", "social_dribbble_circle", "social_vimeo_circle", "social_linkedin_circle", "social_rss_circle", "social_deviantart_circle", "social_share_circle", "social_myspace_circle", "social_skype_circle", "social_youtube_circle", "social_picassa_circle", "social_googledrive_alt2", "social_flickr_circle", "social_blogger_circle", "social_spotify_circle", "social_delicious_circle", "social_facebook_square", "social_twitter_square", "social_pinterest_square", "social_googleplus_square", "social_tumblr_square", "social_stumbleupon_square", "social_wordpress_square", "social_instagram_square", "social_dribbble_square", "social_vimeo_square", "social_linkedin_square", "social_rss_square", "social_deviantart_square", "social_share_square", "social_myspace_square", "social_skype_square", "social_youtube_square", "social_picassa_square", "social_googledrive_square", "social_flickr_square", "social_blogger_square", "social_spotify_square", "social_delicious_square");
    }

}
