<?php
namespace BdevsElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Bdevs Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class BdevsCounter extends \Elementor\Widget_Base {

    /**
     * Get widget name.
     *
     * Retrieve Bdevs Elementor widget name.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name() {
        return 'bdevs-counter';
    }

    /**
     * Get widget title.
     *
     * Retrieve Bdevs Elementor widget title.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title() {
        return __( 'Counter', 'bdevs-elementor' );
    }

    /**
     * Get widget icon.
     *
     * Retrieve Bdevs Blog widget icon.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-counter';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Bdevs Blog widget belongs to.
     *
     * @since 1.0.0
     * @access public
     *
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'bdevs-elementor' ];
    }

    public function get_keywords() {
        return [ 'counter' ];
    }

    public function get_script_depends() {
        return [ 'bdevs-elementor'];
    }

    // BDT Position
    protected function element_pack_position() {
        $position_options = [
            ''              => esc_html__('Default', 'bdevs-elementor'),
            'top-left'      => esc_html__('Top Left', 'bdevs-elementor') ,
            'top-center'    => esc_html__('Top Center', 'bdevs-elementor') ,
            'top-right'     => esc_html__('Top Right', 'bdevs-elementor') ,
            'center'        => esc_html__('Center', 'bdevs-elementor') ,
            'center-left'   => esc_html__('Center Left', 'bdevs-elementor') ,
            'center-right'  => esc_html__('Center Right', 'bdevs-elementor') ,
            'bottom-left'   => esc_html__('Bottom Left', 'bdevs-elementor') ,
            'bottom-center' => esc_html__('Bottom Center', 'bdevs-elementor') ,
            'bottom-right'  => esc_html__('Bottom Right', 'bdevs-elementor') ,
        ];

        return $position_options;
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'section_content_heading',
            [
                'label' => esc_html__( 'Counter', 'bdevs-elementor' ),
            ]
        );
        $this->add_control(
            'chose_style',
            [
                'label'     => esc_html__( 'Chose Style', 'bdevs-elementor' ),
                'type'      => Controls_Manager::SELECT,
                'options'   => [
                    'ct_style_1'  => esc_html__( 'Style 1', 'bdevs-elementor' ),
                    'ct_style_2'  => esc_html__( 'Style 2', 'bdevs-elementor' ),
                ],
                'default'   => 'ct_style_1',
            ]
        ); 
        $this->add_control(
            'subheading',
            [
                'label'       => __( 'Subheading:', 'bdevs-elementor' ),
                'type'        => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter your subheading', 'bdevs-elementor' ),
                'default'     => __( 'This is subheading', 'bdevs-elementor' ),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'heading',
            [
                'label'       => __( 'Heading:', 'bdevs-elementor' ),
                'type'        => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter your heading', 'bdevs-elementor' ),
                'default'     => __( 'This is heading', 'bdevs-elementor' ),
                'label_block' => true,
            ]
        ); 
        $this->add_control(
            'background_image',
            [
                'label'   => esc_html__( 'Background Image', 'bdevs-elementor' ),
                'type'    => Controls_Manager::MEDIA,
                'dynamic' => [ 'active' => true ],
                'description' => esc_html__( 'Add image from here', 'bdevs-elementor' ),
                'condition' => [
                    'chose_style' => ['ct_style_1']
                ],
            ]
        );
        $this->add_control(
            'tabs',
            [
                'label' => esc_html__( 'Items', 'bdevs-elementor' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name'        => 'item_select',
                        'label'     => esc_html__( 'Item Select', 'bdevs-elementor' ),
                        'type'      => Controls_Manager::SELECT,
                        'dynamic' => [ 'active' => true ],
                        'options'   => [
                            '1'  => esc_html__( 'Number', 'bdevs-elementor' ),
                            '2'  => esc_html__( 'Percent', 'bdevs-elementor' ),
                        ],
                        'default'   => '1',
                    ],
                    [
                        'name'        => 'icon',
                        'label'       => esc_html__( 'Icon:', 'bdevs-elementor' ),
                        'type'        => Controls_Manager::TEXT,
                        'dynamic'     => [ 'active' => true ],
                        'default'     => esc_html__( 'This is icon' , 'bdevs-elementor' ),
                        'label_block' => true,
                    ],
                    [
                        'name'        => 'number',
                        'label'       => esc_html__( 'Number:', 'bdevs-elementor' ),
                        'type'        => Controls_Manager::TEXT,
                        'dynamic'     => [ 'active' => true ],
                        'default'     => esc_html__( 'This is number' , 'bdevs-elementor' ),
                        'label_block' => true,
                    ],
                    [
                        'name'        => 'title',
                        'label'       => esc_html__( 'Title:', 'bdevs-elementor' ),
                        'type'        => Controls_Manager::TEXT,
                        'dynamic'     => [ 'active' => true ],
                        'default'     => esc_html__( 'This is title' , 'bdevs-elementor' ),
                        'label_block' => true,
                    ],
                ],
            ]
        );
        
        $this->end_controls_section();

        $this->start_controls_section(
            'section_content_layout',
            [
                'label' => esc_html__( 'Layout', 'bdevs-elementor' ),
            ]
        );

        $this->add_responsive_control(
            'align',
            [
                'label'   => esc_html__( 'Alignment', 'bdevs-elementor' ),
                'type'    => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'bdevs-elementor' ),
                        'icon'  => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'bdevs-elementor' ),
                        'icon'  => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'bdevs-elementor' ),
                        'icon'  => 'fa fa-align-right',
                    ],
                    'justify' => [
                        'title' => esc_html__( 'Justified', 'bdevs-elementor' ),
                        'icon'  => 'fa fa-align-justify',
                    ],
                ],
                'prefix_class' => 'elementor%s-align-',
                'description'  => 'Use align to match position',
                'default'      => 'left',
            ]
        ); 
        $this->add_control(
            'show_heading',
            [
                'label'   => esc_html__( 'Show Heading', 'bdevs-elementor' ),
                'type'    => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        ); 
        $this->end_controls_section();
    }
    public function render() {
    $settings  = $this->get_settings_for_display(); 
    extract($settings); ?> 
    <?php $chose_style = $settings['chose_style'];?>
    <?php if( $chose_style == 'ct_style_1' ): ?>
    <!-- Start Why Choose Section -->
    <section class="why-choose padding-lg">
        <style type="text/css">
            .why-choose:after{
                background: url(<?php echo wp_kses_post($settings['background_image']['url']); ?>) no-repeat center center / cover;
            }
        </style>
        <div class="container">
            <?php if ( $settings['show_heading'] ) : ?>
            <h2>
                <?php if(isset($settings['subheading']) && $settings['subheading'] != ''){?>
                <span><?php print wp_kses_post($settings['subheading']); ?></span>
                <?php } ?>
                <?php print wp_kses_post($settings['heading']); ?>
            </h2>
            <?php endif; ?>
            <ul class="our-strength">
                <?php foreach ( $settings['tabs'] as $item ) : ?>
                <li>
                    <?php if(isset($item['icon']) && $item['icon'] != ''){?>
                    <div class="icon"><span class="<?php print wp_kses_post($item['icon']); ?>"> </span></div>
                    <?php } ?>
                    <?php if( wp_kses_post($item['item_select']) == '1'): ?>
                        <?php if(isset($item['number']) && $item['number'] != ''){?>
                        <span class="counter"><?php print wp_kses_post($item['number']); ?></span>
                        <?php } ?>
                    <?php elseif( wp_kses_post($item['item_select']) == '2'): ?>
                        <div class="couter-outer"><span class="counter"><?php print wp_kses_post($item['number']); ?></span><span>%</span></div>
                    <?php endif; ?>
                    <?php if(isset($item['title']) && $item['title'] != ''){?>
                    <div class="title"><?php print wp_kses_post($item['title']); ?></div>
                    <?php } ?>
                </li>
                <?php endforeach; ?>
            </ul>
        </div>
    </section>
    <!-- End Why Choose Section --> 
    <?php elseif( $chose_style == 'ct_style_2' ): ?>
    <!-- Start Why Choose -->
    <section class="why-choose grey-bg padding-lg">
        <div class="container">
            <?php if ( $settings['show_heading'] ) : ?>
            <h2>
                <?php if(isset($settings['subheading']) && $settings['subheading'] != ''){?>
                <span><?php print wp_kses_post($settings['subheading']); ?></span>
                <?php } ?>
                <?php print wp_kses_post($settings['heading']); ?>
            </h2>
            <?php endif; ?>
            <ul class="our-strength opt2">
                <?php foreach ( $settings['tabs'] as $item ) : ?>
                <li>
                    <?php if(isset($item['icon']) && $item['icon'] != ''){?>
                    <div class="icon"><span class="<?php print wp_kses_post($item['icon']); ?>"> </span></div>
                    <?php } ?>
                    <?php if( wp_kses_post($item['item_select']) == '1'): ?>
                        <?php if(isset($item['number']) && $item['number'] != ''){?>
                        <span class="counter"><?php print wp_kses_post($item['number']); ?></span>
                        <?php } ?>
                    <?php elseif( wp_kses_post($item['item_select']) == '2'): ?>
                        <div class="couter-outer"><span class="counter"><?php print wp_kses_post($item['number']); ?></span><span>%</span></div>
                    <?php endif; ?>
                    <?php if(isset($item['title']) && $item['title'] != ''){?>
                    <div class="title"><?php print wp_kses_post($item['title']); ?></div>
                    <?php } ?>
                </li>
                <?php endforeach; ?>
            </ul>
        </div>
    </section>
    <!-- End Why Choose -->
    <?php endif; ?>
    <?php
    }

}