<?php
/**
 * Radios functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Radios
 */


/**
* Define Dir
*/
define( 'RADIOS_THEME_DRI', get_template_directory() );
define( 'RADIOS_THEME_URI', get_template_directory_uri() );
define( 'RADIOS_CSS_PATH', RADIOS_THEME_URI . '/assets/css' );
define( 'RADIOS_JS_PATH', RADIOS_THEME_URI . '/assets/js' );
define( 'RADIOS_ICON_PATH', RADIOS_THEME_URI . '/assets/fonts/fontawesome/css' );
define( 'RADIOS_IMG_PATH', RADIOS_THEME_URI . '/assets/images' );

/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 */
function radios_setup() {
	/*
		* Make theme available for translation.
		* Translations can be filed in the /languages/ directory.
		* If you're building a theme based on Radios, use a find and replace
		* to change 'radios' to the name of your theme in all the template files.
		*/
	load_theme_textdomain( 'radios', get_template_directory() . '/languages' );

	// Add default posts and comments RSS feed links to head.
	add_theme_support( 'automatic-feed-links' );

	/*
		* Let WordPress manage the document title.
		* By adding theme support, we declare that this theme does not use a
		* hard-coded <title> tag in the document head, and expect WordPress to
		* provide it for us.
		*/
	add_theme_support( 'title-tag' );
	remove_theme_support( 'widgets-block-editor' );

	//Custom Image Size
	add_image_size( 'radios-image-size1', 1450, 790, true );

	//Woocommerc
	add_theme_support( 'woocommerce' );
	add_theme_support( 'wc-product-gallery-lightbox' );
	add_theme_support( 'wc-product-gallery-slider' );

	/*
		* Enable support for Post Thumbnails on posts and pages.
		*
		* @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		*/
	add_theme_support( 'post-thumbnails' );

	// This theme uses wp_nav_menu() in one location.
	register_nav_menus(
		array(
			'main_menu' => esc_html__( 'Main Menu', 'radios' ),
			'cate-menu' => esc_html__( 'Category Menu', 'radios' ),
			'cate-menu2' => esc_html__( 'Category Menu Two', 'radios' ),
		)
	);

	/*
		* Switch default core markup for search form, comment form, and comments
		* to output valid HTML5.
		*/
	add_theme_support(
		'html5',
		array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
			'style',
			'script',
		)
	);

	// Set up the WordPress core custom background feature.
	add_theme_support(
		'custom-background',
		apply_filters(
			'radios_custom_background_args',
			array(
				'default-color' => 'ffffff',
				'default-image' => '',
			)
		)
	);

	// Add theme support for selective refresh for widgets.
	add_theme_support( 'customize-selective-refresh-widgets' );

	/**
	 * Add support for core custom logo.
	 *
	 * @link https://codex.wordpress.org/Theme_Logo
	 */
	add_theme_support(
		'custom-logo',
		array(
			'height'      => 250,
			'width'       => 250,
			'flex-width'  => true,
			'flex-height' => true,
		)
	);
}
add_action( 'after_setup_theme', 'radios_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function radios_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'radios_content_width', 640 );
}
add_action( 'after_setup_theme', 'radios_content_width', 0 );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function radios_widgets_init() {
	register_sidebar(
		array(
			'name'          => esc_html__( 'Sidebar', 'radios' ),
			'id'            => 'sidebar-1',
			'description'   => esc_html__( 'Add widgets here.', 'radios' ),
			'before_widget' => '<section id="%1$s" class="widget mt-40 %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget__title"><span>',
			'after_title'   => '</span></h2>',
		)
	);
	
	register_sidebar(
		array(
			'name'          => esc_html__( 'Footer One', 'radios' ),
			'id'            => 'radios-footer-1',
			'description'   => esc_html__( 'Add Footer here.', 'radios' ),
			'before_widget' => '<div id="%1$s" class="footer-widget %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h2 class="title">',
			'after_title'   => '</h2>',
		)
	);
	register_sidebar(
		array(
			'name'          => esc_html__( 'Footer Two', 'radios' ),
			'id'            => 'radios-footer-2',
			'description'   => esc_html__( 'Add Footer here.', 'radios' ),
			'before_widget' => '<div id="%1$s" class="footer-widget %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h2 class="title">',
			'after_title'   => '</h2>',
		)
	);
	register_sidebar(
		array(
			'name'          => esc_html__( 'Footer Three', 'radios' ),
			'id'            => 'radios-footer-3',
			'description'   => esc_html__( 'Add Footer here.', 'radios' ),
			'before_widget' => '<div id="%1$s" class="footer-widget %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h2 class="title">',
			'after_title'   => '</h2>',
		)
	);
	register_sidebar(
		array(
			'name'          => esc_html__( 'Shop Siderbar', 'radios' ),
			'id'            => 'shop-sidebar-1',
			'description'   => esc_html__( 'Add Shop Sidebar here.', 'radios' ),
			'before_widget' => '<div id="%1$s" class="widget %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h2 class="widget__title"><span>',
			'after_title'   => '</span></h2>',
		)
	);
}
add_action( 'widgets_init', 'radios_widgets_init' );

/**
 *Google Font Load 
 */
if ( ! function_exists( 'radios_fonts_url' ) ) :
    /**
     * Register Google fonts for Blessing.
     */
    function radios_fonts_url() {
        $fonts_url     = '';
        $font_families = array();
        $subsets       = 'latin';


		if ( 'off' !== _x( 'on', 'Roboto: on or off', 'radios' ) ) {
            $font_families[] = 'Roboto:200,300,400,500,600,700,800';
        }

        if ( 'off' !== _x( 'on', 'Inter: on or off', 'radios' ) ) {
            $font_families[] = 'Inter:100,200,300,400,500,600,700,800,900';
        }

        if ( 'off' !== _x( 'on', 'Jost: on or off', 'radios' ) ) {
            $font_families[] = 'Jost:100,100i,200,200i,300,300i,400,400i,500,500i,600,600i,700,700i,800,800i,900,900i';
        }

        if ( $font_families ) {
            $fonts_url = add_query_arg( array(
                'family' => urlencode( implode( '|', $font_families ) ),
                'subset' => urlencode( $subsets ),
            ), 'https://fonts.googleapis.com/css' );
        }

        return esc_url_raw( $fonts_url );
    }
endif;

/**
 * Enqueue scripts and styles.
 */
function radios_scripts() {
	wp_enqueue_style( 'radios-custom-fonts', radios_fonts_url(), array(), null );

	//Radios Stylesheet Load
	wp_enqueue_style( 'bootstrap', RADIOS_CSS_PATH . '/bootstrap.min.css' );
	wp_enqueue_style( 'fontawesome-ri', RADIOS_CSS_PATH . '/fontawesome.css' );
	wp_enqueue_style( 'animate', RADIOS_CSS_PATH . '/animate.css' );
	wp_enqueue_style( 'metisMenu', RADIOS_CSS_PATH . '/metisMenu.css' );
	wp_enqueue_style( 'owl', RADIOS_CSS_PATH . '/owl.css' );
	wp_enqueue_style( 'uikit', RADIOS_CSS_PATH . '/uikit.min.css' );
	wp_enqueue_style( 'slick', RADIOS_CSS_PATH . '/slick.css' );
	wp_enqueue_style( 'magnific-popup', RADIOS_CSS_PATH . '/magnific-popup.css' );

	if ( class_exists( 'WooCommerce' ) ) {
		wp_enqueue_style( 'radios-woocommerce', RADIOS_CSS_PATH . '/woocommerce.css' );
	}

	wp_enqueue_style( 'radios-post-style', RADIOS_CSS_PATH . '/post-style.css' );
	wp_enqueue_style( 'radios-main-two', RADIOS_CSS_PATH . '/style.css' );
	wp_enqueue_style( 'radios-main', RADIOS_CSS_PATH . '/main.css' );
	wp_enqueue_style( 'radios-responsive', RADIOS_CSS_PATH . '/responsive.css' );

	wp_enqueue_style( 'radios-style', get_stylesheet_uri(), array() );
	
	wp_enqueue_script('jquery-ui-core');
	wp_enqueue_script( 'bootstrap', RADIOS_JS_PATH . '/bootstrap.bundle.min.js', array('jquery'), '', true );
	wp_enqueue_script( 'slick', RADIOS_JS_PATH . '/slick.js', array('jquery'), '', true );
	wp_enqueue_script( 'owl', RADIOS_JS_PATH . '/owl.js', array('jquery'), '', true );
	wp_enqueue_script( 'backToTop', RADIOS_JS_PATH . '/backToTop.js', array('jquery'), '', true );
	wp_enqueue_script( 'uikit', RADIOS_JS_PATH . '/uikit.min.js', array('jquery'), '', true );
	wp_enqueue_script( 'resize-sensor', RADIOS_JS_PATH . '/resize-sensor.min.js', array('jquery'), '', true );
	wp_enqueue_script( 'theia-sticky-sidebar', RADIOS_JS_PATH . '/theia-sticky-sidebar.min.js', array('jquery'), '', true );
	wp_enqueue_script( 'wow', RADIOS_JS_PATH . '/wow.min.js', array('jquery'), '', true );
	wp_enqueue_script( 'touchspin', RADIOS_JS_PATH . '/touchspin.js', array('jquery'), '', true );
	wp_enqueue_script( 'countdown', RADIOS_JS_PATH . '/countdown.js', array('jquery'), '', true );
	wp_enqueue_script( 'jquery-magnific-popup', RADIOS_JS_PATH . '/jquery.magnific-popup.min.js', array('jquery'), '', true );
	wp_enqueue_script( 'metisMenu', RADIOS_JS_PATH . '/metisMenu.min.js', array('jquery'), '', true );
	
	wp_enqueue_script( 'radios-main', RADIOS_JS_PATH . '/main.js', array('jquery'), '', true );

	

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'radios_scripts' );

/**
 * Radios Custom Functions
 */
require RADIOS_THEME_DRI . '/inc/radios-functions.php';

/**
 * Radios Plugin Activation
 */
require RADIOS_THEME_DRI . '/lib/plugin-activation.php';

/**
 * Radios Demo Import
 */
require RADIOS_THEME_DRI . '/lib/ocdi/functions.php';

/**
 * Implement the Custom Header feature.
 */
require RADIOS_THEME_DRI . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require RADIOS_THEME_DRI . '/inc/template-tags.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require RADIOS_THEME_DRI . '/inc/template-functions.php';

/**
 * Customizer additions.
 */
require RADIOS_THEME_DRI . '/inc/customizer.php';

require RADIOS_THEME_DRI . '/inc/remove_actions.php';

/**
 * Fremwork Functions.
 */
require RADIOS_THEME_DRI . '/inc/cs-framework-functions.php';

/**
 * navwalker
 */
require RADIOS_THEME_DRI . '/inc/class-wp-radios-navwalker.php';

/**
 * Dynamic Style
 */
require RADIOS_THEME_DRI . '/inc/dynamic-style.php';

/**
 * Load Jetpack compatibility file.
 */
if ( defined( 'JETPACK__VERSION' ) ) {
	require RADIOS_THEME_DRI . '/inc/jetpack.php';
}

/**
 * Woocommerce Hoook Control file.
 */
if ( class_exists( 'WooCommerce' ) ) {
	function radios_woo_theme_init(){
		$radios_exlude_hooks = require RADIOS_THEME_DRI . '/inc/remove_actions.php';
		foreach( $radios_exlude_hooks as $k => $v ){
			foreach( $v as $value )
			remove_action( $k, $value[0], $value[1] );
		}
	}
	add_action( 'init', 'radios_woo_theme_init');
}